/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openmods.api.IPlaceAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFloat;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityFan
extends SyncedTileEntity
implements IPlaceAwareTile {
    private static final double CONE_HALF_APERTURE = 0.6;
    private SyncableFloat angle;
    private float bladeRotation;
    private float bladeRotationSpeed;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat(0.0f);
    }

    public void func_70316_g() {
        int redstonePower = Config.redstoneActivatedFan ? this.field_70331_k.func_94572_D(this.field_70329_l, this.field_70330_m, this.field_70327_n) : 15;
        this.bladeRotationSpeed = (float)redstonePower / 15.0f;
        this.bladeRotation += this.bladeRotationSpeed;
        double maxForce = Config.fanForce * ((double)redstonePower / 15.0);
        if (maxForce <= 0.0) {
            return;
        }
        List entities = this.field_70331_k.func_72872_a(Entity.class, this.getEntitySearchBoundingBox());
        if (entities.isEmpty()) {
            return;
        }
        Vec3 blockPos = this.getConeApex();
        Vec3 basePos = this.getConeBaseCenter();
        Vec3 coneAxis = this.field_70331_k.func_82732_R().func_72345_a(basePos.field_72450_a - blockPos.field_72450_a, basePos.field_72448_b - blockPos.field_72448_b, basePos.field_72449_c - blockPos.field_72449_c);
        for (Entity entity : entities) {
            double distToOrigin;
            double force;
            Vec3 directionVec;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !TileEntityFan.isLyingInSphericalCone(coneAxis, directionVec = this.field_70331_k.func_82732_R().func_72345_a(entity.field_70165_t - blockPos.field_72450_a, entity.field_70163_u - blockPos.field_72448_b, entity.field_70161_v - blockPos.field_72449_c), 0.6) || (force = (1.0 - (distToOrigin = directionVec.func_72433_c()) / Config.fanRange) * maxForce) <= 0.0) continue;
            Vec3 normal = directionVec.func_72432_b();
            entity.field_70159_w += force * normal.field_72450_a;
            entity.field_70179_y += force * normal.field_72449_c;
        }
    }

    private Vec3 getConeBaseCenter() {
        double angle = Math.toRadians(this.getAngle() - 90.0f);
        return this.field_70331_k.func_82732_R().func_72345_a((double)this.field_70329_l + Math.cos(angle) * Config.fanRange, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + Math.sin(angle) * Config.fanRange);
    }

    private Vec3 getConeApex() {
        double angle = Math.toRadians(this.getAngle() - 90.0f);
        return this.field_70331_k.func_82732_R().func_72345_a((double)this.field_70329_l + 0.5 - Math.cos(angle) * 1.1, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5 - Math.sin(angle) * 1.1);
    }

    private AxisAlignedBB getEntitySearchBoundingBox() {
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)(this.field_70330_m - 2), (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1));
        return boundingBox.func_72314_b(Config.fanRange, Config.fanRange, Config.fanRange);
    }

    private static boolean isLyingInSphericalCone(Vec3 coneAxis, Vec3 originToTarget, double halfAperture) {
        double angleToAxisCos = originToTarget.func_72430_b(coneAxis) / originToTarget.func_72433_c() / coneAxis.func_72433_c();
        return angleToAxisCos > Math.cos(halfAperture);
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.angle.setValue(player.field_70759_as);
        this.sync();
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public float getAngle() {
        return this.angle.getValue();
    }

    public float getBladeRotation(float partialTickTime) {
        return this.bladeRotation + this.bladeRotationSpeed * partialTickTime;
    }
}

