/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.api.IActivateAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.GenericFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.ItemUtils;

public class TileEntityTank
extends SyncedTileEntity
implements IActivateAwareTile,
IPlaceAwareTile,
INeighbourAwareTile,
IExtendable {
    private SyncableTank tank;
    private double flowTimer = Math.random() * 100.0;
    private int previousFluidId = 0;
    private boolean forceUpdate = true;
    @IncludeInterface(value=IFluidHandler.class)
    private final GenericFluidHandler tankWrapper = new GenericFluidHandler((IFluidTank)this.tank);

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TileEntityTank.getTankCapacity(), new FluidStack[0]);
    }

    public double getFluidRatio() {
        return (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity();
    }

    private double getFlowOffset() {
        return Math.sin(this.flowTimer) / 35.0;
    }

    public static int getTankCapacity() {
        return 1000 * Config.bucketsPerTank;
    }

    public int getFluidLightLevel() {
        Fluid fluid;
        FluidStack stack = this.tank.getFluid();
        if (stack != null && (fluid = stack.getFluid()) != null) {
            return fluid.getLuminosity();
        }
        return 0;
    }

    public RenderContext createRenderContext() {
        return new RenderContext();
    }

    private boolean accepts(FluidStack liquid) {
        if (liquid == null) {
            return true;
        }
        FluidStack ownFluid = this.tank.getFluid();
        return ownFluid == null || ownFluid.isFluidEqual(liquid);
    }

    private boolean containsFluid(FluidStack liquid) {
        if (liquid == null) {
            return false;
        }
        FluidStack ownFluid = this.tank.getFluid();
        return ownFluid != null && ownFluid.isFluidEqual(liquid);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public NBTTagCompound getItemNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public void onSynced(Set<ISyncableObject> changes) {
        int newFluidId;
        int n = newFluidId = this.tank.getFluid() == null ? -1 : this.tank.getFluid().fluidID;
        if (newFluidId != this.previousFluidId) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.previousFluidId = newFluidId;
    }

    public void onNeighbourChanged(int blockId) {
        this.forceUpdate = true;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && itemTag.func_74764_b("tank")) {
            this.tank.readFromNBT(itemTag.func_74775_l("tank"));
        }
    }

    private TileEntityTank getTankInDirection(ForgeDirection direction) {
        TileEntity neighbor = this.getTileInDirection(direction);
        if (neighbor instanceof TileEntityTank && !neighbor.func_70320_p()) {
            return (TileEntityTank)neighbor;
        }
        return null;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        ItemStack usedItem = player.field_71071_by.func_70448_g();
        if (usedItem != null) {
            return this.tryUseFluidContainer(player, direction, usedItem);
        }
        return this.tryDrainXp(player, direction);
    }

    protected boolean tryDrainXp(EntityPlayer player, ForgeDirection direction) {
        if (this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(OpenBlocks.XP_FLUID)) {
            int xp;
            int currentXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
            int nextLevelXP = EnchantmentUtils.getExperienceForLevel((int)(player.field_71068_ca + 1));
            int requiredXP = nextLevelXP - currentXP;
            int requiredXPJuice = EnchantmentUtils.XPToLiquidRatio((int)requiredXP);
            FluidStack drained = this.drain(direction, requiredXPJuice, false);
            if (drained != null && (xp = EnchantmentUtils.liquidToXPRatio((int)drained.amount)) > 0) {
                int actualDrain = EnchantmentUtils.XPToLiquidRatio((int)xp);
                EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)xp);
                this.drain(direction, actualDrain, true);
                return true;
            }
        }
        return false;
    }

    protected boolean tryUseFluidContainer(EntityPlayer player, ForgeDirection direction, ItemStack current) {
        return this.tryEmptyItem(player, direction, current) || this.tryFillItem(player, direction, current);
    }

    protected boolean tryFillItem(EntityPlayer player, ForgeDirection direction, ItemStack current) {
        FluidStack available = this.tank.getFluid();
        if (available == null || available.amount <= 0) {
            return false;
        }
        if (this.field_70331_k.field_72995_K) {
            return true;
        }
        ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current);
        FluidStack containedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
        if (containedFluid != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                }
            }
            this.drain(direction, containedFluid.amount, true);
            return true;
        }
        return false;
    }

    protected boolean tryEmptyItem(EntityPlayer player, ForgeDirection direction, ItemStack current) {
        FluidStack containedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
        if (containedFluid != null) {
            int qty = this.fill(direction, containedFluid, true);
            if (qty != 0 && !player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
            }
            return true;
        }
        return false;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (Config.shouldTanksUpdate && !this.field_70331_k.field_72995_K && this.forceUpdate) {
            this.forceUpdate = false;
            FluidStack contents = this.tank.getFluid();
            if (contents != null && contents.amount > 0 && this.field_70330_m > 0) {
                this.tryFillBottomTank(contents);
                contents = this.tank.getFluid();
            }
            if (contents != null && contents.amount > 0) {
                this.tryBalanceNeighbors(contents);
            }
            this.sync();
        } else {
            this.flowTimer += (double)0.1f;
        }
    }

    private void tryGetNeighbor(List<TileEntityTank> result, FluidStack fluid, ForgeDirection side) {
        TileEntityTank neighbor = this.getTankInDirection(side);
        if (neighbor != null && neighbor.accepts(fluid)) {
            result.add(neighbor);
        }
    }

    private void tryBalanceNeighbors(FluidStack contents) {
        ArrayList neighbors = Lists.newArrayList();
        this.tryGetNeighbor(neighbors, contents, ForgeDirection.NORTH);
        this.tryGetNeighbor(neighbors, contents, ForgeDirection.SOUTH);
        this.tryGetNeighbor(neighbors, contents, ForgeDirection.EAST);
        this.tryGetNeighbor(neighbors, contents, ForgeDirection.WEST);
        int count = neighbors.size();
        if (count == 0) {
            return;
        }
        int sum = contents.amount;
        for (TileEntityTank n : neighbors) {
            sum += n.tank.getFluidAmount();
        }
        int suggestedAmount = sum / (count + 1);
        FluidStack suggestedStack = contents.copy();
        suggestedStack.amount = suggestedAmount;
        for (TileEntityTank n : neighbors) {
            int amount = n.tank.getFluidAmount();
            int diff = amount - suggestedAmount;
            if (diff != 1 && diff != 0 && diff != -1) {
                n.tank.setFluid(suggestedStack.copy());
                n.tankChanged();
                sum -= suggestedAmount;
                n.forceUpdate = true;
                continue;
            }
            sum -= amount;
        }
        FluidStack s = this.tank.getFluid();
        if (sum != s.amount) {
            s.amount = sum;
            this.tankChanged();
        }
    }

    private void tankChanged() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        this.tank.markDirty();
    }

    private void markUpdated() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        this.forceUpdate = true;
    }

    private void tryFillBottomTank(FluidStack fluid) {
        int amount;
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (te instanceof TileEntityTank && (amount = ((TileEntityTank)te).internalFill(fluid, true)) > 0) {
            this.internalDrain(amount, true);
        }
    }

    private FluidStack internalDrain(int amount, boolean doDrain) {
        FluidStack drained = this.tank.drain(amount, doDrain);
        if (drained != null && doDrain) {
            this.markUpdated();
        }
        return drained;
    }

    private void drainFromColumn(FluidStack needed, boolean doDrain) {
        TileEntity te;
        if (!this.containsFluid(needed) || needed.amount <= 0) {
            return;
        }
        if (this.field_70330_m < 255 && (te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) instanceof TileEntityTank) {
            ((TileEntityTank)te).drainFromColumn(needed, doDrain);
        }
        if (needed.amount <= 0) {
            return;
        }
        FluidStack drained = this.internalDrain(needed.amount, doDrain);
        if (drained == null) {
            return;
        }
        needed.amount -= drained.amount;
    }

    private int internalFill(FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.markUpdated();
        }
        return amount;
    }

    private void fillColumn(FluidStack resource, boolean doFill) {
        TileEntity te;
        if (!this.accepts(resource) || resource.amount <= 0) {
            return;
        }
        int amount = this.internalFill(resource, doFill);
        resource.amount -= amount;
        if (resource.amount > 0 && this.field_70330_m < 255 && (te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) instanceof TileEntityTank) {
            ((TileEntityTank)te).fillColumn(resource, doFill);
        }
    }

    @IncludeOverride
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        FluidStack needed = resource.copy();
        this.drainFromColumn(needed, doDrain);
        needed.amount = resource.amount - needed.amount;
        return needed;
    }

    @IncludeOverride
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack contents = this.tank.getFluid();
        if (contents == null || contents.amount <= 0) {
            return null;
        }
        FluidStack needed = contents.copy();
        needed.amount = maxDrain;
        this.drainFromColumn(needed, doDrain);
        needed.amount = maxDrain - needed.amount;
        return needed;
    }

    @IncludeOverride
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        this.fillColumn(copy, doFill);
        return resource.amount - copy.amount;
    }

    public class RenderContext {
        public EnumMap<ForgeDirection, TileEntityTank> neighbors = Maps.newEnumMap(ForgeDirection.class);

        public RenderContext() {
            FluidStack ownFluid = TileEntityTank.this.tank.getFluid();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntityTank tank = TileEntityTank.this.getTankInDirection(dir);
                if (tank == null || !tank.accepts(ownFluid)) continue;
                this.neighbors.put(dir, tank);
            }
        }

        public double getLiquidHeightForSide(ForgeDirection ... sides) {
            double renderHeight = TileEntityTank.this.getFluidRatio();
            if (renderHeight <= 0.02) {
                return 0.02;
            }
            if (renderHeight > 0.98) {
                return 1.0;
            }
            double fullness = renderHeight + TileEntityTank.this.getFlowOffset();
            int count = 1;
            FluidStack fluid = TileEntityTank.this.tank.getFluid();
            for (ForgeDirection side : sides) {
                TileEntityTank sideTank = this.neighbors.get(side);
                if (sideTank == null || !sideTank.accepts(fluid)) continue;
                fullness += sideTank.getFluidRatio() + sideTank.getFlowOffset();
                ++count;
            }
            return Math.max(0.0, Math.min(1.0, fullness / (double)count));
        }

        public boolean hasNeighbor(ForgeDirection side) {
            return this.neighbors.containsKey(side);
        }
    }
}

