/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorPart;
import erogenousbeef.bigreactors.utils.StaticUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RotorSimpleRenderer
implements ISimpleBlockRenderingHandler {
    protected static final double rotorSize = 0.2;
    private static ForgeDirection[][] normals = new ForgeDirection[][]{{ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH}, {ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH}, {ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.DOWN, ForgeDirection.UP}, {ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.DOWN, ForgeDirection.UP}, {ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN}, {ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN}};
    private static final int[][] quadSet1 = new int[][]{{4, 5, 6, 7}, {7, 3, 0, 4}, {6, 5, 1, 2}, {0, 1, 5, 4}, {7, 6, 2, 3}};
    private static final int[][] quadSet2 = new int[][]{{7, 6, 5, 4}, {4, 0, 3, 7}, {2, 1, 5, 6}, {4, 5, 1, 0}, {3, 2, 6, 7}};

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (metadata == 0) {
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            RotorSimpleRenderer.renderRotorShaft(block, renderer, metadata, ForgeDirection.UP, new boolean[]{true, true, true, true}, 0, 0, 0, true);
            tessellator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            RotorSimpleRenderer.renderBlade(renderer, 0, 0, 0, block, metadata, ForgeDirection.UP);
            tessellator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntityTurbineRotorPart rotorPart;
        int metadata = world.func_72805_g(x, y, z);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityTurbineRotorPart && (rotorPart = (TileEntityTurbineRotorPart)te).isConnected() && rotorPart.getTurbine().isAssembled() && rotorPart.getTurbine().isActive()) {
            return false;
        }
        if (BlockTurbineRotorPart.isRotorShaft(metadata)) {
            ForgeDirection majorAxis = RotorSimpleRenderer.findRotorMajorAxis(world, x, y, z, block);
            boolean[] hasBlades = RotorSimpleRenderer.findBlades(world, x, y, z, block, majorAxis);
            RotorSimpleRenderer.renderRotorShaft(block, renderer, metadata, majorAxis, hasBlades, x, y, z, false);
        } else {
            this.renderBladeFromWorld(renderer, world, x, y, z, block, metadata);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return BlockTurbineRotorPart.renderId;
    }

    public static void renderRotorShaft(Block block, RenderBlocks renderer, int metadata, ForgeDirection majorAxis, boolean[] hasBlades, int x, int y, int z, boolean drawOuterRectangle) {
        double zMin = 0.3;
        double yMin = 0.3;
        double xMin = 0.3;
        double zMax = 0.7;
        double yMax = 0.7;
        double xMax = 0.7;
        if (majorAxis.offsetX != 0) {
            xMax = 1.0;
            xMin = 0.0;
        }
        if (majorAxis.offsetY != 0) {
            yMax = 1.0;
            yMin = 0.0;
        }
        if (majorAxis.offsetZ != 0) {
            zMax = 1.0;
            zMin = 0.0;
        }
        Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
        renderer.func_83018_a(block);
        renderer.func_82774_a(null);
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78613_a(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 0, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78617_b(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 1, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78611_c(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 2, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78622_d(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 3, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78573_e(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 4, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78605_f(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 5, metadata));
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ForgeDirection[] bladeDirs = StaticUtils.neighborsBySide[majorAxis.ordinal()];
        for (int i = 0; i < bladeDirs.length; ++i) {
            if (!hasBlades[i]) continue;
            RotorSimpleRenderer.renderRotorBladeConnection(renderer, block, metadata, majorAxis, bladeDirs[i], x, y, z, drawOuterRectangle);
        }
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private void renderBladeFromWorld(RenderBlocks renderer, IBlockAccess world, int x, int y, int z, Block block, int metadata) {
        TileEntityTurbineRotorPart rotorPart;
        TileEntity te = world.func_72796_p(x, y, z);
        ForgeDirection rotorDir = ForgeDirection.UNKNOWN;
        if (te instanceof TileEntityTurbineRotorPart && (rotorPart = (TileEntityTurbineRotorPart)te).isConnected()) {
            rotorDir = rotorPart.getTurbine().getRotorDirection();
        }
        if (rotorDir == ForgeDirection.UNKNOWN) {
            ForgeDirection[] dirsToCheck;
            ArrayList<ForgeDirection> bladeDirs = new ArrayList<ForgeDirection>();
            for (ForgeDirection dir : dirsToCheck = ForgeDirection.VALID_DIRECTIONS) {
                int neighborBlockId = world.func_72798_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (neighborBlockId != block.field_71990_ca) continue;
                int neighborMetadata = world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (BlockTurbineRotorPart.isRotorShaft(neighborMetadata)) {
                    rotorDir = RotorSimpleRenderer.findRotorMajorAxis(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, block);
                    break;
                }
                if (!BlockTurbineRotorPart.isRotorBlade(neighborMetadata)) continue;
                bladeDirs.add(dir);
            }
            block1: while (rotorDir == ForgeDirection.UNKNOWN && !bladeDirs.isEmpty()) {
                ForgeDirection dir = (ForgeDirection)bladeDirs.remove(bladeDirs.size() - 1);
                int curX = x + dir.offsetX;
                int curY = y + dir.offsetY;
                int curZ = z + dir.offsetZ;
                for (int dist = 0; world.func_72798_a(curX, curY, curZ) == block.field_71990_ca && dist < 32; ++dist) {
                    int curMeta = world.func_72805_g(curX, curY, curZ);
                    if (BlockTurbineRotorPart.isRotorShaft(curMeta)) {
                        rotorDir = RotorSimpleRenderer.findRotorMajorAxis(world, curX, curY, curZ, block);
                        continue block1;
                    }
                    if (!BlockTurbineRotorPart.isRotorBlade(curMeta)) continue block1;
                    curX += dir.offsetX;
                    curY += dir.offsetY;
                    curZ += dir.offsetZ;
                }
            }
        }
        RotorSimpleRenderer.renderBlade(renderer, x, y, z, block, metadata, rotorDir);
    }

    public static void renderBlade(RenderBlocks renderer, int x, int y, int z, Block block, int metadata, ForgeDirection rotorDir) {
        if (rotorDir == ForgeDirection.UNKNOWN) {
            rotorDir = ForgeDirection.UP;
        }
        double zMin = 0.0;
        double yMin = 0.0;
        double xMin = 0.0;
        double zMax = 1.0;
        double yMax = 1.0;
        double xMax = 1.0;
        if (rotorDir.offsetX != 0) {
            xMin = 0.45;
            xMax = 0.55;
        } else if (rotorDir.offsetY != 0) {
            yMin = 0.45;
            yMax = 0.55;
        } else if (rotorDir.offsetZ != 0) {
            zMin = 0.45;
            zMax = 0.55;
        }
        Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
        renderer.func_83018_a(block);
        renderer.func_82774_a(null);
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78613_a(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 0, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78617_b(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 1, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78611_c(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 2, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78622_d(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 3, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78573_e(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 4, metadata));
        renderer.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        renderer.func_78605_f(block, (double)x, (double)y, (double)z, renderer.func_94165_a(block, 5, metadata));
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private static ForgeDirection findRotorMajorAxis(IBlockAccess world, int x, int y, int z, Block block) {
        ForgeDirection retDir = ForgeDirection.UP;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (world.func_72798_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != block.field_71990_ca || !BlockTurbineRotorPart.isRotorShaft(world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ))) continue;
            retDir = dir;
            break;
        }
        if (retDir == ForgeDirection.DOWN || retDir == ForgeDirection.NORTH || retDir == ForgeDirection.WEST) {
            retDir = retDir.getOpposite();
        }
        return retDir;
    }

    private static boolean[] findBlades(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection majorAxis) {
        boolean[] ret = new boolean[4];
        ForgeDirection[] dirsToCheck = StaticUtils.neighborsBySide[majorAxis.ordinal()];
        for (int i = 0; i < dirsToCheck.length; ++i) {
            ForgeDirection dir = dirsToCheck[i];
            ret[i] = world.func_72798_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) == block.field_71990_ca && BlockTurbineRotorPart.isRotorBlade(world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ));
        }
        return ret;
    }

    private static ForgeDirection findNormal(ForgeDirection majorAxis, ForgeDirection minorAxis) {
        return normals[majorAxis.ordinal()][minorAxis.ordinal()];
    }

    private static void renderRotorBladeConnection(RenderBlocks renderer, Block block, int metadata, ForgeDirection rotorDir, ForgeDirection bladeDir, int x, int y, int z, boolean drawOuterRectangle) {
        int face;
        ForgeDirection normal = RotorSimpleRenderer.findNormal(rotorDir, bladeDir);
        int rotorDirMultiplier = rotorDir.offsetX < 0 || rotorDir.offsetY < 0 || rotorDir.offsetZ < 0 ? -1 : 1;
        int bladeDirMultiplier = bladeDir.offsetX < 0 || bladeDir.offsetY < 0 || bladeDir.offsetZ < 0 ? -1 : 1;
        int normalDirMultiplier = normal.offsetX < 0 || normal.offsetY < 0 || normal.offsetZ < 0 ? -1 : 1;
        double rotorDirectionOffset = 0.05;
        double bladeInnerOffset = 0.2;
        double bladeOuterOffset = 0.5;
        double normalInnerOffset = 0.2;
        double normalOuterOffset = 0.4;
        double[] rotorOffsets = new double[8];
        rotorOffsets[4] = rotorOffsets[7] = 0.5 + (double)rotorDirMultiplier * rotorDirectionOffset;
        rotorOffsets[3] = rotorOffsets[7];
        rotorOffsets[0] = rotorOffsets[7];
        rotorOffsets[5] = rotorOffsets[6] = 0.5 - (double)rotorDirMultiplier * rotorDirectionOffset;
        rotorOffsets[2] = rotorOffsets[6];
        rotorOffsets[1] = rotorOffsets[6];
        double[] bladeOffsets = new double[8];
        bladeOffsets[2] = bladeOffsets[3] = 0.5 + (double)bladeDirMultiplier * bladeInnerOffset;
        bladeOffsets[1] = bladeOffsets[3];
        bladeOffsets[0] = bladeOffsets[3];
        bladeOffsets[6] = bladeOffsets[7] = 0.5 + (double)bladeDirMultiplier * bladeOuterOffset;
        bladeOffsets[5] = bladeOffsets[7];
        bladeOffsets[4] = bladeOffsets[7];
        double[] normalOffsets = new double[8];
        normalOffsets[0] = normalOffsets[1] = 0.5 - (double)normalDirMultiplier * normalInnerOffset;
        normalOffsets[2] = normalOffsets[3] = 0.5 + (double)normalDirMultiplier * normalInnerOffset;
        normalOffsets[4] = normalOffsets[5] = 0.5 - (double)normalDirMultiplier * normalOuterOffset;
        normalOffsets[6] = normalOffsets[7] = 0.5 + (double)normalDirMultiplier * normalOuterOffset;
        double[] xCoords = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] yCoords = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] zCoords = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int xMagRotor = Math.abs(rotorDir.offsetX);
        int xMagBlade = Math.abs(bladeDir.offsetX);
        int xMagNormal = Math.abs(normal.offsetX);
        int yMagRotor = Math.abs(rotorDir.offsetY);
        int yMagBlade = Math.abs(bladeDir.offsetY);
        int yMagNormal = Math.abs(normal.offsetY);
        int zMagRotor = Math.abs(rotorDir.offsetZ);
        int zMagBlade = Math.abs(bladeDir.offsetZ);
        int zMagNormal = Math.abs(normal.offsetZ);
        for (int i = 0; i < 8; ++i) {
            xCoords[i] = rotorOffsets[i] * (double)xMagRotor + bladeOffsets[i] * (double)xMagBlade + normalOffsets[i] * (double)xMagNormal;
            yCoords[i] = rotorOffsets[i] * (double)yMagRotor + bladeOffsets[i] * (double)yMagBlade + normalOffsets[i] * (double)yMagNormal;
            zCoords[i] = rotorOffsets[i] * (double)zMagRotor + bladeOffsets[i] * (double)zMagBlade + normalOffsets[i] * (double)zMagNormal;
        }
        double[] u = new double[]{0.0, 0.0, 16.0, 16.0};
        double[] v = new double[]{0.0, 16.0, 16.0, 0.0};
        Icon icon = BigReactors.blockTurbineRotorPart.getRotorConnectorIcon();
        for (int i = 0; i < 4; ++i) {
            u[i] = icon.func_94214_a(u[i]);
            v[i] = icon.func_94207_b(v[i]);
        }
        int[][] quads = rotorDir.offsetX != 0 || bladeDir.offsetX != 0 && rotorDir.offsetY != 0 ? quadSet2 : quadSet1;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78372_c((float)x, (float)y, (float)z);
        int n = face = drawOuterRectangle ? 0 : 1;
        while (face < quads.length) {
            for (int vertex = 0; vertex < quads[face].length; ++vertex) {
                int idx = quads[face][vertex];
                tessellator.func_78374_a(xCoords[idx], yCoords[idx], zCoords[idx], u[vertex], v[vertex]);
            }
            ++face;
        }
        tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

