/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.interfaces.IMultipleFluidHandler;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.helpers.CoilPartData;
import erogenousbeef.bigreactors.common.multiblock.helpers.FloatUpdateTracker;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorPart;
import erogenousbeef.bigreactors.gui.container.ISlotlessUpdater;
import erogenousbeef.bigreactors.net.PacketWrapper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.oredict.OreDictionary;

public class MultiblockTurbine
extends RectangularMultiblockControllerBase
implements IEnergyHandler,
IMultipleFluidHandler,
ISlotlessUpdater {
    private Set<EntityPlayer> updatePlayers = new HashSet<EntityPlayer>();
    private int ticksSinceLastUpdate = 0;
    private static final int ticksBetweenUpdates = 3;
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int NUM_TANKS = 2;
    public static final int FLUID_NONE = -1;
    public static final int TANK_SIZE = 4000;
    public static final int MAX_PERMITTED_FLOW = 2000;
    private FluidTank[] tanks = new FluidTank[2];
    static final float maxEnergyStored = 1000000.0f;
    float energyStored;
    boolean active;
    float rotorEnergy;
    boolean inductorEngaged;
    VentStatus ventStatus;
    int maxIntakeRate;
    int bladeSurfaceArea;
    int rotorMass;
    int coilSize;
    float inductorDragCoefficient = 0.1f;
    float inductionEfficiency = 0.5f;
    float inductionEnergyExponentBonus = 1.0f;
    float rotorDragCoefficient = 0.01f;
    float bladeDragCoefficient = 2.5E-4f;
    float frictionalDrag = 0.0f;
    public static final int inputFluidPerBlade = 25;
    public static final float inductorBaseDragCoefficient = 0.1f;
    float energyGeneratedLastTick;
    int fluidConsumedLastTick;
    float rotorEfficiencyLastTick;
    private Set<IMultiblockPart> attachedControllers;
    private Set<TileEntityTurbinePartBase> attachedRotorBearings;
    private Set<TileEntityTurbinePowerTap> attachedPowerTaps;
    private Set<ITickableMultiblockPart> attachedTickables;
    private Set<TileEntityTurbineRotorPart> attachedRotorShafts;
    private Set<TileEntityTurbineRotorPart> attachedRotorBlades;
    private Set<TileEntityTurbinePartGlass> attachedGlass;
    private Set<CoordTriplet> foundCoils;
    private FloatUpdateTracker rpmUpdateTracker;
    private static final ForgeDirection[] RotorXBladeDirections = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.DOWN, ForgeDirection.NORTH};
    private static final ForgeDirection[] RotorZBladeDirections = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.DOWN, ForgeDirection.WEST};

    public MultiblockTurbine(World world) {
        super(world);
        for (int i = 0; i < 2; ++i) {
            this.tanks[i] = new FluidTank(4000);
        }
        this.attachedControllers = new HashSet<IMultiblockPart>();
        this.attachedRotorBearings = new HashSet<TileEntityTurbinePartBase>();
        this.attachedPowerTaps = new HashSet<TileEntityTurbinePowerTap>();
        this.attachedTickables = new HashSet<ITickableMultiblockPart>();
        this.attachedRotorShafts = new HashSet<TileEntityTurbineRotorPart>();
        this.attachedRotorBlades = new HashSet<TileEntityTurbineRotorPart>();
        this.attachedGlass = new HashSet<TileEntityTurbinePartGlass>();
        this.energyStored = 0.0f;
        this.active = false;
        this.inductorEngaged = true;
        this.ventStatus = VentStatus.VentOverflow;
        this.rotorEnergy = 0.0f;
        this.maxIntakeRate = 2000;
        this.bladeSurfaceArea = 0;
        this.rotorMass = 0;
        this.coilSize = 0;
        this.energyGeneratedLastTick = 0.0f;
        this.fluidConsumedLastTick = 0;
        this.rotorEfficiencyLastTick = 1.0f;
        this.foundCoils = new HashSet<CoordTriplet>();
        this.rpmUpdateTracker = new FloatUpdateTracker(100, 5, 10.0f, 100.0f);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)this.getUpdatePacket(), (Player)((Player)player));
    }

    protected Packet getUpdatePacket() {
        int outputFluidAmt;
        int outputFluidID;
        int inputFluidAmt;
        int inputFluidID;
        FluidStack inputFluid = this.tanks[0].getFluid();
        FluidStack outputFluid = this.tanks[1].getFluid();
        if (inputFluid == null || inputFluid.amount <= 0) {
            inputFluidID = -1;
            inputFluidAmt = 0;
        } else {
            inputFluidID = inputFluid.getFluid().getID();
            inputFluidAmt = inputFluid.amount;
        }
        if (outputFluid == null || outputFluid.amount <= 0) {
            outputFluidID = -1;
            outputFluidAmt = 0;
        } else {
            outputFluidID = outputFluid.getFluid().getID();
            outputFluidAmt = outputFluid.amount;
        }
        CoordTriplet referenceCoord = this.getReferenceCoord();
        return PacketWrapper.createPacket("BigReactors", 14, new Object[]{referenceCoord.x, referenceCoord.y, referenceCoord.z, inputFluidID, inputFluidAmt, outputFluidID, outputFluidAmt, Float.valueOf(this.energyStored), Float.valueOf(this.rotorEnergy), Float.valueOf(this.energyGeneratedLastTick), this.maxIntakeRate, this.active, this.ventStatus.ordinal(), this.fluidConsumedLastTick, Float.valueOf(this.rotorEfficiencyLastTick), this.inductorEngaged});
    }

    public void onReceiveUpdatePacket(DataInputStream data) throws IOException {
        Fluid fluid;
        int inputFluidID = data.readInt();
        int inputFluidAmt = data.readInt();
        int outputFluidID = data.readInt();
        int outputFluidAmt = data.readInt();
        this.energyStored = data.readFloat();
        this.rotorEnergy = data.readFloat();
        this.energyGeneratedLastTick = data.readFloat();
        this.maxIntakeRate = data.readInt();
        this.setActive(data.readBoolean());
        this.setVentStatus(VentStatus.values()[data.readInt()], false);
        this.fluidConsumedLastTick = data.readInt();
        this.rotorEfficiencyLastTick = data.readFloat();
        this.setInductorEngaged(data.readBoolean(), false);
        if (inputFluidID == -1 || inputFluidAmt <= 0) {
            this.tanks[0].setFluid(null);
        } else {
            fluid = FluidRegistry.getFluid((int)inputFluidID);
            if (fluid == null) {
                BRLog.warning("[CLIENT] Multiblock Turbine received an unknown fluid of type %d, setting input tank to empty", inputFluidID);
                this.tanks[0].setFluid(null);
            } else {
                this.tanks[0].setFluid(new FluidStack(fluid, inputFluidAmt));
            }
        }
        if (outputFluidID == -1 || outputFluidAmt <= 0) {
            this.tanks[1].setFluid(null);
        } else {
            fluid = FluidRegistry.getFluid((int)outputFluidID);
            if (fluid == null) {
                BRLog.warning("[CLIENT] Multiblock Turbine received an unknown fluid of type %d, setting output tank to empty", outputFluidID);
                this.tanks[1].setFluid(null);
            } else {
                this.tanks[1].setFluid(new FluidStack(fluid, outputFluidAmt));
            }
        }
    }

    protected void sendTickUpdate() {
        if (this.updatePlayers.size() <= 0) {
            return;
        }
        Packet data = this.getUpdatePacket();
        for (EntityPlayer player : this.updatePlayers) {
            PacketDispatcher.sendPacketToPlayer((Packet)data, (Player)((Player)player));
        }
    }

    public void onNetworkPacket(int packetType, DataInputStream data) throws IOException {
        int idx;
        if (packetType == 0) {
            boolean nowActive = data.readBoolean();
            this.setActive(nowActive);
        }
        if (packetType == 15) {
            this.setMaxIntakeRate(data.readInt());
        }
        if (packetType == 16 && (idx = data.readInt()) >= 0 && idx < VentStatus.values().length) {
            this.setVentStatus(VentStatus.values()[idx], true);
        }
        if (packetType == 17) {
            boolean engaged = data.readBoolean();
            this.setInductorEngaged(engaged, true);
        }
        if (packetType == 14) {
            this.onReceiveUpdatePacket(data);
        }
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileEntityTurbinePartBase) {
            CoordTriplet coord = newPart.getWorldLocation();
            int metadata = this.worldObj.func_72805_g(coord.x, coord.y, coord.z);
            if (metadata == 4) {
                this.attachedRotorBearings.add((TileEntityTurbinePartBase)newPart);
            }
        }
        if (newPart instanceof TileEntityTurbinePowerTap) {
            this.attachedPowerTaps.add((TileEntityTurbinePowerTap)newPart);
        }
        if (newPart instanceof ITickableMultiblockPart) {
            this.attachedTickables.add((ITickableMultiblockPart)((Object)newPart));
        }
        if (newPart instanceof TileEntityTurbineRotorPart) {
            TileEntityTurbineRotorPart turbinePart = (TileEntityTurbineRotorPart)newPart;
            if (turbinePart.isRotorShaft()) {
                this.attachedRotorShafts.add(turbinePart);
            }
            if (turbinePart.isRotorBlade()) {
                this.attachedRotorBlades.add(turbinePart);
            }
        }
        if (newPart instanceof TileEntityTurbinePartGlass) {
            this.attachedGlass.add((TileEntityTurbinePartGlass)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        this.attachedRotorBearings.remove((Object)oldPart);
        if (oldPart instanceof TileEntityTurbinePowerTap) {
            this.attachedPowerTaps.remove((TileEntityTurbinePowerTap)oldPart);
        }
        if (oldPart instanceof ITickableMultiblockPart) {
            this.attachedTickables.remove((ITickableMultiblockPart)((Object)oldPart));
        }
        if (oldPart instanceof TileEntityTurbineRotorPart) {
            TileEntityTurbineRotorPart turbinePart = (TileEntityTurbineRotorPart)oldPart;
            if (turbinePart.isRotorShaft()) {
                this.attachedRotorShafts.remove(turbinePart);
            }
            if (turbinePart.isRotorBlade()) {
                this.attachedRotorBlades.remove(turbinePart);
            }
        }
        if (oldPart instanceof TileEntityTurbinePartGlass) {
            this.attachedGlass.remove((TileEntityTurbinePartGlass)oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        this.recalculateDerivedStatistics();
    }

    @Override
    protected void onMachineRestored() {
        this.recalculateDerivedStatistics();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.rotorMass = 0;
        this.bladeSurfaceArea = 0;
        this.coilSize = 0;
        this.rotorEnergy = 0.0f;
        this.rpmUpdateTracker.setValue(0.0f);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.attachedRotorBearings.size() != 1) {
            throw new MultiblockValidationException("Turbines require exactly 1 rotor bearing");
        }
        this.foundCoils.clear();
        super.isMachineWhole();
        TileEntityTurbinePartBase rotorPart = this.attachedRotorBearings.iterator().next();
        rotorPart.recalculateOutwardsDirection(this.getMinimumCoord(), this.getMaximumCoord());
        ForgeDirection rotorDir = rotorPart.getOutwardsDir().getOpposite();
        CoordTriplet rotorCoord = rotorPart.getWorldLocation();
        CoordTriplet minRotorCoord = this.getMinimumCoord();
        CoordTriplet maxRotorCoord = this.getMaximumCoord();
        if (rotorDir.offsetX == 0) {
            minRotorCoord.x = maxRotorCoord.x = rotorCoord.x;
        }
        if (rotorDir.offsetY == 0) {
            minRotorCoord.y = maxRotorCoord.y = rotorCoord.y;
        }
        if (rotorDir.offsetZ == 0) {
            minRotorCoord.z = maxRotorCoord.z = rotorCoord.z;
        }
        CoordTriplet endRotorCoord = rotorCoord.equals(minRotorCoord) ? maxRotorCoord : minRotorCoord;
        endRotorCoord.translate(rotorDir.getOpposite());
        ForgeDirection[] bladeDirections = rotorDir.offsetY != 0 ? StaticUtils.CardinalDirections : (rotorDir.offsetX != 0 ? RotorXBladeDirections : RotorZBladeDirections);
        HashSet<CoordTriplet> rotorShafts = new HashSet<CoordTriplet>(this.attachedRotorShafts.size());
        HashSet<CoordTriplet> rotorBlades = new HashSet<CoordTriplet>(this.attachedRotorBlades.size());
        for (TileEntityTurbineRotorPart part : this.attachedRotorShafts) {
            rotorShafts.add(part.getWorldLocation());
        }
        for (TileEntityTurbineRotorPart part : this.attachedRotorBlades) {
            rotorBlades.add(part.getWorldLocation());
        }
        boolean encounteredCoils = false;
        while (!rotorShafts.isEmpty() && !rotorCoord.equals(endRotorCoord)) {
            rotorCoord.translate(rotorDir);
            if (!rotorShafts.remove(rotorCoord)) {
                throw new MultiblockValidationException(String.format("%s - This block must contain a rotor. The rotor must begin at the bearing and run the entire length of the turbine", rotorCoord));
            }
            CoordTriplet checkCoord = rotorCoord.copy();
            boolean encounteredBlades = false;
            for (ForgeDirection bladeDir : bladeDirections) {
                checkCoord.copy(rotorCoord);
                boolean foundABlade = false;
                checkCoord.translate(bladeDir);
                while (rotorBlades.remove(checkCoord)) {
                    if (encounteredCoils) {
                        throw new MultiblockValidationException(String.format("%s - Rotor blades must be placed closer to the rotor bearing than all other parts inside a turbine", checkCoord));
                    }
                    encounteredBlades = true;
                    foundABlade = true;
                    checkCoord.translate(bladeDir);
                }
                if (foundABlade || !this.foundCoils.remove(checkCoord)) continue;
                encounteredCoils = true;
                if (encounteredBlades) {
                    throw new MultiblockValidationException(String.format("%s - Metal blocks must by placed further from the rotor bearing than all rotor blades", checkCoord));
                }
                CoordTriplet coilCheck = checkCoord.copy();
                coilCheck.translate(bladeDir.getRotation(rotorDir));
                this.foundCoils.remove(coilCheck);
                coilCheck.copy(checkCoord);
                coilCheck.translate(bladeDir.getRotation(rotorDir.getOpposite()));
                this.foundCoils.remove(coilCheck);
            }
        }
        if (!rotorCoord.equals(endRotorCoord)) {
            throw new MultiblockValidationException("The rotor shaft must extend the entire length of the turbine interior.");
        }
        if (!rotorShafts.isEmpty()) {
            throw new MultiblockValidationException(String.format("Found %d rotor blocks that are not attached to the main rotor. All rotor blocks must be in a column extending the entire length of the turbine, starting from the bearing.", rotorShafts.size()));
        }
        if (!rotorBlades.isEmpty()) {
            throw new MultiblockValidationException(String.format("Found %d rotor blades that are not attached to the rotor. All rotor blades must extend continuously from the rotor's shaft.", rotorBlades.size()));
        }
        if (!this.foundCoils.isEmpty()) {
            throw new MultiblockValidationException(String.format("Found %d metal blocks which were not in a ring around the rotor. All metal blocks must be in rings, or partial rings, around the rotor.", this.foundCoils.size()));
        }
    }

    @Override
    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        int metadata;
        if (world.func_72799_c(x, y, z)) {
            return;
        }
        int blockId = world.func_72798_a(x, y, z);
        if (this.getCoilPartData(x, y, z, blockId, metadata = world.func_72805_g(x, y, z)) != null) {
            this.foundCoils.add(new CoordTriplet(x, y, z));
            return;
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d is invalid for a turbine interior. Only rotor parts, metal blocks and empty space are allowed.", x, y, z));
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 82;
    }

    @Override
    protected int getMaximumXSize() {
        return BigReactors.maximumTurbineSize;
    }

    @Override
    protected int getMaximumZSize() {
        return BigReactors.maximumTurbineSize;
    }

    @Override
    protected int getMaximumYSize() {
        return BigReactors.maximumTurbineHeight;
    }

    @Override
    protected int getMinimumXSize() {
        return 5;
    }

    @Override
    protected int getMinimumYSize() {
        return 4;
    }

    @Override
    protected int getMinimumZSize() {
        return 5;
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase otherMachine) {
        if (!(otherMachine instanceof MultiblockTurbine)) {
            BRLog.warning("[%s] Turbine @ %s is attempting to assimilate a non-Turbine machine! That machine's data will be lost!", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.getReferenceCoord());
            return;
        }
        MultiblockTurbine otherTurbine = (MultiblockTurbine)otherMachine;
        this.rotorEnergy = Math.max(this.rotorEnergy, otherTurbine.rotorEnergy);
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase assimilator) {
        this.attachedControllers.clear();
        this.attachedRotorBearings.clear();
        this.attachedTickables.clear();
        this.attachedPowerTaps.clear();
    }

    @Override
    protected boolean updateServer() {
        int energyAvailable;
        this.energyGeneratedLastTick = 0.0f;
        this.fluidConsumedLastTick = 0;
        this.rotorEfficiencyLastTick = 1.0f;
        int steamIn = 0;
        if (this.isActive()) {
            steamIn = Math.min(this.maxIntakeRate, this.tanks[0].getFluidAmount());
            if (this.ventStatus == VentStatus.DoNotVent) {
                int availableSpace = this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount();
                steamIn = Math.min(steamIn, availableSpace);
            }
        }
        if (steamIn > 0 || this.rotorEnergy > 0.0f) {
            float inductionTorque;
            float energyToGenerate;
            float rotorSpeed = this.getRotorSpeed();
            float aerodynamicDragTorque = rotorSpeed * this.bladeDragCoefficient * (float)this.bladeSurfaceArea;
            float liftTorque = 0.0f;
            if (steamIn > 0) {
                float fluidEnergyDensity = 10.0f;
                int steamToProcess = this.bladeSurfaceArea * 25;
                steamToProcess = Math.min(steamToProcess, steamIn);
                liftTorque = (float)steamToProcess * fluidEnergyDensity;
                if (steamToProcess < steamIn) {
                    steamToProcess = steamIn - steamToProcess;
                    float bladeEfficiency = 1.0f;
                    int neededBlades = steamIn / 25;
                    int missingBlades = neededBlades - this.bladeSurfaceArea;
                    bladeEfficiency = 1.0f - (float)missingBlades / (float)neededBlades;
                    this.rotorEfficiencyLastTick = (liftTorque += (float)steamToProcess * fluidEnergyDensity * bladeEfficiency) / ((float)steamIn * fluidEnergyDensity);
                }
            }
            if ((energyToGenerate = (float)Math.pow(inductionTorque = this.inductorEngaged ? rotorSpeed * this.inductorDragCoefficient * (float)this.coilSize : 0.0f, this.inductionEnergyExponentBonus) * this.inductionEfficiency) > 0.0f) {
                float efficiency = (float)(0.25 * Math.cos((double)rotorSpeed / 142.94246573833559)) + 0.75f;
                if (rotorSpeed < 500.0f) {
                    efficiency = Math.min(0.5f, efficiency);
                }
                this.generateEnergy(energyToGenerate * efficiency);
            }
            this.rotorEnergy += liftTorque + -1.0f * inductionTorque + -1.0f * aerodynamicDragTorque + -1.0f * this.frictionalDrag;
            if (this.rotorEnergy < 0.0f) {
                this.rotorEnergy = 0.0f;
            }
            if (steamIn > 0) {
                this.fluidConsumedLastTick = steamIn;
                this.drain(0, steamIn, true);
                if (this.ventStatus != VentStatus.VentAll) {
                    Fluid effluent = FluidRegistry.WATER;
                    FluidStack effluentStack = new FluidStack(effluent, steamIn);
                    this.fill(1, effluentStack, true);
                }
            }
        }
        int energyRemaining = energyAvailable = (int)this.getEnergyStored();
        if (this.energyStored > 0.0f && this.attachedPowerTaps.size() > 0) {
            int splitEnergy = energyRemaining / this.attachedPowerTaps.size();
            for (TileEntityTurbinePowerTap powerTap : this.attachedPowerTaps) {
                if (energyRemaining <= 0) break;
                if (powerTap == null || !powerTap.isConnected()) continue;
                energyRemaining -= splitEnergy - powerTap.onProvidePower(splitEnergy);
            }
            if (energyRemaining > 0) {
                for (TileEntityTurbinePowerTap powerTap : this.attachedPowerTaps) {
                    if (energyRemaining <= 0) break;
                    if (powerTap == null || !powerTap.isConnected()) continue;
                    energyRemaining = powerTap.onProvidePower(energyRemaining);
                }
            }
        }
        if (energyAvailable != energyRemaining) {
            this.reduceStoredEnergy(energyAvailable - energyRemaining);
        }
        for (ITickableMultiblockPart part : this.attachedTickables) {
            part.onMultiblockServerTick();
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 3) {
            this.sendTickUpdate();
            this.ticksSinceLastUpdate = 0;
        }
        if (this.rpmUpdateTracker.shouldUpdate(this.getRotorSpeed())) {
            this.markReferenceCoordDirty();
        }
        return this.energyGeneratedLastTick > 0.0f || this.fluidConsumedLastTick > 0;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74766_a("inputTank", this.tanks[0].writeToNBT(new NBTTagCompound()));
        data.func_74766_a("outputTank", this.tanks[1].writeToNBT(new NBTTagCompound()));
        data.func_74757_a("active", this.active);
        data.func_74776_a("energy", this.energyStored);
        data.func_74768_a("ventStatus", this.ventStatus.ordinal());
        data.func_74776_a("rotorEnergy", this.rotorEnergy);
        data.func_74768_a("maxIntakeRate", this.maxIntakeRate);
        data.func_74757_a("inductorEngaged", this.inductorEngaged);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("inputTank")) {
            this.tanks[0].readFromNBT(data.func_74775_l("inputTank"));
        }
        if (data.func_74764_b("outputTank")) {
            this.tanks[1].readFromNBT(data.func_74775_l("outputTank"));
        }
        if (data.func_74764_b("active")) {
            this.setActive(data.func_74767_n("active"));
        }
        if (data.func_74764_b("energy")) {
            this.setEnergyStored(data.func_74760_g("energy"));
        }
        if (data.func_74764_b("ventStatus")) {
            this.setVentStatus(VentStatus.values()[data.func_74762_e("ventStatus")], false);
        }
        if (data.func_74764_b("rotorEnergy")) {
            this.rotorEnergy = data.func_74760_g("rotorEnergy");
            if (Float.isNaN(this.rotorEnergy) || Float.isInfinite(this.rotorEnergy)) {
                this.rotorEnergy = 0.0f;
            }
            if (!this.worldObj.field_72995_K) {
                this.rpmUpdateTracker.setValue(this.getRotorSpeed());
            }
        }
        if (data.func_74764_b("maxIntakeRate")) {
            this.maxIntakeRate = data.func_74762_e("maxIntakeRate");
        }
        if (data.func_74764_b("inductorEngaged")) {
            this.setInductorEngaged(data.func_74767_n("inductorEngaged"), false);
        }
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    public int fill(int tank, FluidStack resource, boolean doFill) {
        if (!this.canFill(tank, resource.getFluid())) {
            return 0;
        }
        return this.tanks[tank].fill(resource, doFill);
    }

    public FluidStack drain(int tank, FluidStack resource, boolean doDrain) {
        if (this.canDrain(tank, resource.getFluid())) {
            return this.tanks[tank].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int tank, int maxDrain, boolean doDrain) {
        if (tank < 0 || tank >= 2) {
            return null;
        }
        return this.tanks[tank].drain(maxDrain, doDrain);
    }

    public boolean canFill(int tank, Fluid fluid) {
        if (tank < 0 || tank >= 2) {
            return false;
        }
        FluidStack fluidStack = this.tanks[tank].getFluid();
        if (fluidStack != null) {
            return fluidStack.getFluid().getID() == fluid.getID();
        }
        if (tank == 0) {
            return fluid.getName().equals("steam");
        }
        return true;
    }

    public boolean canDrain(int tank, Fluid fluid) {
        if (tank < 0 || tank >= 2) {
            return false;
        }
        FluidStack fluidStack = this.tanks[tank].getFluid();
        if (fluidStack == null) {
            return false;
        }
        return fluidStack.getFluid().getID() == fluid.getID();
    }

    @Override
    public FluidTankInfo[] getTankInfo() {
        FluidTankInfo[] infos = new FluidTankInfo[2];
        for (int i = 0; i < 2; ++i) {
            infos[i] = this.tanks[i].getInfo();
        }
        return infos;
    }

    public FluidTankInfo getTankInfo(int tankIdx) {
        return this.tanks[tankIdx].getInfo();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min((int)this.energyStored, maxExtract);
        if (!simulate) {
            this.energyStored -= (float)energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)this.energyStored;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 1000000;
    }

    private void setEnergyStored(float newEnergy) {
        if (Float.isInfinite(newEnergy) || Float.isNaN(newEnergy)) {
            return;
        }
        this.energyStored = Math.max(0.0f, Math.min(1000000.0f, newEnergy));
    }

    public float getEnergyStored() {
        return this.energyStored;
    }

    protected void reduceStoredEnergy(float energy) {
        this.addStoredEnergy(-1.0f * energy);
    }

    protected void addStoredEnergy(float newEnergy) {
        if (Float.isNaN(newEnergy)) {
            return;
        }
        this.energyStored += newEnergy;
        if (this.energyStored > 1000000.0f) {
            this.energyStored = 1000000.0f;
        }
        if (-1.0E-5f < this.energyStored && this.energyStored < 1.0E-5f) {
            this.energyStored = 0.0f;
        }
    }

    public void setStoredEnergy(float oldEnergy) {
        this.energyStored = oldEnergy;
        if ((double)this.energyStored < 0.0 || Float.isNaN(this.energyStored)) {
            this.energyStored = 0.0f;
        } else if (this.energyStored > 1000000.0f) {
            this.energyStored = 1000000.0f;
        }
    }

    protected void generateEnergy(float newEnergy) {
        this.energyGeneratedLastTick += newEnergy * BigReactors.powerProductionMultiplier;
        this.addStoredEnergy(newEnergy * BigReactors.powerProductionMultiplier);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean newValue) {
        if (newValue != this.active) {
            this.active = newValue;
            for (IMultiblockPart iMultiblockPart : this.connectedParts) {
                if (this.active) {
                    iMultiblockPart.onMachineActivated();
                    continue;
                }
                iMultiblockPart.onMachineDeactivated();
            }
            CoordTriplet referenceCoord = this.getReferenceCoord();
            this.worldObj.func_72845_h(referenceCoord.x, referenceCoord.y, referenceCoord.z);
            this.markReferenceCoordDirty();
        }
        if (this.worldObj.field_72995_K) {
            for (IMultiblockPart iMultiblockPart : this.attachedControllers) {
                this.worldObj.func_72845_h(iMultiblockPart.field_70329_l, iMultiblockPart.field_70330_m, iMultiblockPart.field_70327_n);
            }
            for (TileEntityTurbineRotorPart tileEntityTurbineRotorPart : this.attachedRotorBlades) {
                this.worldObj.func_72845_h(tileEntityTurbineRotorPart.field_70329_l, tileEntityTurbineRotorPart.field_70330_m, tileEntityTurbineRotorPart.field_70327_n);
            }
            for (TileEntityTurbineRotorPart tileEntityTurbineRotorPart : this.attachedRotorShafts) {
                this.worldObj.func_72845_h(tileEntityTurbineRotorPart.field_70329_l, tileEntityTurbineRotorPart.field_70330_m, tileEntityTurbineRotorPart.field_70327_n);
            }
        }
    }

    public int getMaxIntakeRate() {
        return this.maxIntakeRate;
    }

    public void setMaxIntakeRate(int newRate) {
        this.maxIntakeRate = Math.min(2000, Math.max(0, newRate));
        this.markReferenceCoordDirty();
    }

    public int getMaxIntakeRateMax() {
        return 2000;
    }

    @Override
    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    private CoilPartData getCoilPartData(int x, int y, int z) {
        return this.getCoilPartData(x, y, z, this.worldObj.func_72798_a(x, y, z), this.worldObj.func_72805_g(x, y, z));
    }

    private CoilPartData getCoilPartData(int x, int y, int z, int blockID, int metadata) {
        if (blockID == Block.field_72083_ai.field_71990_ca) {
            return BRRegistry.getCoilPartData("blockIron");
        }
        if (blockID == Block.field_72105_ah.field_71990_ca) {
            return BRRegistry.getCoilPartData("blockGold");
        }
        int oreId = OreDictionary.getOreID((ItemStack)new ItemStack(blockID, 1, metadata));
        if (oreId < 0) {
            return null;
        }
        String oreName = OreDictionary.getOreName((int)oreId);
        return BRRegistry.getCoilPartData(oreName);
    }

    private void recalculateDerivedStatistics() {
        CoordTriplet minInterior = this.getMinimumCoord();
        CoordTriplet maxInterior = this.getMaximumCoord();
        ++minInterior.x;
        ++minInterior.y;
        ++minInterior.z;
        ++maxInterior.x;
        ++maxInterior.y;
        ++maxInterior.z;
        this.rotorMass = 0;
        this.bladeSurfaceArea = 0;
        this.coilSize = 0;
        float coilEfficiency = 0.0f;
        float coilBonus = 0.0f;
        float coilDragCoefficient = 0.0f;
        for (int x = minInterior.x; x <= maxInterior.x; ++x) {
            for (int y = minInterior.y; y <= maxInterior.y; ++y) {
                for (int z = minInterior.z; z <= maxInterior.z; ++z) {
                    int blockId = this.worldObj.func_72798_a(x, y, z);
                    int metadata = this.worldObj.func_72805_g(x, y, z);
                    CoilPartData coilData = null;
                    if (blockId == BigReactors.blockTurbineRotorPart.field_71990_ca) {
                        this.rotorMass += BigReactors.blockTurbineRotorPart.getRotorMass(blockId, metadata);
                        if (BlockTurbineRotorPart.isRotorBlade(metadata)) {
                            ++this.bladeSurfaceArea;
                        }
                    }
                    if ((coilData = this.getCoilPartData(x, y, z, blockId, metadata)) == null) continue;
                    coilEfficiency += coilData.efficiency;
                    coilBonus += coilData.bonus;
                    coilDragCoefficient += coilData.energyExtractionRate;
                    ++this.coilSize;
                }
            }
        }
        this.frictionalDrag = (float)this.rotorMass * this.rotorDragCoefficient;
        if (this.coilSize <= 0) {
            this.inductionEfficiency = 0.0f;
            this.inductionEnergyExponentBonus = 1.0f;
            this.inductorDragCoefficient = 0.0f;
        } else {
            this.inductionEfficiency = coilEfficiency * 0.33f / (float)this.coilSize;
            this.inductionEnergyExponentBonus = Math.max(1.0f, coilBonus / (float)this.coilSize);
            this.inductorDragCoefficient = coilDragCoefficient / (float)this.coilSize * 0.1f;
        }
    }

    public float getRotorSpeed() {
        if (this.attachedRotorBlades.size() <= 0 || this.rotorMass <= 0) {
            return 0.0f;
        }
        return this.rotorEnergy / (float)(this.attachedRotorBlades.size() * this.rotorMass);
    }

    public float getEnergyGeneratedLastTick() {
        return this.energyGeneratedLastTick;
    }

    public int getFluidConsumedLastTick() {
        return this.fluidConsumedLastTick;
    }

    public int getNumRotorBlades() {
        return this.attachedRotorBlades.size();
    }

    public float getRotorEfficiencyLastTick() {
        return this.rotorEfficiencyLastTick;
    }

    public float getMaxRotorSpeed() {
        return 2000.0f;
    }

    public int getRotorMass() {
        return this.rotorMass;
    }

    public VentStatus getVentSetting() {
        return this.ventStatus;
    }

    public void setVentStatus(VentStatus newStatus, boolean markReferenceCoordDirty) {
        this.ventStatus = newStatus;
        if (markReferenceCoordDirty) {
            this.markReferenceCoordDirty();
        }
    }

    public boolean getInductorEngaged() {
        return this.inductorEngaged;
    }

    public void setInductorEngaged(boolean engaged, boolean markReferenceCoordDirty) {
        this.inductorEngaged = engaged;
        if (markReferenceCoordDirty) {
            this.markReferenceCoordDirty();
        }
    }

    protected void markReferenceCoordDirty() {
        if (this.worldObj == null || this.worldObj.field_72995_K) {
            return;
        }
        CoordTriplet referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        this.rpmUpdateTracker.onExternalUpdate();
        TileEntity saveTe = this.worldObj.func_72796_p(referenceCoord.x, referenceCoord.y, referenceCoord.z);
        this.worldObj.func_72944_b(referenceCoord.x, referenceCoord.y, referenceCoord.z, saveTe);
        this.worldObj.func_72845_h(referenceCoord.x, referenceCoord.y, referenceCoord.z);
    }

    public ForgeDirection getRotorDirection() {
        if (this.attachedRotorBearings.size() < 1) {
            return ForgeDirection.UNKNOWN;
        }
        if (!this.isAssembled()) {
            return ForgeDirection.UNKNOWN;
        }
        TileEntityTurbinePartBase rotorBearing = this.attachedRotorBearings.iterator().next();
        return rotorBearing.getOutwardsDir().getOpposite();
    }

    public boolean hasGlass() {
        return this.attachedGlass.size() > 0;
    }

    public static enum VentStatus {
        VentOverflow,
        VentAll,
        DoNotVent;

    }
}

