/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cofh.api.energy.IEnergyHandler;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityReactorPowerTap
extends TileEntityReactorPart
implements IEnergyHandler,
INeighborUpdatableEntity {
    IEnergyHandler rfNetwork = null;

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborBlockID) {
        if (this.isConnected()) {
            this.checkForConnections(world, x, y, z);
        }
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.checkForConnections(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.checkForConnections(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70296_d();
    }

    protected void checkForConnections(World world, int x, int y, int z) {
        boolean isConnected;
        boolean wasConnected = this.rfNetwork != null;
        ForgeDirection out = this.getOutwardsDir();
        if (out == ForgeDirection.UNKNOWN) {
            wasConnected = false;
            this.rfNetwork = null;
        } else {
            this.rfNetwork = null;
            TileEntity te = world.func_72796_p(x + out.offsetX, y + out.offsetY, z + out.offsetZ);
            if (!(te instanceof TileEntityReactorPowerTap) && te instanceof IEnergyHandler) {
                this.rfNetwork = (IEnergyHandler)te;
            }
        }
        boolean bl = isConnected = this.rfNetwork != null;
        if (wasConnected != isConnected) {
            if (isConnected) {
                world.func_72921_c(x, y, z, 10, 2);
            } else {
                world.func_72921_c(x, y, z, 9, 2);
            }
        }
    }

    public int onProvidePower(int units) {
        if (this.rfNetwork == null) {
            return units;
        }
        ForgeDirection approachDirection = this.getOutwardsDir().getOpposite();
        int energyConsumed = this.rfNetwork.receiveEnergy(approachDirection, units, false);
        return units -= energyConsumed;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.isConnected()) {
            return 0;
        }
        if (from == this.getOutwardsDir()) {
            return this.getReactorController().extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return from == this.getOutwardsDir();
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getReactorController().getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getReactorController().getMaxEnergyStored(from);
    }
}

