/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.common.MinecraftForge;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.IUndoableAction;

public class ItemAddToolAction
implements IUndoableAction {
    private final aqz block;
    private final int meta;
    private final String tool;
    private final int level;
    private final Integer oldLevel;
    private final boolean wasEffective;

    public ItemAddToolAction(aqz block, int meta, String tool, int level) {
        this.block = block;
        this.meta = meta;
        this.tool = tool;
        this.level = level;
        this.oldLevel = MineTweakerUtil.getBlockHarvestLevel(block, meta, tool);
        this.wasEffective = MineTweakerUtil.isHarvestEffective(block, meta, tool);
    }

    @Override
    public void apply() {
        MinecraftForge.setBlockHarvestLevel((aqz)this.block, (int)this.meta, (String)this.tool, (int)this.level);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.wasEffective && null != this.oldLevel) {
            MinecraftForge.setBlockHarvestLevel((aqz)this.block, (int)this.meta, (String)this.tool, (int)this.oldLevel);
        } else {
            MineTweakerUtil.removeBlockTool(this.block, this.meta, this.tool);
        }
    }

    @Override
    public String describe() {
        return "Adding " + this.block.cF + ":" + this.meta + " tool harvest level of " + this.tool + " to " + this.level;
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.block.cF + ":" + this.meta + " tool level of " + this.tool + " to " + this.oldLevel;
    }
}

