/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.mfr.action.FruitPickerAddFruitAction;

public class FruitPickerAddFruitFunction
extends TweakerFunction {
    public static final FruitPickerAddFruitFunction INSTANCE = new FruitPickerAddFruitFunction();
    private static final Random RANDOM = new Random();

    private FruitPickerAddFruitFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        float[] dropChances;
        ye[] possibleDrops;
        if (arguments.length < 2 || arguments.length > 4) {
            throw new TweakerExecuteException("fruitPicker.addFruit requires 1-3 arguments");
        }
        TweakerItem block = FruitPickerAddFruitFunction.notNull(arguments[0], "harvestable cannot be null").toItem("harvestable block must be an item");
        TweakerItem replacement = FruitPickerAddFruitFunction.notNull(arguments[1], "replacement cannot be null").toItem("replacement block must be an item");
        if (arguments.length < 3 || arguments[2] == null) {
            possibleDrops = new ye[]{};
        } else if (arguments[2].asArray() != null) {
            TweakerArray drops = arguments[2].asArray();
            possibleDrops = new ye[drops.size()];
            for (int i = 0; i < possibleDrops.length; ++i) {
                possibleDrops[i] = FruitPickerAddFruitFunction.notNull(drops.get(i), "drops cannot be null").toItemStack("drops must be items").get();
            }
        } else {
            possibleDrops = new ye[]{arguments[2].toItemStack("drop must be an item stack or array of item stacks").get()};
        }
        if (arguments.length < 4 || arguments[2] == null) {
            dropChances = new float[]{};
        } else if (arguments[3].asArray() != null) {
            TweakerArray chances = arguments[3].asArray();
            dropChances = new float[chances.size()];
            for (int i = 0; i < dropChances.length; ++i) {
                dropChances[i] = FruitPickerAddFruitFunction.notNull(chances.get(i), "drop chance cannot be null").toFloat("drop chance must be a float").get();
            }
        } else {
            dropChances = new float[]{arguments[3].toFloat("drop chance must be a float or array of floats").get()};
        }
        Tweaker.apply(new FruitPickerAddFruitAction(block, new TweakerFruit(block.getItemId(), block.getItemSubId(), replacement.make(1), possibleDrops, dropChances)));
        return null;
    }

    @Override
    public String toString() {
        return "harvester.addHarvestable";
    }

    private static class TweakerFruit
    implements IFactoryFruit {
        private final int plantId;
        private final int meta;
        private final ye replacement;
        private final ye[] possibleDrops;
        private final float[] chances;

        public TweakerFruit(int plantId, int meta, ye replacement, ye[] possibleDrops, float[] chances) {
            this.plantId = plantId;
            this.meta = meta;
            this.replacement = replacement;
            this.possibleDrops = possibleDrops;
            this.chances = chances;
        }

        public int getSourceBlockId() {
            return this.plantId;
        }

        public boolean canBePicked(abw world, int x, int y, int z) {
            return this.meta == Short.MAX_VALUE || this.meta == world.h(x, y, z);
        }

        public ye getReplacementBlock(abw world, int x, int y, int z) {
            return this.replacement;
        }

        public void prePick(abw world, int x, int y, int z) {
        }

        public List<ye> getDrops(abw world, Random rand, int x, int y, int z) {
            ArrayList<ye> drops = new ArrayList<ye>();
            for (int i = 0; i < this.possibleDrops.length; ++i) {
                if (i < this.chances.length && !(RANDOM.nextFloat() < this.chances[i])) continue;
                drops.add(this.possibleDrops[i]);
            }
            return drops;
        }

        public void postPick(abw world, int x, int y, int z) {
        }
    }
}

