/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import stanhebben.minetweaker.api.TweakerException;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.script.ScriptEnvironment;
import stanhebben.minetweaker.script.TweakerParser;
import stanhebben.minetweaker.script.statements.TweakerStatement;

public class TweakerFile {
    private ScriptEnvironment environment;
    private String file;
    private List<TweakerStatement> contents;

    public TweakerFile(ScriptEnvironment environment, String name, File file) throws IOException {
        this.environment = environment;
        this.file = name.startsWith("/") ? name : "/" + name;
        this.contents = this.loadScript(file);
    }

    public TweakerFile(ScriptEnvironment environment, String name, String contents) throws IOException {
        this.environment = environment;
        this.file = name.startsWith("/") ? name : "/" + name;
        this.contents = this.loadScript(contents);
    }

    public ScriptEnvironment getEnvironment() {
        return this.environment;
    }

    public String getName() {
        return this.file;
    }

    public TweakerFile findFile(String filename) {
        if (filename.startsWith("/")) {
            return this.environment.getFile(filename);
        }
        int slash1 = this.file.lastIndexOf(47);
        if (slash1 < 0) {
            throw new TweakerExecuteException("filedir must be absolute");
        }
        String dir = this.file.substring(0, slash1);
        while (filename.startsWith("../")) {
            filename = filename.substring(3);
            int slash = dir.lastIndexOf(47);
            if (slash < 0) {
                throw new TweakerExecuteException("Cannot go up that many directories");
            }
            dir = dir.substring(0, slash);
        }
        return this.environment.getFile(dir + '/' + filename);
    }

    public void execute(TweakerNameSpace global) throws TweakerException {
        for (TweakerStatement statement : this.contents) {
            if (statement.execute(global) == null) continue;
            throw new TweakerException(statement.getFile(), statement.getLine(), statement.getOffset(), "Cannot return a value in the main code");
        }
    }

    private List<TweakerStatement> loadScript(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        TweakerParser parser = new TweakerParser(this.file, reader);
        ArrayList<TweakerStatement> result = new ArrayList<TweakerStatement>();
        while (parser.hasNext()) {
            result.add(TweakerStatement.read(this, parser));
        }
        ((Reader)reader).close();
        return result;
    }

    private List<TweakerStatement> loadScript(String contents) throws IOException {
        TweakerParser parser = new TweakerParser(this.file, contents);
        ArrayList<TweakerStatement> result = new ArrayList<TweakerStatement>();
        while (parser.hasNext()) {
            result.add(TweakerStatement.read(this, parser));
        }
        return result;
    }
}

