/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.tweaker;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import stanhebben.minetweaker.tweaker.SetFuelPattern;

public class FuelTweaker {
    public static final FuelTweaker INSTANCE = new FuelTweaker();
    private List<IFuelHandler> original;
    private final List<SetFuelPattern> fuelPatterns = new ArrayList<SetFuelPattern>();
    private final HashMap<String, Integer> fuelItems = new HashMap();

    private FuelTweaker() {
    }

    public void register() {
        try {
            Field fuelHandlers = GameRegistry.class.getDeclaredField("fuelHandlers");
            fuelHandlers.setAccessible(true);
            this.original = (List)fuelHandlers.get(null);
            ArrayList<OverridingFuelHandler> modified = new ArrayList<OverridingFuelHandler>();
            modified.add(new OverridingFuelHandler());
            fuelHandlers.set(null, modified);
        }
        catch (NoSuchFieldException ex) {
            System.out.println("[MineTweaker] Error: could not get GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
        catch (SecurityException ex) {
            System.out.println("[MineTweaker] Error: could not alter GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
        catch (IllegalAccessException ex) {
            System.out.println("[MineTweaker] Error: could not alter GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
    }

    public void addFuelPattern(SetFuelPattern pattern) {
        this.fuelPatterns.add(pattern);
    }

    public void removeFuelPattern(SetFuelPattern pattern) {
        this.fuelPatterns.remove(pattern);
    }

    public Integer setFuelItem(int itemId, Integer value) {
        if (value == null) {
            return this.fuelItems.remove(Integer.toString(itemId));
        }
        return this.fuelItems.put(Integer.toString(itemId), value);
    }

    public Integer setFuelItem(int itemId, int meta, Integer value) {
        if (value == null) {
            return this.fuelItems.remove(itemId + ":" + meta);
        }
        return this.fuelItems.put(itemId + ":" + meta, value);
    }

    private class OverridingFuelHandler
    implements IFuelHandler {
        private OverridingFuelHandler() {
        }

        public int getBurnTime(ye fuel) {
            if (FuelTweaker.this.fuelItems.size() > 0) {
                Object key = Integer.toString(fuel.d);
                if (FuelTweaker.this.fuelItems.containsKey(key)) {
                    return (Integer)FuelTweaker.this.fuelItems.get(key);
                }
                if (fuel.h()) {
                    key = fuel.d + ":" + fuel.k();
                    if (FuelTweaker.this.fuelItems.containsKey(key)) {
                        return (Integer)FuelTweaker.this.fuelItems.get(key);
                    }
                }
            }
            for (SetFuelPattern override : FuelTweaker.this.fuelPatterns) {
                if (!override.getPattern().matches(fuel)) continue;
                return override.getValue();
            }
            int max = 0;
            for (IFuelHandler handler : FuelTweaker.this.original) {
                max = Math.max(max, handler.getBurnTime(fuel));
            }
            return max;
        }
    }
}

