/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.block;

import cofh.api.core.IInitializer;
import cofh.render.IconRegistry;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import redstonearsenal.RedstoneArsenal;
import redstonearsenal.util.Utils;

public class BlockStorage
extends Block
implements IInitializer {
    public static final String[] NAMES = new String[]{"electrumFlux", "crystalFlux"};
    public static boolean[] enableDamage = new boolean[2];
    public static boolean[] enableDamageCharge = new boolean[2];
    public static double[] damage = new double[2];
    public static int chargeRate = 50;
    public static ItemStack blockElectrumFlux;
    public static ItemStack blockCrystalFlux;

    public BlockStorage(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(25.0f);
        this.func_71894_b(120.0f);
        this.func_71884_a(field_71977_i);
        this.func_71849_a(RedstoneArsenal.tab);
        this.func_71864_b("redstonearsenal.storage");
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < NAMES.length; ++i) {
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    public int func_71899_b(int i) {
        return i;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public boolean isBeaconBase(World worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return true;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.0625f), (double)y, (double)((float)z + 0.0625f), (double)((float)(x + 1) - 0.0625f), (double)((float)(y + 1) - 0.0625f), (double)((float)(z + 1) - 0.0625f));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 7;
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (ServerHelper.isClientWorld((World)world) || entity instanceof EntityItem) {
            return;
        }
        double fluxDamage = 0.0;
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                if (!enableDamage[0]) break;
                fluxDamage = damage[0];
                break;
            }
            case 1: {
                if (!enableDamage[1]) break;
                fluxDamage = damage[1];
            }
        }
        if (fluxDamage > 0.0) {
            EntityPlayerMP player;
            entity.func_70097_a((DamageSource)Utils.flux, (float)fluxDamage);
            if (entity instanceof EntityPlayerMP && EnergyHelper.isPlayerHoldingEnergyContainerItem((EntityPlayer)(player = (EntityPlayerMP)entity))) {
                EnergyHelper.insertEnergyIntoHeldContainer((EntityPlayer)player, (int)((int)((double)chargeRate * fluxDamage)), (boolean)false);
            }
        }
    }

    public Icon func_71858_a(int side, int metadata) {
        return IconRegistry.getIcon((String)"StorageFlux", (int)metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        for (int i = 0; i < NAMES.length; ++i) {
            IconRegistry.addIcon((String)("StorageFlux" + i), (String)("redstonearsenal:storage/Block_" + StringHelper.titleCase((String)NAMES[i])), (IconRegister)ir);
        }
    }

    protected void registerWithHandlers(String oreName, ItemStack stack) {
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        GameRegistry.registerCustomItemStack((String)oreName, (ItemStack)stack);
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)stack);
    }

    public boolean preInit() {
        return true;
    }

    public boolean initialize() {
        String category = "block.feature";
        BlockStorage.enableDamage[0] = RedstoneArsenal.config.get(category, "Storage.Electrum.Damage.Enable", true);
        BlockStorage.enableDamage[1] = RedstoneArsenal.config.get(category, "Storage.Crystal.Damage.Enable", true);
        BlockStorage.enableDamageCharge[0] = RedstoneArsenal.config.get(category, "Storage.Electrum.Damage.Charge", true);
        BlockStorage.enableDamageCharge[1] = RedstoneArsenal.config.get(category, "Storage.Crystal.Damage.Charge", true);
        BlockStorage.damage[0] = RedstoneArsenal.config.get(category, "Storage.Electrum.Damage.Amount", 0.5);
        BlockStorage.damage[1] = RedstoneArsenal.config.get(category, "Storage.Crystal.Damage.Amount", 1);
        String comment = "Amount of Redstone Flux charged per tick while touching a block; multiplied by damage dealt by the block. Max: 1000; Default: 50";
        chargeRate = RedstoneArsenal.config.get(category, "Storage.FluxPerTickPerDamage", chargeRate, comment);
        chargeRate = MathHelper.clampI((int)chargeRate, (int)0, (int)1000);
        blockElectrumFlux = new ItemStack((Block)this, 1, 0);
        blockCrystalFlux = new ItemStack((Block)this, 1, 1);
        this.registerWithHandlers("blockElectrumFlux", blockElectrumFlux);
        this.registerWithHandlers("blockCrystalFlux", blockCrystalFlux);
        return true;
    }

    public boolean postInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockElectrumFlux, new Object[]{"III", "III", "III", Character.valueOf('I'), "ingotElectrumFlux"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockCrystalFlux, new Object[]{"III", "III", "III", Character.valueOf('I'), "gemCrystalFlux"}));
        return true;
    }
}

