/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import org.lwjgl.input.Keyboard;
import redstonearsenal.core.ProxyClient;
import redstonearsenal.item.tool.IEmpowerableItem;

public class ItemBowRF
extends ItemBow
implements IEmpowerableItem,
IEnergyContainerItem {
    protected EnumToolMaterial toolMaterial;
    Icon[] normalIcons = new Icon[4];
    Icon[] activeIcons = new Icon[4];
    Icon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;
    public int energyPerUseCharged = 800;

    public ItemBowRF(int id, EnumToolMaterial toolMaterial) {
        super(id);
        this.toolMaterial = toolMaterial;
        this.func_77656_e(toolMaterial.func_77997_a());
        this.setNoRepair();
    }

    protected void useEnergy(ItemStack stack) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        this.extractEnergy(stack, this.isEmpowered(stack) ? this.energyPerUseCharged * (5 - unbreakingLevel) / 5 : this.energyPerUse * (5 - unbreakingLevel) / 5, false);
    }

    protected int getEnergyPerUse(ItemStack stack) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return (this.isEmpowered(stack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - unbreakingLevel) / 5;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(itemId, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(itemId, 1, 0), (int)this.maxEnergy));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
            return stack;
        }
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70450_e(Item.field_77704_l.field_77779_bT)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemUse) {
        boolean flag;
        int draw = this.func_77626_a(stack) - itemUse;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, draw);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        draw = event.charge;
        boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        if (flag || player.field_71071_by.func_70450_e(Item.field_77704_l.field_77779_bT)) {
            int l;
            int k;
            float f = (float)draw / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
            if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
            }
            if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(l);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (flag) {
                entityarrow.field_70251_a = 2;
            } else {
                player.field_71071_by.func_70435_d(Item.field_77704_l.field_77779_bT);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + stack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        if (this.isEmpowered(stack)) {
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)ProxyClient.empower.field_74512_d) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOff") + "\u00a7r");
        } else {
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)ProxyClient.empower.field_74512_d) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOn") + "\u00a7r");
        }
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1 + this.maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Short.MAX_VALUE;
    }

    public Icon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return this.isEmpowered(stack) ? this.activeIcons[0] : (this.getEnergyStored(stack) <= 0 ? this.drainedIcon : this.normalIcons[0]);
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (this.getEnergyStored(stack) <= 0) {
            return this.drainedIcon;
        }
        if (useRemaining > 0) {
            int draw = stack.func_77988_m() - useRemaining;
            if (draw > 17) {
                return this.isEmpowered(stack) ? this.activeIcons[3] : this.normalIcons[3];
            }
            if (draw > 13) {
                return this.isEmpowered(stack) ? this.activeIcons[2] : this.normalIcons[2];
            }
            if (draw > 0) {
                return this.isEmpowered(stack) ? this.activeIcons[1] : this.normalIcons[1];
            }
        }
        return this.isEmpowered(stack) ? this.activeIcons[0] : this.normalIcons[0];
    }

    public void func_94581_a(IconRegister ir) {
        this.drainedIcon = ir.func_94245_a(this.func_111208_A() + "_Drained");
        this.normalIcons[0] = ir.func_94245_a(this.func_111208_A());
        this.activeIcons[0] = ir.func_94245_a(this.func_111208_A() + "_Active");
        for (int i = 1; i < 4; ++i) {
            this.normalIcons[i] = ir.func_94245_a(this.func_111208_A() + "_" + (i - 1));
            this.activeIcons[i] = ir.func_94245_a(this.func_111208_A() + "_" + (i - 1) + "_Active");
        }
    }

    @Override
    public boolean isEmpowered(ItemStack stack) {
        return stack.field_77990_d.func_74767_n("Empowered");
    }

    @Override
    public boolean setEmpoweredState(ItemStack stack, boolean state) {
        if (this.getEnergyStored(stack) > 0) {
            stack.field_77990_d.func_74757_a("Empowered", state);
            return true;
        }
        stack.field_77990_d.func_74757_a("Empowered", false);
        return false;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
            if (stored == 0) {
                this.setEmpoweredState(container, false);
            }
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }
}

