/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import cofh.util.CoreUtils;
import cofh.util.ServerHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import redstonearsenal.item.tool.ItemToolRF;

public class ItemSickleRF
extends ItemToolRF {
    public static Set<Block> effectiveBlocks = new HashSet<Block>();
    public static Set<Material> effectiveMaterials = new HashSet<Material>();
    public int radius = 3;

    public ItemSickleRF(int id, EnumToolMaterial toolMaterial) {
        super(id, toolMaterial);
        this.damage = 5;
        this.energyPerUseCharged = 1600;
    }

    public ItemSickleRF setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    protected Set<Block> getEffectiveBlocks(ItemStack stack) {
        return effectiveBlocks;
    }

    @Override
    protected Set<Material> getEffectiveMaterials(ItemStack stack) {
        return effectiveMaterials;
    }

    public boolean func_77641_a(Block block) {
        return block.field_71990_ca == Block.field_71955_W.field_71990_ca || block.field_71990_ca == Block.field_71998_bu.field_71990_ca;
    }

    @Override
    protected void harvestBlock(World world, int x, int y, int z, EntityPlayer player) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block == Block.field_71991_bz) {
            return;
        }
        int bMeta = world.func_72805_g(x, y, z);
        if (block.canHarvestBlock(player, bMeta)) {
            block.func_71893_a(world, player, x, y, z, bMeta);
        }
        if (ServerHelper.isServerWorld((World)world) && block.field_71990_ca == Block.field_71998_bu.field_71990_ca) {
            CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)new ItemStack(Block.field_71998_bu), (World)world, (double)x, (double)y, (double)z);
        }
        world.func_94571_i(x, y, z);
    }

    public boolean func_77660_a(ItemStack stack, World world, int bId, int x, int y, int z, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if ((double)Block.field_71973_m[bId].func_71934_m(world, x, y, z) != 0.0 && !effectiveMaterials.contains(Block.field_71973_m[bId].field_72018_cp)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return false;
        }
        boolean used = false;
        int boost = this.isEmpowered(stack) ? 1 : 0;
        for (int i = x - (this.radius + boost); i <= x + (this.radius + boost); ++i) {
            for (int k = z - (this.radius + boost); k <= z + (this.radius + boost); ++k) {
                for (int j = y - boost; j <= y + boost; ++j) {
                    if (!this.isValidHarvestMaterial(stack, world, i, j, k)) continue;
                    this.harvestBlock(world, i, j, k, player);
                    used = true;
                }
            }
        }
        if (used) {
            this.useEnergy(stack, false);
        }
        return used;
    }

    static {
        effectiveMaterials.add(Material.field_76257_i);
        effectiveMaterials.add(Material.field_76254_j);
        effectiveMaterials.add(Material.field_76255_k);
        effectiveMaterials.add(Material.field_76232_D);
    }
}

