/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import buildcraft.api.tools.IToolWrench;
import cofh.api.block.IDismantleable;
import cofh.api.energy.IEnergyContainerItem;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import com.google.common.collect.Multimap;
import cpw.mods.fml.client.FMLClientHandler;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IShearable;

public class ItemWrenchRF
extends ItemShears
implements IToolCrowbar,
IToolWrench,
IEnergyContainerItem {
    protected EnumToolMaterial toolMaterial;
    Icon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;

    public ItemWrenchRF(int id, EnumToolMaterial toolMaterial) {
        super(id);
        this.toolMaterial = toolMaterial;
        this.func_77656_e(toolMaterial.func_77997_a());
        this.setNoRepair();
    }

    protected int useEnergy(ItemStack stack, boolean simulate) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return this.extractEnergy(stack, this.energyPerUse * (5 - unbreakingLevel) / 5, simulate);
    }

    protected int getEnergyPerUse(ItemStack stack) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return this.energyPerUse * (5 - unbreakingLevel) / 5;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(itemId, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(itemId, 1, 0), (int)this.maxEnergy));
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        entity.field_70177_z += 90.0f;
        entity.field_70177_z %= 360.0f;
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int hitSide, float hitX, float hitY, float hitZ) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int hitSide, float hitX, float hitY, float hitZ) {
        if (stack.func_77960_j() > 0) {
            stack.func_77964_b(0);
        }
        if (!player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
            return false;
        }
        int bId = world.func_72798_a(x, y, z);
        if (ServerHelper.isServerWorld((World)world) && player.func_70093_af() && Block.field_71973_m[bId] instanceof IDismantleable && ((IDismantleable)Block.field_71973_m[bId]).canDismantle(player, world, x, y, z)) {
            ((IDismantleable)Block.field_71973_m[bId]).dismantleBlock(player, world, x, y, z, false);
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return true;
        }
        if (BlockHelper.canRotate((int)bId)) {
            int bMeta = world.func_72805_g(x, y, z);
            if (player.func_70093_af()) {
                world.func_72921_c(x, y, z, BlockHelper.rotateVanillaBlockAlt((World)world, (int)bId, (int)bMeta, (int)x, (int)y, (int)z), 3);
                if (ServerHelper.isClientWorld((World)world)) {
                    String soundName = Block.field_71973_m[bId].field_72020_cn.func_82593_b();
                    FMLClientHandler.instance().getClient().field_71416_A.func_77366_a(soundName, 1.0f, 0.6f);
                }
            } else {
                world.func_72921_c(x, y, z, BlockHelper.rotateVanillaBlock((World)world, (int)bId, (int)bMeta, (int)x, (int)y, (int)z), 3);
                if (ServerHelper.isClientWorld((World)world)) {
                    String soundName = Block.field_71973_m[bId].field_72020_cn.func_82593_b();
                    FMLClientHandler.instance().getClient().field_71416_A.func_77366_a(soundName, 1.0f, 0.8f);
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return ServerHelper.isServerWorld((World)world);
        }
        if (!player.func_70093_af() && Block.field_71973_m[bId] != null && Block.field_71973_m[bId].rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)hitSide))) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_71038_i();
            return ServerHelper.isServerWorld((World)world);
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof IWrenchable) {
            ItemStack dropBlock;
            IWrenchable wrenchable = (IWrenchable)tile;
            if (player.func_70093_af()) {
                hitSide = BlockHelper.SIDE_OPPOSITE[hitSide];
            }
            if (wrenchable.wrenchCanSetFacing(player, hitSide)) {
                if (ServerHelper.isServerWorld((World)world)) {
                    wrenchable.setFacing((short)hitSide);
                }
            } else if (wrenchable.wrenchCanRemove(player) && (dropBlock = wrenchable.getWrenchDrop(player)) != null) {
                world.func_94575_c(x, y, z, 0);
                if (ServerHelper.isServerWorld((World)world)) {
                    ArrayList drops = Block.field_71973_m[bId].getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
                    if (drops.isEmpty()) {
                        drops.add(dropBlock);
                    } else {
                        drops.set(0, dropBlock);
                    }
                    for (ItemStack drop : drops) {
                        float f = 0.7f;
                        double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        EntityItem entity = new EntityItem(world, (double)x + x2, (double)y + y2, (double)z + z2, drop);
                        entity.field_70293_c = 10;
                        world.func_72838_d((Entity)entity);
                    }
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return ServerHelper.isServerWorld((World)world);
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (ServerHelper.isClientWorld((World)entity.field_70170_p)) {
            entity.field_70177_z += 90.0f;
            entity.field_70177_z %= 360.0f;
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(stack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(stack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
                for (ItemStack drop : drops) {
                    EntityItem ent = entity.func_70099_a(drop, 1.0f);
                    ent.field_70181_x += (double)(CoreUtils.rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((CoreUtils.rand.nextFloat() - CoreUtils.rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((CoreUtils.rand.nextFloat() - CoreUtils.rand.nextFloat()) * 0.1f);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useEnergy(stack, false);
                }
                entity.field_70177_z += 90.0f;
                entity.field_70177_z %= 360.0f;
            }
            return true;
        }
        entity.field_70177_z += 90.0f;
        entity.field_70177_z %= 360.0f;
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (ServerHelper.isClientWorld((World)player.field_70170_p)) {
            return false;
        }
        int bId = player.field_70170_p.func_72798_a(x, y, z);
        if (Block.field_71973_m[bId] instanceof IShearable && (target = (IShearable)Block.field_71973_m[bId]).isShearable(stack, player.field_70170_p, x, y, z)) {
            ArrayList drops = target.onSheared(stack, player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
            for (ItemStack drop : drops) {
                float f = 0.7f;
                double d = (double)(CoreUtils.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(CoreUtils.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(CoreUtils.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, drop);
                entityitem.field_70293_c = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_71064_a(StatList.field_75934_C[bId], 1);
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (stack.func_77960_j() > 0) {
            stack.func_77964_b(0);
        }
    }

    public boolean shouldPassSneakingClickToBlock(World world, int x, int y, int z) {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + stack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        list.add(StringHelper.getFlavorText((String)"info.redstonearsenal.tool.wrench"));
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1 + this.maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Short.MAX_VALUE;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 1.0, 0));
        return multimap;
    }

    public Icon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return this.getEnergyStored(stack) <= 0 ? this.drainedIcon : this.field_77791_bV;
    }

    public void func_94581_a(IconRegister ir) {
        this.field_77791_bV = ir.func_94245_a(this.func_111208_A());
        this.drainedIcon = ir.func_94245_a(this.func_111208_A() + "_Drained");
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    @Override
    public boolean canWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        return this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public void onWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_71038_i();
    }

    @Override
    public boolean canLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return player.func_70093_af() && this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public void onLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_71038_i();
    }

    @Override
    public boolean canBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return !player.func_70093_af() && this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar);
    }

    @Override
    public void onBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_71038_i();
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack stack = player.func_71045_bC();
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(player.func_71045_bC(), false);
        }
    }
}

