/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.BlockEnum;
import extracells.Extracells;
import extracells.container.ContainerTerminalFluid;
import extracells.gui.widget.AbstractFluidWidget;
import extracells.gui.widget.FluidWidgetComparator;
import extracells.gui.widget.WidgetFluidRequest;
import extracells.gui.widget.WidgetFluidSelector;
import extracells.tileentity.TileEntityTerminalFluid;
import extracells.util.SpecialFluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTerminalFluid
extends GuiContainer {
    public static final int xSize = 175;
    public static final int ySize = 203;
    public String currentFluidName;
    public long currentFluidAmount;
    private int currentScroll = 0;
    public TileEntityTerminalFluid tileEntity;
    private GuiTextField searchbar;
    private Fluid oldSelected;
    private List<Fluid> oldCraftables;
    private List<SpecialFluidStack> oldFluids;
    private List<AbstractFluidWidget> fluidWidgets = new ArrayList<AbstractFluidWidget>();
    private ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/terminalfluid.png");

    public GuiTerminalFluid(TileEntityTerminalFluid _tileEntity, EntityPlayer player) {
        super((Container)new ContainerTerminalFluid(player, _tileEntity.getInventory()));
        if (_tileEntity != null) {
            this.tileEntity = _tileEntity;
            this.oldSelected = _tileEntity.getCurrentFluid();
            this.oldFluids = _tileEntity.getFluids();
            this.oldCraftables = _tileEntity.getCurrentCraftables();
            this.currentFluidName = _tileEntity.getCurrentFluid() != null ? _tileEntity.getCurrentFluid().getLocalizedName() : "-";
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.fluidWidgets = new ArrayList<AbstractFluidWidget>();
        Mouse.getDWheel();
        ArrayList<Fluid> selectorFluids = new ArrayList<Fluid>();
        for (SpecialFluidStack stack : this.oldFluids) {
            this.fluidWidgets.add(new WidgetFluidSelector(this, stack));
            selectorFluids.add(stack.getFluidStack().getFluid());
        }
        for (Fluid fluid : this.oldCraftables) {
            if (selectorFluids.contains(fluid)) continue;
            this.fluidWidgets.add(new WidgetFluidRequest(this, fluid));
        }
        for (AbstractFluidWidget widget : this.fluidWidgets) {
            if (!(widget instanceof WidgetFluidSelector) || widget.getFluid() != this.oldSelected) continue;
            WidgetFluidSelector selector = (WidgetFluidSelector)widget;
            selector.setSelected(true);
            this.updateSelected(selector);
        }
        Collections.sort(this.fluidWidgets, new FluidWidgetComparator());
        this.searchbar = new GuiTextField(this.field_73886_k, this.field_74198_m + 81, this.field_74197_n - 12, 88, 10){
            private int xPos;
            private int yPos;
            private int width;
            private int height;
            {
                this.xPos = 0;
                this.yPos = 0;
                this.width = 0;
                this.height = 0;
            }

            public void func_73793_a(int x, int y, int mouseBtn) {
                boolean flag;
                boolean bl = flag = x >= this.xPos && x < this.xPos + this.width && y >= this.yPos && y < this.yPos + this.height;
                if (flag && mouseBtn == 3) {
                    this.func_73782_a("");
                }
            }
        };
        this.searchbar.func_73786_a(false);
        this.searchbar.func_73796_b(true);
        this.searchbar.func_73804_f(15);
    }

    protected void func_74185_a(float alpha, int sizeX, int sizeY) {
        if (this.tileEntity != null && !this.tileEntity.getFluids().isEmpty()) {
            Fluid currentSelected = this.tileEntity.getCurrentFluid();
            List<SpecialFluidStack> currentFluids = this.tileEntity.getFluids();
            List<Fluid> currentCraftables = this.tileEntity.getCurrentCraftables();
            if (this.oldSelected != currentSelected || this.oldFluids != currentFluids || this.oldCraftables != currentCraftables) {
                this.oldSelected = currentSelected;
                this.oldFluids = currentFluids;
                this.oldCraftables = currentCraftables;
                this.func_73866_w_();
            }
        } else {
            this.oldFluids = new ArrayList<SpecialFluidStack>();
            this.oldCraftables = new ArrayList<Fluid>();
            this.oldSelected = null;
            this.currentFluidName = "-";
            this.currentFluidAmount = 0L;
            this.func_73866_w_();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        this.func_73729_b(this.field_74198_m, this.field_74197_n - 18, 0, 0, 175, 203);
        this.searchbar.func_73795_f();
    }

    public void updateSelected(WidgetFluidSelector selector) {
        this.currentFluidName = selector.getFluid().getLocalizedName();
        this.currentFluidAmount = selector.getAmount();
        for (AbstractFluidWidget currentSelector : this.fluidWidgets) {
            if (!(currentSelector instanceof WidgetFluidSelector)) continue;
            ((WidgetFluidSelector)currentSelector).setSelected(selector == currentSelector);
        }
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        this.field_73886_k.func_78276_b(BlockEnum.FLUIDTERMINAL.getStatName().replace("ME ", ""), 5, -12, 0);
        this.drawWidgets(mouseX, mouseY);
        boolean shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        String amountToText = Long.toString(this.currentFluidAmount) + "mB";
        if (Extracells.shortenedBuckets) {
            if (this.currentFluidAmount > 1000000000L) {
                amountToText = shiftDown ? Long.toString(this.currentFluidAmount / 1000000L) + "KiloB" : Long.toString(this.currentFluidAmount / 1000000000L) + "MegaB";
            } else if (this.currentFluidAmount > 1000000L) {
                amountToText = shiftDown ? Long.toString(this.currentFluidAmount / 1000L) + "B" : Long.toString(this.currentFluidAmount / 1000000L) + "KiloB";
            } else if (this.currentFluidAmount > 9999L) {
                amountToText = Long.toString(this.currentFluidAmount / 1000L) + "B";
            }
        }
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"tooltip.amount") + ": " + amountToText, 45, 73, 0);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"tooltip.fluid") + ": " + this.currentFluidName, 45, 83, 0);
    }

    public void drawWidgets(int mouseX, int mouseY) {
        int listSize = this.fluidWidgets.size();
        if (this.tileEntity != null && !this.tileEntity.getFluids().isEmpty()) {
            int widgetIndex;
            block0: for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 9; ++x) {
                    widgetIndex = y * 9 + x + this.currentScroll * 9;
                    if (0 > widgetIndex || widgetIndex >= listSize) break block0;
                    AbstractFluidWidget widget = this.fluidWidgets.get(widgetIndex);
                    widget.drawWidget(x * 18 + 7, y * 18 - 1);
                }
            }
            for (int x = 0; x < 9; ++x) {
                for (int y = 0; y < 4 && 0 <= (widgetIndex = y * 9 + x) && widgetIndex < listSize; ++y) {
                    this.fluidWidgets.get(widgetIndex).drawTooltip(x * 18 + 7, y * 18 - 1, mouseX, mouseY);
                }
            }
            int deltaWheel = Mouse.getDWheel();
            if (deltaWheel > 0) {
                ++this.currentScroll;
            } else if (deltaWheel < 0) {
                --this.currentScroll;
            }
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (listSize / 9 < 4 && this.currentScroll < listSize / 9 + 4) {
                this.currentScroll = 0;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        this.searchbar.func_73793_a(mouseX, mouseY, mouseBtn);
        int listSize = this.fluidWidgets.size();
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 4; ++y) {
                int index = y * 9 + x;
                if (0 > index || index >= listSize) continue;
                AbstractFluidWidget widget = this.fluidWidgets.get(index);
                widget.mouseClicked(x * 18 + 7, y * 18 - 1, mouseX, mouseY);
            }
        }
    }

    protected void func_73869_a(char key, int keyID) {
        if (keyID == 1) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
        this.searchbar.func_73802_a(key, keyID);
    }

    public int guiLeft() {
        return this.field_74198_m;
    }

    public int guiTop() {
        return this.field_74197_n;
    }
}

