/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.tconstruct;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import tconstruct.library.crafting.Smeltery;

public class SmelteryRecipeHandler
extends LiquidTemplateRecipeHandler {
    public static final int xOffset = 0;
    static Rectangle metalTank = new Rectangle(115, 22, 18, 18);

    public String getRecipeName() {
        return "Smeltery";
    }

    @Override
    public String getRecipeId() {
        return "tconstruct.smeltery";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 20, 16, 34), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (List key : Smeltery.getSmeltingList().keySet()) {
                this.arecipes.add(new CachedSmelteryRecipe((Integer)key.get(0), (Integer)key.get(1)));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof FluidStack) {
            FluidStack t = (FluidStack)results[0];
            for (Map.Entry pair : Smeltery.getSmeltingList().entrySet()) {
                if (!LiquidHelper.areSameLiquid((FluidStack)pair.getValue(), t)) continue;
                this.arecipes.add(new CachedSmelteryRecipe((Integer)((List)pair.getKey()).get(0), (Integer)((List)pair.getKey()).get(1)));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        for (List key : Smeltery.getSmeltingList().keySet()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(((Integer)key.get(0)).intValue(), 1, ((Integer)key.get(1)).intValue()), (ItemStack)ingred)) continue;
            this.arecipes.add(new CachedSmelteryRecipe((Integer)key.get(0), (Integer)key.get(1)));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack t = LiquidHelper.getFluidStack(result);
        if (t != null) {
            for (Map.Entry pair : Smeltery.getSmeltingList().entrySet()) {
                if (!LiquidHelper.areSameLiquid((FluidStack)pair.getValue(), t)) continue;
                this.arecipes.add(new CachedSmelteryRecipe((Integer)((List)pair.getKey()).get(0), (Integer)((List)pair.getKey()).get(1)));
            }
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)55);
    }

    public String getGuiTexture() {
        return "neiplugins:gfx/tc_smeltery.png";
    }

    public void drawExtras(int recipe) {
        Integer temperature = ((CachedSmelteryRecipe)this.arecipes.get((int)recipe)).temperature;
        String tempString = temperature.toString() + " C";
        GuiDraw.drawStringC((String)tempString, (int)81, (int)9, (int)-8355712, (boolean)false);
    }

    public class CachedSmelteryRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        PositionedStack input;
        LiquidTank metal;
        Integer temperature;

        public CachedSmelteryRecipe(Integer blockID, Integer meta) {
            super((TemplateRecipeHandler)SmelteryRecipeHandler.this);
            this.temperature = Smeltery.getLiquifyTemperature((int)blockID, (int)meta);
            this.metal = new LiquidTank(Smeltery.getSmelteryResult((int)blockID, (int)meta), 1, metalTank);
            this.metal.showMillBuckets = true;
            this.metal.capacity = this.metal.liquid.amount;
            this.metal.showCapacity = false;
            this.input = new PositionedStack((Object)new ItemStack(blockID.intValue(), 1, meta.intValue()), 28, 21);
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.metal);
            return res;
        }
    }
}

