/*
 * Decompiled with CFR 0.152.
 */
package main.launchgui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import main.launchgui.LaunchGui;
import net.minecraftforge.common.Configuration;

public class ConfigHandler {
    public static String internal = "Internal";
    public static String main = "Main";
    public static String lines = "Lines";
    public static boolean displayGuiOnLaunch;
    public static String modToFind;
    public static String guiTitle;
    public static String line1;
    public static String line2;
    public static String line3;
    public static String line4;
    public static String line5;
    public static String line6;
    public static String line7;
    public static String line8;
    public static String line9;
    public static String buttonText;
    public static File cfg;

    public static void init(File file) {
        Configuration config = new Configuration(file);
        config.load();
        config.addCustomCategoryComment(lines, "These are the options for what your GUI says. Change them as you please, but try to keep them short. It won't split lines for you. Leave blank if unused.");
        displayGuiOnLaunch = config.get(internal, "displayGuiOnLaunch", true, "Whether or not to display the GUI on launch. Should not be touched.").getBoolean(displayGuiOnLaunch);
        modToFind = config.get(main, "modToFind", "LaunchGUI", "Requires this mod to load the GUI. To always load no matter what, use a mod that is always installed.").getString().toLowerCase();
        guiTitle = config.get(lines, "guiTitle", "TITLE", "Title of your GUI. Appears at the top.").getString();
        line1 = config.get(lines, "line1", "These are your information lines in the GUI").getString();
        line2 = config.get(lines, "line2", "").getString();
        line3 = config.get(lines, "line3", "").getString();
        line4 = config.get(lines, "line4", "").getString();
        line5 = config.get(lines, "line5", "").getString();
        line6 = config.get(lines, "line6", "").getString();
        line7 = config.get(lines, "line7", "").getString();
        line8 = config.get(lines, "line8", "").getString();
        line9 = config.get(lines, "line9", "").getString();
        buttonText = config.get(lines, "buttonText", "Continue to Game", "Text to display on the button").getString();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean manuallyChangeConfigValue(String prefix, String from, String to) {
        return ConfigHandler.manuallyChangeConfigValue(null, prefix, from, to);
    }

    public static boolean manuallyChangeConfigValue(String filePathFromConfigFolder, String prefix, String from, String to) {
        File config = filePathFromConfigFolder == null ? cfg : new File("config/launchgui.cfg");
        boolean found = false;
        try {
            FileReader fr1 = new FileReader(config);
            BufferedReader read = new BufferedReader(fr1);
            ArrayList<String> strings = new ArrayList<String>();
            while (read.ready()) {
                strings.add(read.readLine());
            }
            fr1.close();
            read.close();
            FileWriter fw = new FileWriter(config);
            BufferedWriter bw = new BufferedWriter(fw);
            for (String s : strings) {
                if (!found && s.contains(prefix + "=" + from) && !s.contains("=" + to)) {
                    s = s.replace(prefix + "=" + from, prefix + "=" + to);
                    LaunchGui.logger.info("Successfully changed config value " + prefix + " from " + from + " to " + to);
                    found = true;
                }
                fw.write(s + "\n");
            }
            bw.flush();
            bw.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return found;
    }
}

