/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.InvTweaks;
import invtweaks.InvTweaksObfuscation;
import invtweaks.api.container.ContainerSection;
import invtweaks.forge.InvTweaksMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InvTweaksContainerManager {
    public static final int DROP_SLOT = -999;
    public static final int HOTBAR_SIZE = 9;
    private GuiContainer guiContainer;
    private Container container;
    private Map<ContainerSection, List<Slot>> slotRefs = new HashMap<ContainerSection, List<Slot>>();
    private int clickDelay = 0;

    @SideOnly(value=Side.CLIENT)
    public InvTweaksContainerManager(Minecraft minecraft) {
        GuiScreen guiScreen = minecraft.field_71462_r;
        if (guiScreen instanceof GuiContainer) {
            this.guiContainer = (GuiContainer)guiScreen;
            this.container = this.guiContainer.field_74193_d;
        } else {
            this.container = minecraft.field_71439_g.field_71069_bz;
        }
        this.initSlots();
    }

    public InvTweaksContainerManager(Container container, GuiContainer guiContainer) {
        this.guiContainer = guiContainer;
        this.container = container;
        this.initSlots();
    }

    private void initSlots() {
        List list;
        int n;
        this.slotRefs = InvTweaksObfuscation.getContainerSlotMap(this.container);
        if (this.slotRefs == null) {
            this.slotRefs = new HashMap<ContainerSection, List<Slot>>();
        }
        if ((n = (list = this.container.field_75151_b).size()) >= 36 && !this.slotRefs.containsKey((Object)ContainerSection.INVENTORY)) {
            this.slotRefs.put(ContainerSection.INVENTORY, list.subList(n - 36, n));
            this.slotRefs.put(ContainerSection.INVENTORY_NOT_HOTBAR, list.subList(n - 36, n - 9));
            this.slotRefs.put(ContainerSection.INVENTORY_HOTBAR, list.subList(n - 9, n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean move(ContainerSection containerSection, int n, ContainerSection containerSection2, int n2) {
        Slot slot;
        ItemStack itemStack = this.getItemStack(containerSection, n);
        ItemStack itemStack2 = this.getItemStack(containerSection2, n2);
        if (itemStack == null && n2 != -999) {
            return false;
        }
        if (containerSection == containerSection2 && n == n2) {
            return true;
        }
        if (n2 != -999 && !(slot = this.getSlot(containerSection2, n2)).func_75214_a(itemStack)) {
            return false;
        }
        if (InvTweaks.getInstance().getHeldStack() != null) {
            int n3 = this.getFirstEmptyIndex(ContainerSection.INVENTORY);
            if (n3 == -1) return false;
            this.leftClick(ContainerSection.INVENTORY, n3);
        }
        if (itemStack2 != null && itemStack.field_77993_c == itemStack2.field_77993_c && (itemStack.func_77976_d() == 1 || itemStack.func_77942_o() || itemStack2.func_77942_o())) {
            int n4 = this.getFirstEmptyUsableSlotNumber();
            ContainerSection containerSection3 = this.getSlotSection(n4);
            int n5 = this.getSlotIndex(n4);
            if (n5 == -1) return false;
            Slot slot2 = this.getSlot(containerSection3, n5);
            if (!slot2.func_75214_a(itemStack2)) {
                return false;
            }
            Slot slot3 = this.getSlot(containerSection, n);
            if (!slot3.func_75214_a(itemStack2)) {
                return false;
            }
            this.leftClick(containerSection2, n2);
            this.leftClick(containerSection3, n5);
            this.leftClick(containerSection, n);
            this.leftClick(containerSection2, n2);
            this.leftClick(containerSection3, n5);
            this.leftClick(containerSection, n);
            return true;
        } else {
            this.leftClick(containerSection, n);
            this.leftClick(containerSection2, n2);
            if (InvTweaks.getInstance().getHeldStack() == null) return true;
            slot = this.getSlot(containerSection, n);
            if (slot.func_75214_a(InvTweaks.getInstance().getHeldStack())) {
                this.leftClick(containerSection, n);
                return true;
            } else {
                int n6 = this.getFirstEmptyIndex(ContainerSection.INVENTORY);
                if (n6 == -1) return true;
                this.leftClick(ContainerSection.INVENTORY, n6);
            }
        }
        return true;
    }

    public boolean moveSome(ContainerSection containerSection, int n, ContainerSection containerSection2, int n2, int n3) {
        ItemStack itemStack = this.getItemStack(containerSection, n);
        if (itemStack == null || containerSection == containerSection2 && n == n2) {
            return true;
        }
        ItemStack itemStack2 = this.getItemStack(containerSection, n);
        int n4 = itemStack.field_77994_a;
        int n5 = Math.min(n3, n4);
        if (itemStack2 == null || InvTweaksObfuscation.areItemStacksEqual(itemStack, itemStack2)) {
            this.leftClick(containerSection, n);
            for (int i = 0; i < n5; ++i) {
                this.rightClick(containerSection2, n2);
            }
            if (n5 < n4) {
                this.leftClick(containerSection, n);
            }
            return true;
        }
        return false;
    }

    public boolean drop(ContainerSection containerSection, int n) {
        return this.move(containerSection, n, null, -999);
    }

    public boolean dropSome(ContainerSection containerSection, int n, int n2) {
        return this.moveSome(containerSection, n, null, -999, n2);
    }

    public boolean putHoldItemDown(ContainerSection containerSection, int n) {
        ItemStack itemStack = InvTweaks.getInstance().getHeldStack();
        if (itemStack != null) {
            if (this.getItemStack(containerSection, n) == null) {
                this.click(containerSection, n, false);
                return true;
            }
            return false;
        }
        return true;
    }

    public void leftClick(ContainerSection containerSection, int n) {
        this.click(containerSection, n, false);
    }

    public void rightClick(ContainerSection containerSection, int n) {
        this.click(containerSection, n, true);
    }

    public void click(ContainerSection containerSection, int n, boolean bl) {
        int n2 = this.indexToSlot(containerSection, n);
        if (n2 != -1) {
            int n3 = bl ? 1 : 0;
            InvTweaksMod.proxy.slotClick(InvTweaks.getInstance().getPlayerController(), this.container.field_75152_c, n2, n3, 0, InvTweaks.getInstance().getThePlayer());
        }
        if (this.clickDelay > 0) {
            try {
                Thread.sleep(this.clickDelay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public boolean hasSection(ContainerSection containerSection) {
        return this.slotRefs.containsKey((Object)containerSection);
    }

    public List<Slot> getSlots(ContainerSection containerSection) {
        return this.slotRefs.get((Object)containerSection);
    }

    public int getSize() {
        int n = 0;
        for (List<Slot> list : this.slotRefs.values()) {
            n += list.size();
        }
        return n;
    }

    public int getSize(ContainerSection containerSection) {
        if (this.hasSection(containerSection)) {
            return this.slotRefs.get((Object)containerSection).size();
        }
        return 0;
    }

    public int getFirstEmptyIndex(ContainerSection containerSection) {
        int n = 0;
        for (Slot slot : this.slotRefs.get((Object)containerSection)) {
            if (!slot.func_75216_d()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isSlotEmpty(ContainerSection containerSection, int n) {
        if (this.hasSection(containerSection)) {
            return this.getItemStack(containerSection, n) == null;
        }
        return false;
    }

    public Slot getSlot(ContainerSection containerSection, int n) {
        List<Slot> list = this.slotRefs.get((Object)containerSection);
        if (list != null) {
            return list.get(n);
        }
        return null;
    }

    public int getSlotIndex(int n) {
        return this.getSlotIndex(n, false);
    }

    public int getSlotIndex(int n, boolean bl) {
        for (ContainerSection containerSection : this.slotRefs.keySet()) {
            if ((bl || containerSection == ContainerSection.INVENTORY) && (!bl || containerSection == ContainerSection.INVENTORY_NOT_HOTBAR || containerSection == ContainerSection.INVENTORY_HOTBAR)) continue;
            int n2 = 0;
            for (Slot slot : this.slotRefs.get((Object)containerSection)) {
                if (InvTweaksObfuscation.getSlotNumber(slot) == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public ContainerSection getSlotSection(int n) {
        for (ContainerSection containerSection : this.slotRefs.keySet()) {
            if (containerSection == ContainerSection.INVENTORY) continue;
            for (Slot slot : this.slotRefs.get((Object)containerSection)) {
                if (InvTweaksObfuscation.getSlotNumber(slot) != n) continue;
                return containerSection;
            }
        }
        return null;
    }

    public ItemStack getItemStack(ContainerSection containerSection, int n) throws NullPointerException, IndexOutOfBoundsException {
        int n2 = this.indexToSlot(containerSection, n);
        if (n2 >= 0 && n2 < this.container.field_75151_b.size()) {
            return InvTweaksObfuscation.getSlotStack(this.container, n2);
        }
        return null;
    }

    public Container getContainer() {
        return this.container;
    }

    private int getFirstEmptyUsableSlotNumber() {
        for (ContainerSection containerSection : this.slotRefs.keySet()) {
            for (Slot slot : this.slotRefs.get((Object)containerSection)) {
                if (!InvTweaksObfuscation.isBasicSlot(slot) || slot.func_75216_d()) continue;
                return InvTweaksObfuscation.getSlotNumber(slot);
            }
        }
        return -1;
    }

    private int indexToSlot(ContainerSection containerSection, int n) {
        if (n == -999) {
            return -999;
        }
        if (this.hasSection(containerSection)) {
            Slot slot = this.slotRefs.get((Object)containerSection).get(n);
            if (slot != null) {
                return InvTweaksObfuscation.getSlotNumber(slot);
            }
            return -1;
        }
        return -1;
    }

    public void setClickDelay(int n) {
        this.clickDelay = n;
    }
}

