/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeLoader;
import invtweaks.api.IItemTreeListener;
import invtweaks.forge.CommonProxy;
import invtweaks.forge.ForgeClientTick;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class ClientProxy
extends CommonProxy
implements IPickupNotifier {
    private InvTweaks instance;
    private ForgeClientTick clientTick;
    public boolean serverSupportEnabled = false;
    public boolean serverSupportDetected = false;

    @Override
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        InvTweaks.log = fMLPreInitializationEvent.getModLog();
    }

    @Override
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        this.instance = new InvTweaks(minecraft);
        this.clientTick = new ForgeClientTick(this.instance);
        TickRegistry.registerTickHandler((ITickHandler)this.clientTick, (Side)Side.CLIENT);
        GameRegistry.registerPickupHandler((IPickupNotifier)this);
    }

    public void notifyPickup(EntityItem entityItem, EntityPlayer entityPlayer) {
        this.instance.setItemPickupPending(true);
    }

    @Override
    public void setServerAssistEnabled(boolean bl) {
        this.serverSupportEnabled = this.serverSupportDetected && bl;
        InvTweaks.log.info("Server has support: " + this.serverSupportDetected + " support enabled: " + this.serverSupportEnabled);
    }

    @Override
    public void setServerHasInvTweaks(boolean bl) {
        this.serverSupportDetected = bl;
        this.serverSupportEnabled = bl && !InvTweaks.getConfigManager().getConfig().getProperty("enableServerItemSwap").equals("false");
        InvTweaks.log.info("Server has support: " + bl + " support enabled: " + this.serverSupportEnabled);
    }

    @Override
    public void slotClick(PlayerControllerMP playerControllerMP, int n, int n2, int n3, int n4, EntityPlayer entityPlayer) {
        if (this.serverSupportEnabled) {
            entityPlayer.field_71070_bA.func_75144_a(n2, n3, n4, entityPlayer);
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeByte(1);
            byteArrayDataOutput.writeInt(n2);
            byteArrayDataOutput.writeInt(n3);
            byteArrayDataOutput.writeInt(n4);
            Packet250CustomPayload packet250CustomPayload = PacketDispatcher.getPacket((String)"InventoryTweaks", (byte[])byteArrayDataOutput.toByteArray());
            PacketDispatcher.sendPacketToServer((Packet)packet250CustomPayload);
        } else {
            playerControllerMP.func_78753_a(n, n2, n3, n4, entityPlayer);
        }
    }

    @Override
    public void sortComplete() {
        if (this.serverSupportEnabled) {
            Packet250CustomPayload packet250CustomPayload = new Packet250CustomPayload("InventoryTweaks", new byte[]{2});
            PacketDispatcher.sendPacketToServer((Packet)packet250CustomPayload);
        }
    }

    @Override
    public void addOnLoadListener(IItemTreeListener iItemTreeListener) {
        InvTweaksItemTreeLoader.addOnLoadListener(iItemTreeListener);
    }

    @Override
    public boolean removeOnLoadListener(IItemTreeListener iItemTreeListener) {
        return InvTweaksItemTreeLoader.removeOnLoadListener(iItemTreeListener);
    }

    @Override
    public void setSortKeyEnabled(boolean bl) {
        this.instance.setSortKeyEnabled(bl);
    }

    @Override
    public void setTextboxMode(boolean bl) {
        this.instance.setTextboxMode(bl);
    }

    @Override
    public int compareItems(ItemStack itemStack, ItemStack itemStack2) {
        return this.instance.compareItems(itemStack, itemStack2);
    }
}

