/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.tileentities;

import exnihilo.Blocks;
import exnihilo.compatibility.foresty.Forestry;
import exnihilo.data.BlockData;
import exnihilo.registries.ColorRegistry;
import exnihilo.registries.helpers.Color;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class TileEntityLeavesInfested
extends TileEntity {
    public int blockID;
    public int meta;
    public Color color;
    public boolean dying;
    public boolean permanent;
    private static final int SPREAD_INTERVAL = 100;
    private int spreadTimer;
    private static final float PROGRESS_INTERVAL = 5.0E-4f;
    private float progress;

    public TileEntityLeavesInfested() {
        this.blockID = Block.field_71952_K.field_71990_ca;
        this.meta = 0;
        this.color = ColorRegistry.color("white");
        this.dying = false;
        this.permanent = false;
        this.spreadTimer = 0;
        this.progress = 0.0f;
    }

    public void func_70316_g() {
        if (this.progress < 1.0f) {
            this.progress += 5.0E-4f;
            if (this.progress > 1.0f) {
                this.progress = 1.0f;
            }
        }
        if (!this.field_70331_k.field_72995_K && this.progress > 0.6f) {
            ++this.spreadTimer;
            if (this.spreadTimer >= 100) {
                this.spread();
                this.spreadTimer = this.field_70331_k.field_73012_v.nextInt(10);
                if (this.progress < 1.0f) {
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
    }

    public boolean isComplete() {
        return this.progress >= 5.0E-4f;
    }

    public Color getRenderColor() {
        Block mimic = Block.field_71973_m[this.blockID];
        Color base = new Color(mimic.func_71920_b((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n));
        Color white = ColorRegistry.color("white");
        return Color.average(base, white, this.progress);
    }

    public int getBrightness() {
        Block block = Block.field_71973_m[this.blockID];
        return block.func_71874_e((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public float getProgress() {
        return this.progress;
    }

    private void spread() {
        int x = this.field_70331_k.field_73012_v.nextInt(3) - 1;
        int y = this.field_70331_k.field_73012_v.nextInt(3) - 1;
        int z = this.field_70331_k.field_73012_v.nextInt(3) - 1;
        int blockID = this.field_70331_k.func_72798_a(this.field_70329_l + x, this.field_70330_m + y, this.field_70327_n + z);
        int meta = this.field_70331_k.func_72805_g(this.field_70329_l + x, this.field_70330_m + y, this.field_70327_n + z);
        Block target = Block.field_71973_m[blockID];
        if (target != null && target.isLeaves(this.field_70331_k, x, y, z) && target.field_71990_ca != Blocks.LeavesInfested.field_71990_ca && !Forestry.addsThisLeaf(target)) {
            this.field_70331_k.func_72832_d(this.field_70329_l + x, this.field_70330_m + y, this.field_70327_n + z, Blocks.LeavesInfested.field_71990_ca, meta, 3);
            TileEntityLeavesInfested te = (TileEntityLeavesInfested)this.field_70331_k.func_72796_p(this.field_70329_l + x, this.field_70330_m + y, this.field_70327_n + z);
            if (te != null) {
                te.setMimicBlock(blockID, meta);
            }
        }
    }

    public void setMimicBlock(int blockID, int meta) {
        this.blockID = blockID;
        this.meta = meta;
    }

    public void func_70307_a(NBTTagCompound compound) {
        int tempMeta;
        super.func_70307_a(compound);
        this.progress = compound.func_74760_g("progress");
        int tempBlockID = compound.func_74762_e("blockID");
        if (tempBlockID != 0) {
            this.blockID = tempBlockID;
        }
        if ((tempMeta = compound.func_74762_e("meta")) != 0) {
            this.meta = tempMeta;
        }
        this.permanent = compound.func_74767_n("permanent");
        this.dying = compound.func_74767_n("dying");
    }

    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74776_a("progress", this.progress);
        compound.func_74768_a("blockID", this.blockID);
        compound.func_74768_a("meta", this.meta);
        compound.func_74757_a("permanent", this.permanent);
        compound.func_74757_a("dying", this.dying);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, BlockData.LEAVES_INFESTED_ID, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        NBTTagCompound tag = pkt.field_73331_e;
        this.func_70307_a(tag);
    }
}

