/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.util.StackUtils;

public class ItemEnergyArmor
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem {
    protected String name;
    protected int maxEnergy;
    protected int maxInput;
    protected int maxOutput;
    protected ISpecialArmor.ArmorProperties properties = new ISpecialArmor.ArmorProperties(0, 1.0, 0);

    public ItemEnergyArmor(int id, EnumArmorMaterial material, int renderIndex, int armorType, String name, int maxEnergy, int maxInput, int maxOutput) {
        super(id, material, renderIndex, armorType);
        this.name = name;
        this.maxEnergy = maxEnergy;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.func_77655_b("simplyjetpacks." + name);
        this.setNoRepair();
        this.func_77637_a(SimplyJetpacks.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.field_77791_bV = register.func_94245_a("simplyjetpacks:" + this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "simplyjetpacks:textures/armor/" + this.name + "_layer_" + (slot == 2 ? "1" : "0") + ".png";
    }

    public void func_77633_a(int id, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack((Item)this));
        list.add(this.getChargedItem(this));
    }

    public void toggle(ItemStack itemStack, EntityPlayer player) {
        if (this.isOn(itemStack)) {
            player.func_71035_c(this.getDeactivateMsg());
            itemStack.field_77990_d.func_74757_a("On", false);
        } else {
            player.func_71035_c(this.getActivateMsg());
            itemStack.field_77990_d.func_74757_a("On", true);
        }
    }

    public String getActivateMsg() {
        return "Enabled";
    }

    public String getDeactivateMsg() {
        return "Disabled";
    }

    public boolean isOn(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("On");
    }

    public boolean isDamaged(ItemStack itemStack) {
        return itemStack.func_77960_j() < Short.MAX_VALUE;
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.getMaxEnergyStored(itemStack) + 1;
    }

    public int getDisplayDamage(ItemStack itemStack) {
        return this.getMaxEnergyStored(itemStack) - this.getEnergyStored(itemStack) + 1;
    }

    public int addEnergy(ItemStack container, int energyToAdd, boolean simulate) {
        StackUtils.getNBT(container);
        int energyCurrent = container.field_77990_d.func_74762_e("Energy");
        int energyAdded = Math.min(this.getMaxEnergyStored(container) - energyCurrent, energyToAdd);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energyCurrent += energyAdded);
        }
        return energyAdded;
    }

    public int subtractEnergy(ItemStack container, int energyToSubtract, boolean simulate) {
        StackUtils.getNBT(container);
        int energyCurrent = container.field_77990_d.func_74762_e("Energy");
        int energySubtracted = Math.min(energyCurrent, energyToSubtract);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energyCurrent -= energySubtracted);
        }
        return energySubtracted;
    }

    public ItemStack getChargedItem(ItemEnergyArmor item) {
        ItemStack full = new ItemStack((Item)item);
        item.addEnergy(full, item.getMaxEnergyStored(full), false);
        return full;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return this.properties;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, this.maxInput));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, this.maxOutput));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        return StackUtils.getNBT(container).func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }
}

