/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.jetpack;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import tonius.simplyjetpacks.KeyboardTracker;
import tonius.simplyjetpacks.SJItems;
import tonius.simplyjetpacks.config.MainConfig;
import tonius.simplyjetpacks.item.ItemEnergyArmor;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class ItemJetpack
extends ItemEnergyArmor {
    protected int jetpackTier;
    protected int tickEnergy;
    protected int tickEnergyHover;
    protected double maxSpeed;
    protected double acceleration;
    protected double forwardThrust;
    protected double hoverModeIdleSpeed;
    protected double hoverModeActiveSpeed;

    public ItemJetpack(int id, EnumArmorMaterial material, String name, int maxEnergy, int maxInput, int jetpackTier, int tickEnergy, double maxSpeed, double acceleration, double forwardThrust, double hoverModeIdleSpeed, double hoverModeActiveSpeed) {
        super(id, material, 2, 1, name, maxEnergy, maxInput, 0);
        this.jetpackTier = jetpackTier;
        this.tickEnergy = tickEnergy;
        this.tickEnergyHover = (int)((double)tickEnergy / 1.5);
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.forwardThrust = forwardThrust;
        this.hoverModeIdleSpeed = hoverModeIdleSpeed;
        this.hoverModeActiveSpeed = hoverModeActiveSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77628_j(ItemStack itemStack) {
        switch (this.jetpackTier) {
            case 3: {
                return "\u00a7e" + super.func_77628_j(itemStack);
            }
            case 4: {
                return "\u00a7b" + super.func_77628_j(itemStack);
            }
            case 9001: {
                return "\u00a7d" + super.func_77628_j(itemStack);
            }
        }
        return super.func_77628_j(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (StringUtils.canShowDetails()) {
            list.add(StringUtils.getChargeText(this.jetpackTier == 9001, this.getEnergyStored(itemStack), this.getMaxEnergyStored(itemStack)));
            list.add(StringUtils.getStateText(this.isOn(itemStack)));
            list.add(StringUtils.getHoverModeText(this.isHoverModeActive(itemStack)));
            int currentTickEnergy = this.isHoverModeActive(itemStack) ? this.tickEnergyHover : this.tickEnergy;
            list.add(StringUtils.getEnergyUsageText(currentTickEnergy));
            list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.1"));
            list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.2"));
            if (this.jetpackTier > 0 && this.jetpackTier <= 4 && MainConfig.enableCraftingArmorPlating) {
                list.add(StringUtils.getArmorText(this.isArmored()));
                if (!this.isArmored()) {
                    list.add(StringUtils.getRequiredArmorText(this.jetpackTier));
                }
            }
        } else {
            list.add(StringUtils.getShiftText());
        }
    }

    @Override
    public void func_77633_a(int id, CreativeTabs creativeTabs, List list) {
        if (this.jetpackTier > 0 && this.jetpackTier <= 4) {
            list.add(new ItemStack((Item)this));
        }
        list.add(this.getChargedItem(this));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (this.jetpackTier > 0 && this.jetpackTier <= 4 && player.func_70093_af()) {
            if (this.isArmored()) {
                this.removeArmor(itemStack, player);
                EntityItem item = player.func_71021_b(new ItemStack((Item)SJItems.components, 1, this.jetpackTier + 4));
                item.field_70293_c = 0;
            } else {
                InventoryPlayer inv = player.field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack currentStack = inv.func_70301_a(i);
                    if (currentStack == null || currentStack.func_77973_b() != SJItems.components || currentStack.func_77960_j() != this.jetpackTier + 4) continue;
                    inv.func_70299_a(i, StackUtils.decrementStack(currentStack));
                    this.applyArmor(itemStack, player);
                    break;
                }
            }
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        this.useJetpack((EntityLivingBase)player, itemStack, false);
    }

    @Override
    public boolean isDamaged(ItemStack itemStack) {
        return this.jetpackTier == 9001 ? false : super.isDamaged(itemStack);
    }

    public void useJetpack(EntityLivingBase user, ItemStack jetpack, boolean force) {
        if (this.isOn(jetpack)) {
            boolean hoverMode = this.isHoverModeActive(jetpack);
            double hoverSpeed = this.getHoverSpeed(jetpack, user);
            boolean jumpKeyDown = true;
            if (!force && user instanceof EntityPlayer && !KeyboardTracker.isJumpKeyDown((EntityPlayer)user)) {
                jumpKeyDown = false;
            }
            if (jumpKeyDown || hoverMode && !user.field_70122_E && user.field_70181_x < 0.0) {
                int usedPower;
                int n = usedPower = hoverMode ? this.tickEnergyHover : this.tickEnergy;
                if (!user.field_70170_p.field_72995_K) {
                    this.subtractEnergy(jetpack, usedPower, false);
                }
                if (this.getEnergyStored(jetpack) > 0) {
                    user.field_70181_x = jumpKeyDown ? (!hoverMode ? Math.min(user.field_70181_x + this.acceleration, this.maxSpeed) : Math.min(user.field_70181_x + this.acceleration, this.hoverModeActiveSpeed)) : Math.max(user.field_70181_x, -hoverSpeed);
                    if (user instanceof EntityPlayer) {
                        if (KeyboardTracker.isForwardKeyDown((EntityPlayer)user)) {
                            user.func_70060_a(0.0f, (float)this.forwardThrust, (float)this.forwardThrust);
                        }
                        if (KeyboardTracker.isBackwardKeyDown((EntityPlayer)user)) {
                            user.func_70060_a(0.0f, (float)(-this.forwardThrust), (float)this.forwardThrust * 0.8f);
                        }
                        if (KeyboardTracker.isLeftKeyDown((EntityPlayer)user)) {
                            user.func_70060_a((float)this.forwardThrust, 0.0f, (float)this.forwardThrust);
                        }
                        if (KeyboardTracker.isRightKeyDown((EntityPlayer)user)) {
                            user.func_70060_a((float)(-this.forwardThrust), 0.0f, (float)this.forwardThrust);
                        }
                    }
                    if (!user.field_70170_p.field_72995_K) {
                        user.field_70143_R = 0.0f;
                        if (user instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)user).field_71135_a.field_72572_g = 0;
                        }
                        this.sendParticlePacket(user, this.getParticleType(jetpack));
                    }
                }
            }
        }
    }

    public void applyArmor(ItemStack jetpack, EntityPlayer player) {
        jetpack.field_77993_c = SJItems.armoredJetpacks[this.jetpackTier].field_77779_bT;
        player.field_70170_p.func_72956_a((Entity)player, "random.anvil_use", 0.8f, 0.9f + player.func_70681_au().nextFloat() * 0.2f);
    }

    public void removeArmor(ItemStack jetpack, EntityPlayer player) {
        jetpack.field_77993_c = SJItems.jetpacks[this.jetpackTier].field_77779_bT;
        player.field_70170_p.func_72956_a((Entity)player, "random.break", 1.0f, 0.9f + player.func_70681_au().nextFloat() * 0.2f);
    }

    public boolean isHoverModeActive(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("HoverModeActive");
    }

    public void toggleHoverMode(ItemStack itemStack, EntityPlayer player) {
        if (this.isHoverModeActive(itemStack)) {
            player.func_71035_c(StringUtils.translate("chat.jetpack.hoverMode") + " " + "\u00a7c" + StringUtils.translate("chat.disabled"));
            itemStack.field_77990_d.func_74757_a("HoverModeActive", false);
        } else {
            player.func_71035_c(StringUtils.translate("chat.jetpack.hoverMode") + " " + "\u00a7a" + StringUtils.translate("chat.enabled"));
            itemStack.field_77990_d.func_74757_a("HoverModeActive", true);
        }
    }

    public double getHoverSpeed(ItemStack jetpack, EntityLivingBase user) {
        if (!MainConfig.invertHoverSneakingBehavior) {
            return user.func_70093_af() ? this.hoverModeActiveSpeed : this.hoverModeIdleSpeed;
        }
        return user.func_70093_af() ? this.hoverModeIdleSpeed : this.hoverModeActiveSpeed;
    }

    public void sendParticlePacket(EntityLivingBase user, int particle) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(0);
            data.writeInt(user.field_70157_k);
            data.writeInt(particle);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "SmpJet";
        packet.field_73629_c = bytes.toByteArray();
        packet.field_73628_b = bytes.size();
        PacketDispatcher.sendPacketToAllAround((double)user.field_70165_t, (double)user.field_70163_u, (double)user.field_70161_v, (double)96.0, (int)user.field_70170_p.field_73011_w.field_76574_g, (Packet)packet);
    }

    public boolean isArmored() {
        return false;
    }

    public int getTier() {
        return this.jetpackTier;
    }

    public int getParticleType(ItemStack jetpack) {
        return StackUtils.getNBT(jetpack).func_74762_e("JetParticleType");
    }

    public void setParticleType(ItemStack jetpack, int particle) {
        StackUtils.getNBT(jetpack).func_74768_a("JetParticleType", particle);
    }

    @Override
    public String getActivateMsg() {
        return StringUtils.translate("chat.jetpack.engine") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
    }

    @Override
    public String getDeactivateMsg() {
        return StringUtils.translate("chat.jetpack.engine") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }
}

