/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IReconfigurableSides;
import cofh.api.tileentity.ISidedBlockTexture;
import cofh.network.ITilePacketHandler;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import thermalexpansion.block.TileRSInventory;

public abstract class TileReconfigurableInventory
extends TileRSInventory
implements IReconfigurableFacing,
IReconfigurableSides,
ISidedBlockTexture,
ITilePacketHandler {
    protected boolean isActive = false;
    protected byte facing = (byte)3;
    public byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};

    public boolean onWrench(EntityPlayer player, int hitSide) {
        return this.rotateBlock();
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByteArray(this.sideCache);
        payload.addByte(this.facing);
        payload.addBool(this.isActive);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        payload.getByteArray(this.sideCache);
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.facing = payload.getByte();
            this.isActive = payload.getBool();
        } else {
            payload.getByte();
            payload.getBool();
        }
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean hasSide(int side) {
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] != side) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.isActive = nbt.func_74767_n("Active");
        this.facing = nbt.func_74771_c("Facing");
        this.sideCache = nbt.func_74770_j("SideCache");
        if (this.sideCache.length == 0) {
            this.sideCache = new byte[]{0, 0, 0, 0, 0, 0};
        }
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("Active", this.isActive);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74773_a("SideCache", this.sideCache);
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        if (this.allowYAxisFacing()) {
            byte[] tempCache = new byte[6];
            switch (this.facing) {
                case 0: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.INVERT_AROUND_X[i]];
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_X[i]];
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.INVERT_AROUND_Y[i]];
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[i]];
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.INVERT_AROUND_Z[i]];
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Z[i]];
                    }
                    break;
                }
            }
            this.sideCache = (byte[])tempCache.clone();
            this.facing = (byte)(this.facing + 1);
            this.facing = (byte)(this.facing % 6);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        if (this.isActive) {
            return false;
        }
        byte[] tempCache = new byte[6];
        for (int i = 0; i < 6; ++i) {
            tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[i]];
        }
        this.sideCache = (byte[])tempCache.clone();
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean decrSide(int side) {
        if (side == this.facing) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + (this.getNumConfig(side) - 1));
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean incrSide(int side) {
        if (side == this.facing) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + 1);
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean setSide(int side, int config) {
        if (side == this.facing || this.sideCache[side] == config || config >= this.getNumConfig(side)) {
            return false;
        }
        this.sideCache[side] = (byte)config;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean resetSides() {
        boolean update = false;
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] <= 0) continue;
            this.sideCache[i] = 0;
            update = true;
        }
        if (update) {
            this.sendUpdatePacket(Side.SERVER);
        }
        return update;
    }

    public abstract int getNumConfig(int var1);

    public abstract Icon getBlockTexture(int var1, int var2);
}

