/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.util.crafting.SawmillManager;

public class TileSawmill
extends TileMachineEnergized {
    public static final int TYPE = BlockMachine.Types.SAWMILL.ordinal();
    int outputTrackerPrimary;
    int outputTrackerSecondary;

    public static void initialize() {
        TileSawmill.sideData[TileSawmill.TYPE] = new TileMachineBase.SideConfig();
        TileSawmill.sideData[TileSawmill.TYPE].numGroup = 5;
        TileSawmill.sideData[TileSawmill.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2}, {3}, {1, 2, 3}};
        TileSawmill.sideData[TileSawmill.TYPE].allowInsertion = new boolean[]{false, true, false, false, false};
        TileSawmill.sideData[TileSawmill.TYPE].allowExtraction = new boolean[]{false, false, true, true, true};
        TileSawmill.sideData[TileSawmill.TYPE].sideTex = new int[]{0, 1, 2, 3, 4};
        TileSawmill.energyData[TileSawmill.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(20);
        TileSawmill.guiIds[TileSawmill.TYPE] = ThermalExpansion.proxy.registerGui("Sawmill", "machine", true);
        GameRegistry.registerTileEntity(TileSawmill.class, (String)"cofh.thermalexpansion.Sawmill");
    }

    public TileSawmill() {
        this.sideCache = new byte[]{3, 3, 2, 2, 2, 2};
        this.inventory = new ItemStack[5];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        SawmillManager.RecipeSawmill recipe = SawmillManager.getRecipe(this.inventory[0]);
        if (recipe == null || this.energyStorage.getEnergyStored() < recipe.getEnergy()) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipe.getInput().field_77994_a) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[3] != null) {
            if (!this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[3].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[1] == null || this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(primaryItem) && !this.inventory[2].func_77969_a(primaryItem)) {
            return false;
        }
        if (!this.inventory[1].func_77969_a(primaryItem)) {
            return this.inventory[2].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
        }
        if (!this.inventory[2].func_77969_a(primaryItem)) {
            return this.inventory[1].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
        }
        return this.inventory[1].field_77994_a + this.inventory[2].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d() * 2;
    }

    @Override
    protected boolean hasValidInput() {
        SawmillManager.RecipeSawmill recipe = SawmillManager.getRecipe(this.inventory[0]);
        return recipe == null ? false : recipe.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = SawmillManager.getRecipe(this.inventory[0]).getEnergy();
    }

    @Override
    protected void processFinish() {
        SawmillManager.RecipeSawmill recipe = SawmillManager.getRecipe(this.inventory[0]);
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = primaryItem;
        } else if (this.inventory[1].func_77969_a(primaryItem)) {
            int result = this.inventory[1].field_77994_a + primaryItem.field_77994_a;
            if (result <= primaryItem.func_77976_d()) {
                this.inventory[1].field_77994_a += primaryItem.field_77994_a;
            } else {
                int overflow = primaryItem.func_77976_d() - this.inventory[1].field_77994_a;
                this.inventory[1].field_77994_a += overflow;
                if (this.inventory[2] == null) {
                    this.inventory[2] = primaryItem;
                    this.inventory[2].field_77994_a = primaryItem.field_77994_a - overflow;
                } else {
                    this.inventory[2].field_77994_a += primaryItem.field_77994_a - overflow;
                }
            }
        } else if (this.inventory[2] == null) {
            this.inventory[2] = primaryItem;
        } else {
            this.inventory[2].field_77994_a += primaryItem.field_77994_a;
        }
        if (secondaryItem != null && this.field_70331_k.field_73012_v.nextInt(100) < recipe.getSecondaryOutputChance()) {
            if (this.inventory[3] == null) {
                this.inventory[3] = secondaryItem;
            } else {
                this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
            }
        }
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferProducts() {
        int side;
        int i;
        if (this.inventory[1] != null || this.inventory[2] != null) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (this.sideCache[side] != 2 && this.sideCache[side] != 4) continue;
                if (this.transferItem(1, 4, side)) {
                    if (!this.transferItem(2, 4, side)) {
                        this.transferItem(1, 4, side);
                    }
                    this.outputTrackerPrimary = side;
                    break;
                }
                if (!this.transferItem(2, 8, side)) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[3] == null) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (this.sideCache[side] != 3 && this.sideCache[side] != 4 || !this.transferItem(3, 4, side)) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    public boolean canAcceptItem(ItemStack stack, int slot, int side) {
        return slot == 0 ? SawmillManager.recipeExists(stack) : true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTrackerPrimary = nbt.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nbt.func_74762_e("Tracker2");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nbt.func_74768_a("Tracker2", this.outputTrackerSecondary);
    }
}

