/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.util.FluidHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;

public class TileWaterGen
extends TileMachineBase
implements IFluidHandler {
    public static final int TYPE = BlockMachine.Types.WATER_GEN.ordinal();
    public static int genRate = 800;
    public static int transferRate = genRate / 32;
    public static boolean passiveGen = true;
    public static FluidStack genStack;
    public static FluidStack genStackSmall;
    public static FluidStack genStackSnow;
    FluidTank tank = new FluidTank(4000);
    int adjacentSources = -1;
    FluidStack outputBuffer;
    int outputTrackerFluid;

    public static void initialize() {
        TileWaterGen.sideData[TileWaterGen.TYPE] = new TileMachineBase.SideConfig();
        TileWaterGen.sideData[TileWaterGen.TYPE].numGroup = 2;
        TileWaterGen.sideData[TileWaterGen.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileWaterGen.sideData[TileWaterGen.TYPE].allowInsertion = new boolean[]{false, false};
        TileWaterGen.sideData[TileWaterGen.TYPE].allowExtraction = new boolean[]{false, false};
        TileWaterGen.sideData[TileWaterGen.TYPE].sideTex = new int[]{0, 4};
        TileWaterGen.guiIds[TileWaterGen.TYPE] = ThermalExpansion.proxy.registerGui("WaterGen", "machine", "TEBase", null, true);
        GameRegistry.registerTileEntity(TileWaterGen.class, (String)"cofh.thermalexpansion.WaterGen");
    }

    public TileWaterGen() {
        this.sideCache = new byte[]{1, 1, 1, 1, 1, 1};
    }

    public int getType() {
        return TYPE;
    }

    protected void updateAdjacentSources() {
        this.adjacentSources = 0;
        int bId = this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        int bMeta = this.field_70331_k.func_72805_g(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        if (bMeta == 0 && (bId == Block.field_71943_B.field_71990_ca || bId == Block.field_71942_A.field_71990_ca)) {
            ++this.adjacentSources;
        }
        bId = this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        bMeta = this.field_70331_k.func_72805_g(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        if (bMeta == 0 && (bId == Block.field_71943_B.field_71990_ca || bId == Block.field_71942_A.field_71990_ca)) {
            ++this.adjacentSources;
        }
        bId = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        bMeta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        if (bMeta == 0 && (bId == Block.field_71943_B.field_71990_ca || bId == Block.field_71942_A.field_71990_ca)) {
            ++this.adjacentSources;
        }
        bId = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        bMeta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        if (bMeta == 0 && (bId == Block.field_71943_B.field_71990_ca || bId == Block.field_71942_A.field_71990_ca)) {
            ++this.adjacentSources;
        }
        if ((bId = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) == Block.field_72037_aS.field_71990_ca) {
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
            this.tank.fill(genStackSnow, true);
        }
    }

    protected boolean canStart() {
        return this.field_70331_k.func_72807_a(this.field_70329_l, this.field_70327_n) != BiomeGenBase.field_76778_j;
    }

    protected void transferFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 25));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (this.sideCache[side] != 1 || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)side, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        this.transferFluid();
        if (this.isActive) {
            if (this.timeCheck()) {
                if (this.adjacentSources >= 2) {
                    this.tank.fill(genStack, true);
                } else if (this.field_70331_k.func_72896_J() && this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                    this.tank.fill(genStack, true);
                } else if (passiveGen) {
                    this.tank.fill(genStackSmall, true);
                }
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            }
        } else if (this.redstoneControlOrDisable() && this.canStart()) {
            this.isActive = true;
        }
        if (this.adjacentSources < 0) {
            this.updateAdjacentSources();
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentSources();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.adjacentSources = j;
                return;
            }
            case 1: {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(new FluidStack(FluidRegistry.WATER, j));
                } else {
                    this.tank.getFluid().amount = j;
                }
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.adjacentSources);
        iCrafting.func_71112_a(container, 1, this.tank.getFluidAmount());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.adjacentSources = nbt.func_74762_e("Sources");
        this.outputTrackerFluid = nbt.func_74762_e("Tracker");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Sources", this.adjacentSources);
        nbt.func_74768_a("Tracker", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        if (resource == null || resource.getFluid() != FluidRegistry.WATER) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    static {
        genStackSmall = new FluidStack(FluidRegistry.WATER, 1);
        genStackSnow = new FluidStack(FluidRegistry.WATER, 125);
        int rate = ThermalExpansion.config.get("tweak", "WaterGen.Rate", genRate / 32);
        if (rate > 0 && rate <= 50) {
            genRate = rate * 32;
            transferRate = genRate / 32;
        } else {
            ThermalExpansion.log.log(Level.INFO, "'WaterGen.Rate' config value is out of acceptable range. Using default. (25)");
        }
        genStack = new FluidStack(FluidRegistry.WATER, genRate);
        ThermalExpansion.config.removeProperty("tweak", "WaterGen.PassiveGen");
    }
}

