/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tank;

import cofh.render.IconRegistry;
import cofh.util.CoreUtils;
import cofh.util.FluidHelper;
import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import cofh.util.UpgradeRecipe;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.tank.TileTank;
import thermalexpansion.block.tank.TileTankCreative;
import thermalexpansion.core.TEProps;

public class BlockTank
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 1.0f, 3.0f, 4.0f, 4.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack tankCreative;
    public static ItemStack tankBasic;
    public static ItemStack tankHardened;
    public static ItemStack tankReinforced;
    public static ItemStack tankResonant;

    public BlockTank(int id) {
        super(id, Material.field_76264_q);
        this.func_71905_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.func_71848_c(4.0f);
        this.func_71894_b(120.0f);
        this.func_71884_a(field_71974_j);
        this.func_71864_b("thermalexpansion.tank");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        if (metadata == Types.CREATIVE.ordinal()) {
            return new TileTankCreative(metadata);
        }
        return new TileTank(metadata);
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int hitSide, float hitX, float hitY, float hitZ) {
        if (super.func_71903_a(world, x, y, z, player, hitSide, hitX, hitY, hitZ)) {
            return true;
        }
        TileTank tile = (TileTank)world.func_72796_p(x, y, z);
        if (FluidHelper.fillHandlerWithContainer((World)tile.field_70331_k, (IFluidHandler)tile, (EntityPlayer)player)) {
            return true;
        }
        if (FluidHelper.fillContainerFromHandler((World)tile.field_70331_k, (IFluidHandler)tile, (EntityPlayer)player, (FluidStack)tile.getTankFluid())) {
            return true;
        }
        return ItemHelper.isPlayerHoldingFluidContainer((EntityPlayer)player);
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        FluidStack fluid;
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("Fluid") && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d.func_74775_l("Fluid"))) != null) {
            TileTank tile = (TileTank)world.func_72796_p(x, y, z);
            tile.tank.setFluid(fluid);
            tile.calcLastDisplay();
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        return HARDNESS[world.func_72805_g(x, y, z)];
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return RESISTANCE[world.func_72805_g(x, y, z)];
    }

    public int func_71857_b() {
        return TEProps.renderIdTank;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        for (int i = 0; i < Types.values().length; ++i) {
            IconRegistry.addIcon((String)("TankBottom" + 2 * i), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Bottom_Blue"), (IconRegister)ir);
            IconRegistry.addIcon((String)("TankBottom" + (2 * i + 1)), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Bottom_Orange"), (IconRegister)ir);
            IconRegistry.addIcon((String)("TankTop" + 2 * i), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Top_Blue"), (IconRegister)ir);
            IconRegistry.addIcon((String)("TankTop" + (2 * i + 1)), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Top_Orange"), (IconRegister)ir);
            IconRegistry.addIcon((String)("Tank" + 2 * i), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Side_Blue"), (IconRegister)ir);
            IconRegistry.addIcon((String)("Tank" + (2 * i + 1)), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Side_Orange"), (IconRegister)ir);
        }
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        FluidStack fluid;
        TileTank tile = (TileTank)world.func_72796_p(x, y, z);
        NBTTagCompound tag = null;
        if (tile != null && (fluid = tile.getTankFluid()) != null) {
            tag = new NBTTagCompound();
            tag.func_74766_a("Fluid", fluid.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)player)) {
            return false;
        }
        return super.canDismantle(player, world, x, y, z);
    }

    public boolean initialize() {
        TileTank.initialize();
        TileTankCreative.initialize();
        tankCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        tankBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        tankHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        tankReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        tankResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        GameRegistry.registerCustomItemStack((String)"tankCreative", (ItemStack)tankCreative);
        GameRegistry.registerCustomItemStack((String)"tankBasic", (ItemStack)tankBasic);
        GameRegistry.registerCustomItemStack((String)"tankHardened", (ItemStack)tankHardened);
        GameRegistry.registerCustomItemStack((String)"tankReinforced", (ItemStack)tankReinforced);
        GameRegistry.registerCustomItemStack((String)"tankResonant", (ItemStack)tankResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tankBasic, new Object[]{" G ", "GXG", " G ", Character.valueOf('G'), "glass", Character.valueOf('X'), "ingotCopper"}));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(tankHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), tankBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tankHardened, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), "ingotCopper", Character.valueOf('G'), "glass"}));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(tankReinforced, new Object[]{" G ", "GXG", " G ", Character.valueOf('G'), "glassHardened", Character.valueOf('X'), tankHardened}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(tankResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), tankReinforced}));
        }
        return true;
    }

    static {
        String category = "block.feature";
        BlockTank.enable[Types.CREATIVE.ordinal()] = ThermalExpansion.config.get(category, "Tank.Creative", true);
        BlockTank.enable[Types.BASIC.ordinal()] = ThermalExpansion.config.get(category, "Tank.Basic", true);
        BlockTank.enable[Types.HARDENED.ordinal()] = ThermalExpansion.config.get(category, "Tank.Hardened", true);
        BlockTank.enable[Types.REINFORCED.ordinal()] = ThermalExpansion.config.get(category, "Tank.Reinforced", true);
        BlockTank.enable[Types.RESONANT.ordinal()] = ThermalExpansion.config.get(category, "Tank.Resonant", true);
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

