/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiBase;
import cofh.gui.element.TabBase;
import cofh.render.RenderHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thermalexpansion.gui.container.ISetSchematic;
import thermalexpansion.network.TEPacketHandler;

public class TabSchematic
extends TabBase {
    public static ResourceLocation GRID_TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/elements/Slot_Grid_Schematic.png");
    public static ResourceLocation OUTPUT_TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/elements/Slot_Output_Schematic.png");
    ISetSchematic myTile;
    int headerColor = 14797103;
    int subheaderColor = 11186104;
    int textColor = 0;

    public TabSchematic(GuiBase gui, ISetSchematic tile) {
        super(gui);
        this.myTile = tile;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.backgroundColor = 0x2020B0;
    }

    public void draw() {
        this.drawBackground();
        this.drawTabIcon("schematic");
        if (!this.isFullyOpened()) {
            return;
        }
        elementFontRenderer.func_78261_a(StringHelper.localize((String)"info.thermalexpansion.schematic"), this.posX + 20, this.posY + 6, this.headerColor);
        elementFontRenderer.func_78276_b("", this.posX, this.posY, 0xFFFFFF);
        if (this.myTile.canWriteSchematic()) {
            this.gui.drawButton("IconAccept", this.posX + 77, this.posY + 60, 1, 0);
        } else {
            this.gui.drawButton("IconAcceptInactive", this.posX + 77, this.posY + 60, 1, 2);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.schematic"));
        }
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if ((x -= this.currentShiftX) < 8 || x >= 102 || (y -= this.currentShiftY) < 20 || y >= 84) {
            return false;
        }
        if (77 < x && x < 93 && 60 < y && y < 76) {
            if (this.myTile.canWriteSchematic()) {
                this.writeSchematic();
            }
        } else {
            this.gui.mouseClicked(1);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX + 8, this.posY + 20, 16, 20, 94, 64);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture((ResourceLocation)GRID_TEXTURE);
        this.gui.drawSizedTexturedModalRect(this.posX + 8, this.posY + 20, 0, 0, 64, 64, 64.0f, 64.0f);
        RenderHelper.bindTexture((ResourceLocation)OUTPUT_TEXTURE);
        this.gui.drawSizedTexturedModalRect(this.posX + 72, this.posY + 25, 0, 0, 26, 26, 26.0f, 26.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setFullyOpen() {
        super.setFullyOpen();
        for (int i = 0; i < this.myTile.getCraftingSlots().length; ++i) {
            this.myTile.getCraftingSlots()[i].field_75223_e = this.posX - this.gui.getGuiLeft() + 14 + 18 * (i % 3);
            this.myTile.getCraftingSlots()[i].field_75221_f = this.posY - this.gui.getGuiTop() + 26 + 18 * (i / 3);
        }
        this.myTile.getResultSlot().field_75223_e = this.posX - this.gui.getGuiLeft() + 77;
        this.myTile.getResultSlot().field_75221_f = this.posY - this.gui.getGuiTop() + 30;
    }

    public void toggleOpen() {
        if (this.open) {
            for (int i = 0; i < this.myTile.getCraftingSlots().length; ++i) {
                this.myTile.getCraftingSlots()[i].field_75223_e = -this.gui.getGuiLeft() - 16;
                this.myTile.getCraftingSlots()[i].field_75221_f = -this.gui.getGuiTop() - 16;
            }
            this.myTile.getResultSlot().field_75223_e = -this.gui.getGuiLeft() - 16;
            this.myTile.getResultSlot().field_75221_f = -this.gui.getGuiTop() - 16;
        }
        super.toggleOpen();
    }

    private boolean writeSchematic() {
        if (this.myTile.canWriteSchematic()) {
            TEPacketHandler.sendCreateSchematicPacketToServer();
            return true;
        }
        return false;
    }
}

