/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.network;

import cofh.api.tileentity.IRedstoneControl;
import cofh.network.IGeneralPacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.gui.container.ISetSchematic;

public class TEPacketHandler
implements IGeneralPacketHandler {
    public static TEPacketHandler instance = new TEPacketHandler();
    public static int packetID;

    public static void initialize() {
        packetID = PacketHandler.getAvailablePacketIdAndRegister((IGeneralPacketHandler)instance);
    }

    public void handlePacket(int id, Payload payload, EntityPlayer player) {
        try {
            byte type = payload.getByte();
            switch (PacketTypes.values()[type]) {
                case RS_POWER_UPDATE: {
                    int[] coords = payload.getCoords();
                    IRedstoneControl rs = (IRedstoneControl)player.field_70170_p.func_72796_p(coords[0], coords[1], coords[2]);
                    if (rs != null) {
                        rs.handlePowerUpdate(payload.getBool());
                    }
                    return;
                }
                case RS_CONFIG_UPDATE: {
                    int[] coords = payload.getCoords();
                    IRedstoneControl rs = (IRedstoneControl)player.field_70170_p.func_72796_p(coords[0], coords[1], coords[2]);
                    if (rs != null) {
                        rs.handleConfigUpdate(payload.getBool(), payload.getBool());
                    }
                    return;
                }
                case WRITE_SCHEM: {
                    if (player.field_71070_bA instanceof ISetSchematic) {
                        ((ISetSchematic)player.field_71070_bA).writeSchematic();
                    }
                    return;
                }
                case CONFIG_SYNC: {
                    ThermalExpansion.instance.handleConfigSync(payload);
                    return;
                }
            }
            ThermalExpansion.log.log(Level.SEVERE, "Unknown Packet! Internal: TEPH, ID: " + type);
        }
        catch (Exception e) {
            ThermalExpansion.log.log(Level.SEVERE, "Packet payload failure! Please check your config files!");
            e.printStackTrace();
        }
    }

    public static void sendRSPowerUpdatePacketToClients(IRedstoneControl rs, World world, int x, int y, int z) {
        PacketUtils.sendToPlayers((Packet)Payload.getPayload((int)packetID).addByte(PacketTypes.RS_POWER_UPDATE.ordinal()).addCoords(x, y, z).addBool(rs.isPowered()).getPacket(), (World)world, (double)x, (double)y, (double)z, (int)192);
    }

    public static void sendRSConfigUpdatePacketToServer(IRedstoneControl rs, int x, int y, int z) {
        PacketUtils.sendToServer((Packet)Payload.getPayload((int)packetID).addByte(PacketTypes.RS_CONFIG_UPDATE.ordinal()).addCoords(x, y, z).addBool(rs.getControlDisable()).addBool(rs.getControlSetting()).getPacket());
    }

    public static void sendCreateSchematicPacketToServer() {
        PacketDispatcher.sendPacketToServer((Packet)Payload.getPayload((int)packetID).addByte(PacketTypes.WRITE_SCHEM.ordinal()).getPacket());
    }

    public static void sendConfigSyncPacketToClient(EntityPlayer player) {
        PacketUtils.sendToPlayer((Packet)ThermalExpansion.instance.getConfigSync(packetID).getPacket(), (EntityPlayer)player);
    }

    public static enum PacketTypes {
        WRITE_SCHEM,
        RS_POWER_UPDATE,
        RS_CONFIG_UPDATE,
        CONFIG_SYNC;

    }
}

