/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.item.ConduitItem;

public class GridTickHandler
implements ITickHandler {
    public static LinkedHashSet<Grid> tickingGridsToAdd = new LinkedHashSet();
    public static LinkedHashSet<Grid> tickingGrids = new LinkedHashSet();
    public static LinkedHashSet<Grid> tickingGridsToRemove = new LinkedHashSet();
    public static LinkedHashSet<ConduitBase> tickConduit = new LinkedHashSet();
    public static LinkedHashSet<ConduitBase> tickConduitToAdd = new LinkedHashSet();
    public static GridTickHandler instance = new GridTickHandler();
    public static int maxItemsInDucts = 0;

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (!tickingGridsToAdd.isEmpty()) {
            tickingGrids.addAll(tickingGridsToAdd);
            tickingGridsToAdd.clear();
        }
        if (!tickingGrids.isEmpty()) {
            for (Grid theGrid : tickingGrids) {
                theGrid.doGridUpdate();
            }
            tickingGrids.removeAll(tickingGridsToRemove);
            tickingGridsToRemove.clear();
            if (maxItemsInDucts > 0) {
                for (Grid theGrid : tickingGrids) {
                    ConduitItem theCond;
                    if (!theGrid.isItemGrid()) continue;
                    for (ConduitBase theConduit : theGrid.conduitSet) {
                        theCond = (ConduitItem)theConduit;
                        if (theCond.getStuffedSize() <= maxItemsInDucts) continue;
                        theCond.truncateStuffedItems(maxItemsInDucts);
                    }
                    for (ConduitBase theConduit : theGrid.nodeSet) {
                        theCond = (ConduitItem)theConduit;
                        if (theCond.getStuffedSize() <= maxItemsInDucts) continue;
                        theCond.truncateStuffedItems(maxItemsInDucts);
                    }
                }
            }
        }
        if (tickConduitToAdd.size() > 0) {
            tickConduit.addAll(tickConduitToAdd);
            tickConduitToAdd.clear();
        }
        if (!tickConduit.isEmpty()) {
            for (ConduitBase aCond : tickConduit) {
                aCond.calculateGrid();
            }
            tickConduit.clear();
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "ThermalExpansion Grid Tick Handler";
    }

    public static class ItemClientTickHandler
    implements ITickHandler {
        public static ItemClientTickHandler instance = new ItemClientTickHandler();
        public static LinkedHashSet<ConduitItem> tickConduit = new LinkedHashSet();
        public static LinkedHashSet<ConduitItem> tickConduitToRemove = new LinkedHashSet();
        public static LinkedHashSet<ConduitItem> tickConduitToAdd = new LinkedHashSet();

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (!tickConduitToAdd.isEmpty()) {
                tickConduit.addAll(tickConduitToAdd);
                tickConduitToAdd.clear();
            }
            if (!tickConduit.isEmpty()) {
                for (ConduitItem aCond : tickConduit) {
                    aCond.tickItemsClient();
                }
                tickConduit.removeAll(tickConduitToRemove);
                tickConduitToRemove.clear();
            }
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "ThermalExpansion Item Tick Handler";
        }
    }
}

