/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.lamp.TileLamp;
import thermalexpansion.core.TEProps;

public class RenderLamp
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderLamp instance = new RenderLamp();
    static final int NUM_RENDERS = 1;
    static Icon[] textureCenter = new Icon[2];
    static Icon[] textureFrame = new Icon[1];
    static CCModel[] modelCenter = new CCModel[1];
    static CCModel[] modelFrame = new CCModel[1];

    public static void initialize() {
        RenderLamp.textureCenter[0] = IconRegistry.getIcon((String)"FluidGlowstone");
        RenderLamp.textureCenter[1] = IconRegistry.getIcon((String)"LampEffect");
        for (int i = 0; i < 1; ++i) {
            RenderLamp.textureFrame[i] = IconRegistry.getIcon((String)"Lamp", (int)i);
        }
    }

    private static void generateModels() {
        double d1 = 9.765625E-4;
        double d2 = 2.0 * d1;
        RenderLamp.modelFrame[0] = CCModel.quadModel((int)24).generateBlock(0, d1, d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1).computeNormals().computeLighting(LightModel.standardLightModel);
        RenderLamp.modelCenter[0] = CCModel.quadModel((int)24).generateBlock(0, d2, d2, d2, 1.0 - d2, 1.0 - d2, 1.0 - d2).computeNormals();
    }

    public void renderCenter(int metadata, boolean modified, double x, double y, double z) {
        if (modified) {
            modelCenter[metadata].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCenter[1]));
        } else {
            modelCenter[metadata].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCenter[0]));
        }
    }

    public void renderFrame(int metadata, double x, double y, double z) {
        modelFrame[metadata].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[metadata]));
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileLamp)) {
            return false;
        }
        TileLamp theTile = (TileLamp)tile;
        int bMeta = world.func_72805_g(x, y, z);
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        CCRenderState.setColour((int)theTile.getColorMultiplier());
        this.renderCenter(bMeta, theTile.modified, x, y, z);
        CCRenderState.setColour((int)-1);
        this.renderFrame(bMeta, x, y, z);
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdLamp;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            offset = 0.0;
        }
        int metadata = item.func_77960_j();
        boolean modified = false;
        int color = -1;
        if (item.func_77942_o()) {
            modified = item.func_77978_p().func_74767_n("modified");
            color = item.func_77978_p().func_74762_e("color");
            color = (color << 8) + 255;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        CCRenderState.setColour((int)color);
        instance.renderCenter(metadata, modified, offset, offset, offset);
        CCRenderState.draw();
        CCRenderState.startDrawing((int)7);
        CCRenderState.setColour((int)-1);
        instance.renderFrame(metadata, offset, offset, offset);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderHelper.setItemTextureSheet();
        GL11.glDisable((int)3042);
    }

    static {
        TEProps.renderIdLamp = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        MinecraftForgeClient.registerItemRenderer((int)TEBlocks.blockLamp.field_71990_ca, (IItemRenderer)instance);
        RenderLamp.generateModels();
    }
}

