/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.tank.BlockTank;
import thermalexpansion.block.tank.TileTank;
import thermalexpansion.core.TEProps;

public class RenderTank
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderTank instance = new RenderTank();
    static Icon[] textureTop = new Icon[BlockTank.Types.values().length * 2];
    static Icon[] textureBottom = new Icon[BlockTank.Types.values().length * 2];
    static Icon[] textureSides = new Icon[BlockTank.Types.values().length * 2];
    static CCModel[] modelFluid = new CCModel[128];
    static CCModel modelFrame = CCModel.quadModel((int)48);

    public static void initialize() {
        for (int i = 0; i < textureSides.length; ++i) {
            RenderTank.textureTop[i] = IconRegistry.getIcon((String)"TankTop", (int)i);
            RenderTank.textureBottom[i] = IconRegistry.getIcon((String)"TankBottom", (int)i);
            RenderTank.textureSides[i] = IconRegistry.getIcon((String)"Tank", (int)i);
        }
    }

    private static void generateFluidModels() {
        double minXZ = 0.1865234375;
        double maxXZ = 0.8134765625;
        double minY = 0.0615234375;
        double maxY = 1.0 - minY;
        double increment = (maxY - minY) / 128.0;
        for (int i = 1; i < 129; ++i) {
            double yLevel = minY + increment * (double)i;
            RenderTank.modelFluid[i - 1] = CCModel.quadModel((int)24).generateBlock(0, minXZ, minY, minXZ, maxXZ, yLevel, maxXZ).computeNormals();
        }
    }

    public void renderFrame(int metadata, int mode, double x, double y, double z) {
        int i;
        Translation trans = RenderUtils.getRenderVector((double)x, (double)y, (double)z).translation();
        modelFrame.render(0, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureBottom[2 * metadata + mode]), null);
        modelFrame.render(24, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureTop[2 * metadata + mode]), null);
        modelFrame.render(4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureTop[2 * metadata]), null);
        modelFrame.render(28, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureBottom[2 * metadata]), null);
        for (i = 8; i < 24; i += 4) {
            modelFrame.render(i, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureSides[2 * metadata + mode]), null);
        }
        for (i = 32; i < 48; i += 4) {
            modelFrame.render(i, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureSides[2 * metadata + mode]), null);
        }
    }

    public void renderFluid(int metadata, FluidStack stack, double x, double y, double z) {
        if (stack == null || stack.amount <= 0) {
            return;
        }
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.startDrawing((int)7);
        Fluid fluid = stack.getFluid();
        RenderUtils.setFluidRenderColor((FluidStack)stack);
        Icon fluidTex = RenderHelper.getFluidTexture((FluidStack)stack);
        int level = 127;
        if (fluid.isGaseous(stack)) {
            CCRenderState.setColour((int)(RenderUtils.getFluidRenderColor((FluidStack)stack) << 8 | 32 + 192 * stack.amount / TileTank.CAPACITY[metadata]));
        } else {
            level = Math.min(127, stack.amount * 128 / TileTank.CAPACITY[metadata]);
        }
        modelFluid[level].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)fluidTex));
        CCRenderState.draw();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileTank)) {
            return false;
        }
        TileTank theTile = (TileTank)tile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (BlockCoFHBase.renderPass == 0) {
            this.renderFrame(theTile.type, theTile.mode, x, y, z);
        } else {
            CCRenderState.draw();
            this.renderFluid(theTile.func_70322_n(), theTile.getTankFluid(), x, y, z);
            CCRenderState.startDrawing((int)7);
        }
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdTank;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            offset = 0.0;
        }
        FluidStack fluid = null;
        if (item.field_77990_d != null) {
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)item.field_77990_d.func_74775_l("Fluid"));
        }
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        instance.renderFrame(item.func_77960_j(), 0, offset, offset, offset);
        CCRenderState.draw();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        instance.renderFluid(item.func_77960_j(), fluid, offset, offset, offset);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        CCRenderState.useNormals((boolean)false);
    }

    static {
        TEProps.renderIdTank = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        MinecraftForgeClient.registerItemRenderer((int)TEBlocks.blockTank.field_71990_ca, (IItemRenderer)instance);
        RenderTank.generateFluidModels();
        Cuboid6 box = new Cuboid6(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        double inset = 0.0625;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, box);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            RenderTank.modelFrame.verts[i].vec.add(RenderTank.modelFrame.normals[i].copy().multiply(inset));
        }
        modelFrame.computeLighting(LightModel.standardLightModel);
    }
}

