/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import codechicken.lib.vec.Rectangle4i;
import cofh.gui.GuiBase;
import cofh.gui.TabTracker;
import cofh.gui.element.ElementBase;
import cofh.render.RenderHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class TabBase
extends ElementBase {
    public static int tabExpandSpeed = 8;
    public boolean open;
    public int side = 1;
    public int backgroundColor = 0xFFFFFF;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;
    Rectangle4i bounds = new Rectangle4i(this.posX, this.posY, this.currentWidth, this.currentHeight);
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("cofh:textures/gui/elements/Tab_Left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("cofh:textures/gui/elements/Tab_Right.png");

    public TabBase(GuiBase gui) {
        super(gui, 0, 0);
        this.texture = DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase(GuiBase gui, int side) {
        super(gui, 0, 0);
        this.side = side;
        this.texture = side == 0 ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
    }

    @Override
    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += tabExpandSpeed;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= tabExpandSpeed;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += tabExpandSpeed;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= tabExpandSpeed;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.side == 0 ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight;
    }

    protected void drawBackground() {
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        if (this.side == 0) {
            this.gui.func_73729_b(this.posX - this.currentWidth, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
            this.gui.func_73729_b(this.posX - this.currentWidth + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.gui.func_73729_b(this.posX - this.currentWidth, this.posY, 0, 0, 4, 4);
            this.gui.func_73729_b(this.posX - this.currentWidth + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        } else {
            this.gui.func_73729_b(this.posX, this.posY, 0, 256 - this.currentHeight, 4, this.currentHeight);
            this.gui.func_73729_b(this.posX + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.gui.func_73729_b(this.posX, this.posY, 0, 0, 4, 4);
            this.gui.func_73729_b(this.posX + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawTabIcon(String iconName) {
        int offsetX = 2;
        if (this.side == 0) {
            offsetX = 4 - this.currentWidth;
        }
        this.gui.drawIcon(iconName, this.posX + offsetX, this.posY + 3, 1);
    }

    public boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(null);
            } else {
                TabTracker.setOpenedRightTab(null);
            }
        } else {
            this.open = true;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(this.getClass());
            } else {
                TabTracker.setOpenedRightTab(this.getClass());
            }
        }
    }

    public Rectangle4i getBounds() {
        this.bounds.x = this.side == 0 ? this.posX - this.currentWidth : this.posX;
        this.bounds.y = this.posY;
        this.bounds.w = this.currentWidth;
        this.bounds.h = this.currentHeight;
        return this.bounds;
    }
}

