/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public final class LiquidSetLuminosityAction
implements IUndoableAction {
    private final Fluid fluid;
    private final int newValue;
    private final int oldValue;

    public LiquidSetLuminosityAction(Fluid fluid, int newValue) {
        this.fluid = fluid;
        this.newValue = newValue;
        this.oldValue = fluid.getLuminosity();
    }

    @Override
    public void apply() {
        this.fluid.setLuminosity(this.newValue);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.fluid.setLuminosity(this.oldValue);
    }

    @Override
    public String describe() {
        return "Setting " + this.fluid.getLocalizedName() + " luminosity to " + this.newValue;
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.fluid.getLocalizedName() + " luminosity to " + this.oldValue;
    }
}

