/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.values;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.MineTweakerRegistry;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerValue;

public class FluidGroupValue
extends TweakerValue {
    private final String name;

    public FluidGroupValue() {
        this.name = null;
    }

    public FluidGroupValue(String name) {
        this.name = name;
    }

    @Override
    public TweakerValue mul(TweakerValue value) throws TweakerExecuteException {
        Fluid fluid = FluidRegistry.getFluid((String)this.name);
        if (fluid == null) {
            return super.mul(value);
        }
        return new TweakerLiquid(fluid).mul(value);
    }

    @Override
    public TweakerLiquid asFluid() {
        Fluid fluid = FluidRegistry.getFluid((String)this.name);
        if (fluid == null) {
            return null;
        }
        return new TweakerLiquid(fluid);
    }

    @Override
    public TweakerLiquidStack asFluidStack() {
        Fluid fluid = FluidRegistry.getFluid((String)this.name);
        if (fluid == null) {
            return null;
        }
        return new TweakerLiquidStack(new FluidStack(fluid, 1));
    }

    @Override
    public TweakerValue index(String index) throws TweakerExecuteException {
        String newName;
        String string = newName = this.name == null ? index : this.name + '.' + index;
        if (MineTweakerRegistry.INSTANCE.isFluidPrefix(newName)) {
            return new FluidGroupValue(newName);
        }
        if (FluidRegistry.getFluid((String)newName) != null) {
            return new TweakerLiquid(FluidRegistry.getFluid((String)newName));
        }
        if (FluidRegistry.getFluid((String)this.name) != null) {
            return new TweakerLiquid(FluidRegistry.getFluid((String)this.name)).index(index);
        }
        throw new TweakerExecuteException("no such fluid: " + newName);
    }

    @Override
    public void indexSet(TweakerValue index, TweakerValue value) throws TweakerExecuteException {
        Fluid fluid = FluidRegistry.getFluid((String)this.name);
        if (fluid == null) {
            super.indexSet(index, value);
        } else {
            new TweakerLiquid(fluid).indexSet(index, value);
        }
    }

    @Override
    public String toString() {
        return this.name == null ? "fluids" : this.name;
    }
}

