/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import java.util.Random;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class FertilizerAddFertilizableAction
implements IUndoableAction {
    private final TweakerItem block;
    private final TweakerItem plant;
    private final FertilizerType type;
    private final IFactoryFertilizable old;

    public FertilizerAddFertilizableAction(TweakerItem block, TweakerItem plant, FertilizerType type) {
        this.block = block;
        this.plant = plant;
        this.type = type;
        this.old = MFRHacks.fertilizables == null ? null : MFRHacks.fertilizables.get(block.getItemId());
    }

    @Override
    public void apply() {
        FactoryRegistry.registerFertilizable((IFactoryFertilizable)new SimpleFertilizable(this.block, this.plant, this.type));
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.fertilizables != null;
    }

    @Override
    public void undo() {
        if (this.old == null) {
            MFRHacks.fertilizables.remove(this.block.getItemId());
        } else {
            FactoryRegistry.registerFertilizable((IFactoryFertilizable)this.old);
        }
    }

    @Override
    public String describe() {
        return "Making " + this.block.getDisplayName() + " fertilizable";
    }

    @Override
    public String describeUndo() {
        if (this.old == null) {
            return "Removing fertilizable " + this.block.getDisplayName();
        }
        return "Restoring fertilizable " + this.block.getDisplayName();
    }

    private static class SimpleFertilizable
    implements IFactoryFertilizable {
        private final TweakerItem block;
        private final TweakerItem plant;
        private final FertilizerType type;

        public SimpleFertilizable(TweakerItem block, TweakerItem plant, FertilizerType type) {
            this.block = block;
            this.plant = plant;
            this.type = type;
        }

        public int getFertilizableBlockId() {
            return this.block.getItemId();
        }

        public boolean canFertilizeBlock(abw world, int x, int y, int z, FertilizerType fertilizerType) {
            return !(this.type != null && this.type != fertilizerType || world.a(x, y, z) != this.block.getItemId() || this.block.isSubItem() && this.block.getItemSubId() != Short.MAX_VALUE && this.block.getItemSubId() != world.h(x, y, z));
        }

        public boolean fertilize(abw world, Random rand, int x, int y, int z, FertilizerType fertilizerType) {
            if (this.plant == null) {
                return xl.applyBonemeal((ye)new ye(yc.aY.cv, 1, 15), (abw)world, (int)x, (int)y, (int)z, null);
            }
            world.f(x, y, z, this.plant.getItemId(), this.plant.getItemSubId(), 0);
            return true;
        }
    }
}

