/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class HarvesterAddHarvestableAction
implements IUndoableAction {
    private final TweakerItem item;
    private final IFactoryHarvestable harvestable;
    private final IFactoryHarvestable old;

    public HarvesterAddHarvestableAction(TweakerItem item, IFactoryHarvestable harvestable) {
        this.item = item;
        this.harvestable = harvestable;
        this.old = MFRHacks.harvestables == null ? null : MFRHacks.harvestables.get(item.getItemId());
    }

    @Override
    public void apply() {
        FactoryRegistry.registerHarvestable((IFactoryHarvestable)this.harvestable);
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.harvestables != null;
    }

    @Override
    public void undo() {
        if (this.old == null) {
            MFRHacks.harvestables.remove(this.item.getItemId());
        } else {
            FactoryRegistry.registerHarvestable((IFactoryHarvestable)this.old);
        }
    }

    @Override
    public String describe() {
        return "Adding " + this.harvestable.getHarvestType() + " harvestable " + this.item.getDisplayName();
    }

    @Override
    public String describeUndo() {
        if (this.old == null) {
            return "Removing harvestable " + this.item.getDisplayName();
        }
        return "Restoring harvestable " + this.item.getDisplayName();
    }
}

