/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class SafariNetRemoveBlacklistAction
implements IUndoableAction {
    private final Class<?> entityClass;
    private final boolean existed;

    public SafariNetRemoveBlacklistAction(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.existed = MFRHacks.safariNetBlacklist.contains(entityClass);
    }

    @Override
    public void apply() {
        if (this.existed) {
            MFRHacks.safariNetBlacklist.remove(this.entityClass);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.existed) {
            MFRHacks.safariNetBlacklist.add(this.entityClass);
        }
    }

    @Override
    public String describe() {
        return "Removing safari net blacklist " + this.entityClass.getCanonicalName();
    }

    @Override
    public String describeUndo() {
        return "Restoring safari net blacklist " + this.entityClass.getCanonicalName();
    }
}

