/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupMember;

public class FoodGroup {
    public String identifier;
    public String name;
    public int priority;
    private List<FoodGroupMember> foods = new ArrayList<FoodGroupMember>();

    public FoodGroup() {
        this(null, null, 0);
    }

    public FoodGroup(String identifier, String name) {
        this(identifier, name, 0);
    }

    public FoodGroup(String identifier, String name, int priority) {
        this.identifier = identifier;
        this.name = name;
        this.priority = priority;
    }

    public void init() {
        for (FoodGroupMember foodMember : this.foods) {
            foodMember.initMatchingItemsList();
        }
    }

    public boolean isFoodIncluded(ItemStack food) {
        for (FoodGroupMember foodMember : this.foods) {
            if (!foodMember.isFoodIncluded(food)) continue;
            return true;
        }
        return false;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public void addFood(String oredictName) {
        this.addFood(oredictName, false);
    }

    public void addFood(String oredictName, boolean baseItemForRecipes) {
        this.addFood(new FoodGroupMember(oredictName, baseItemForRecipes));
    }

    public void addFood(ItemStack itemStack, boolean exactMetadata) {
        this.addFood(itemStack, false);
    }

    public void addFood(ItemStack itemStack, boolean exactMetadata, boolean baseItemForRecipes) {
        this.addFood(new FoodGroupMember(itemStack, exactMetadata, baseItemForRecipes));
    }

    public void addFood(FoodGroupMember foodMember) {
        this.foods.add(foodMember);
    }

    public void pack(DataOutputStream data) throws IOException {
        data.writeUTF(this.identifier);
        data.writeUTF(this.name);
        data.writeShort(this.priority);
        data.writeShort(this.foods.size());
        for (FoodGroupMember foodMember : this.foods) {
            foodMember.pack(data);
        }
    }

    public void unpack(DataInputStream data, EntityPlayer player) throws IOException {
        this.identifier = data.readUTF();
        this.name = data.readUTF();
        this.priority = data.readShort();
        int size = data.readShort();
        for (int i = 0; i < size; ++i) {
            FoodGroupMember foodMember = new FoodGroupMember();
            foodMember.unpack(data, player);
            this.addFood(foodMember);
        }
    }
}

