/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.common;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tconstruct.common.TContent;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.Smeltery;
import tconstruct.util.RecipeRemover;
import tsteelworks.common.TSContent;
import tsteelworks.lib.ConfigCore;
import tsteelworks.lib.crafting.AdvancedSmelting;

public class TSRecipes {
    static String[] patBlock = new String[]{"###", "###", "###"};
    static String[] patSmallBlock = new String[]{"##", "##"};
    static String[] patSlab = new String[]{"###"};
    static String[] patHollow = new String[]{"###", "# #", "###"};
    static String[] patSurround = new String[]{"###", "#m#", "###"};
    static String[] patHead = new String[]{"###", "# #"};
    static String[] patChest = new String[]{"# #", "###", "###"};
    static String[] patLegs = new String[]{"###", "# #", "# #"};
    static String[] patBoots = new String[]{"# #", "# #"};
    public static final int ingotLiquidValue = 144;
    public static final int oreLiquidValue = 144 * ConfigCore.ingotsPerOre;
    public static final int blockLiquidValue = 1296;
    public static final int chunkLiquidValue = 72;
    public static final int nuggetLiquidValue = 16;

    public static void setupCrafting() {
        TSRecipes.addOreDictionarySmelting();
        TSRecipes.createRecipes();
        TSRecipes.createAlloys();
    }

    public static void addOreDictionarySmelting() {
        List<FluidType> exceptions = Arrays.asList(FluidType.Water, FluidType.Stone, FluidType.Ender, FluidType.Glass, FluidType.Slime, FluidType.Obsidian);
        for (FluidType ft : FluidType.values()) {
            if (exceptions.contains(ft)) continue;
            int tempMod = TSRecipes.getFluidTempMod(ft);
            AdvancedSmelting.addDictionaryMelting("nugget" + ft.toString(), ft, tempMod, 16);
            AdvancedSmelting.addDictionaryMelting("ingot" + ft.toString(), ft, tempMod, 144);
            AdvancedSmelting.addDictionaryMelting("dust" + ft.toString(), ft, tempMod, 144);
            AdvancedSmelting.addDictionaryMelting("crystalline" + ft.toString(), ft, tempMod, 144);
            AdvancedSmelting.addDictionaryMelting("ore" + ft.toString(), ft, tempMod, oreLiquidValue);
            AdvancedSmelting.addDictionaryMelting("oreNether" + ft.toString(), ft, tempMod, oreLiquidValue * 2);
            AdvancedSmelting.addDictionaryMelting("block" + ft.toString(), ft, tempMod, 1296);
        }
        FluidType ft = FluidType.Obsidian;
        int tempMod = TSRecipes.getFluidTempMod(ft);
        AdvancedSmelting.addDictionaryMelting("nugget" + ft.toString(), ft, tempMod, 16);
        AdvancedSmelting.addDictionaryMelting("ingot" + ft.toString(), ft, tempMod, 144);
        AdvancedSmelting.addDictionaryMelting("dust" + ft.toString(), ft, tempMod, 36);
        AdvancedSmelting.addDictionaryMelting("crystalline" + ft.toString(), ft, tempMod, 144);
        AdvancedSmelting.addDictionaryMelting("ore" + ft.toString(), ft, tempMod, oreLiquidValue);
        AdvancedSmelting.addDictionaryMelting("oreNether" + ft.toString(), ft, tempMod, oreLiquidValue * 2);
        AdvancedSmelting.addDictionaryMelting("block" + ft.toString(), ft, tempMod, 1296);
        for (int i = 1; i <= 8; ++i) {
            AdvancedSmelting.addDictionaryMelting("compressedCobblestone" + i + "x", FluidType.Stone, TSRecipes.getFluidTempMod(FluidType.Stone), 8 * (9 ^ i));
        }
        AdvancedSmelting.addDictionaryMelting("compressedSand1x", FluidType.Glass, TSRecipes.getFluidTempMod(FluidType.Glass), 9000);
    }

    public static void createAlloys() {
        Smeltery.addAlloyMixing((FluidStack)new FluidStack(TSContent.liquidCementFluid, 1), (FluidStack[])new FluidStack[]{new FluidStack(TContent.moltenStoneFluid, 1), new FluidStack(TSContent.moltenLimestoneFluid, 1)});
    }

    public static void createRecipes() {
        TSRecipes.craftManual();
        TSRecipes.craftMachines();
        TSRecipes.craftScorchedStone();
        TSRecipes.craftLimestone();
        TSRecipes.craftStone();
        TSRecipes.craftStorageBlocks();
        TSRecipes.craftSteel();
        TSRecipes.craftPigIron();
        TSRecipes.craftObsidian();
        TSRecipes.craftGlass();
        TSRecipes.craftWater();
        if (ConfigCore.hardcorePiston) {
            TSRecipes.changePiston();
        }
        if (ConfigCore.hardcoreFlintAndSteel) {
            TSRecipes.changeFlintAndSteel();
        }
        if (ConfigCore.hardcoreAnvil) {
            TSRecipes.changeAnvil();
        }
        AdvancedSmelting.addMelting(Block.field_72076_bV, 0, TSRecipes.getFluidTempMod(FluidType.Emerald), new FluidStack(TContent.moltenEmeraldFluid, 2880));
        AdvancedSmelting.addMelting(TContent.glueBlock, 0, TSRecipes.getFluidTempMod(FluidType.Glue), new FluidStack(TContent.glueFluid, 1296));
        ItemStack netherQuartz = new ItemStack(Item.field_94583_ca, 1);
        AdvancedSmelting.registerMixComboForSolidOutput(netherQuartz, FluidType.Glass, "dustGunpowder", "oreberryEssence", "blockGraveyardDirt");
    }

    public static void craftManual() {
        LiquidCasting tableCasting = TConstructRegistry.instance.getTableCasting();
        ItemStack manual1 = new ItemStack(TSContent.bookManual, 1, 0);
        FluidStack fluidStoneMinor = new FluidStack(TContent.moltenStoneFluid, 8);
        tableCasting.addCastingRecipe(manual1, fluidStoneMinor, new ItemStack(TContent.manualBook, 1), true, 50);
        tableCasting.addCastingRecipe(manual1, fluidStoneMinor, new ItemStack(Item.field_77760_aL, 1), true, 50);
    }

    public static void craftMachines() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TSContent.machine, 1, 0), new Object[]{"aca", "#d#", "#r#", Character.valueOf('#'), "ingotBronze", Character.valueOf('a'), "ingotAluminumBrass", Character.valueOf('c'), "ingotSteel", Character.valueOf('r'), new ItemStack(Item.field_77767_aC), Character.valueOf('d'), new ItemStack((Block)Block.field_71963_Z)}));
    }

    public static void craftScorchedStone() {
        LiquidCasting basinCasting = TConstructRegistry.instance.getBasinCasting();
        LiquidCasting tableCasting = TConstructRegistry.instance.getTableCasting();
        Detailing chiseling = TConstructRegistry.getChiselDetailing();
        ItemStack itemScorchedBrick = new ItemStack(TSContent.materialsTS, 1, 0);
        ItemStack blockScorchedBrick = new ItemStack(TSContent.highoven, 1, 2);
        FluidStack fluidStoneMinor = new FluidStack(TContent.moltenStoneFluid, 8);
        FluidStack fluidStoneChunk = new FluidStack(TContent.moltenStoneFluid, 32);
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.highoven, 1, 0), (Object[])new Object[]{patHollow, Character.valueOf('#'), itemScorchedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.highoven, 1, 1), (Object[])new Object[]{"b b", "b b", "b b", Character.valueOf('b'), itemScorchedBrick});
        GameRegistry.addRecipe((ItemStack)blockScorchedBrick, (Object[])new Object[]{patSmallBlock, Character.valueOf('#'), itemScorchedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.highoven, 1, 12), (Object[])new Object[]{"bbb", "   ", "bbb", Character.valueOf('b'), itemScorchedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.highoven, 1, 13), (Object[])new Object[]{patSurround, Character.valueOf('#'), itemScorchedBrick, Character.valueOf('m'), new ItemStack(Item.field_77756_aW, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 0), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 2)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 1), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 2), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 3), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 6)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 4), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 8)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 5), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 9)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 6), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 10)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.scorchedSlab, 6, 7), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.highoven, 1, 11)});
        String[] oxidizers = new String[]{"fuelCoal", "coal", "dustCoal"};
        String[] purifiers = new String[]{"blockSand", "Sandblock", "sand"};
        for (String o : oxidizers) {
            for (String p : purifiers) {
                AdvancedSmelting.registerMixComboForSolidOutput(itemScorchedBrick, FluidType.Stone, o, null, p);
            }
        }
        tableCasting.addCastingRecipe(itemScorchedBrick, fluidStoneMinor, new ItemStack(Item.field_77772_aH), true, 50);
        basinCasting.addCastingRecipe(blockScorchedBrick, fluidStoneChunk, new ItemStack(Block.field_72081_al), true, 100);
        chiseling.addDetailing((Object)TSContent.highoven, 4, (Object)TSContent.highoven, 6, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.highoven, 6, (Object)TSContent.highoven, 11, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.highoven, 11, (Object)TSContent.highoven, 2, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.highoven, 2, (Object)TSContent.highoven, 8, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.highoven, 8, (Object)TSContent.highoven, 9, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.highoven, 9, (Object)TSContent.highoven, 10, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.highoven, 10, (Object)TSContent.highoven, 4, TContent.chisel);
    }

    public static void craftLimestone() {
        Detailing chiseling = TConstructRegistry.getChiselDetailing();
        Fluid fluid = TSContent.moltenLimestoneFluid;
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneBlock, 1, 2), (Object[])new Object[]{patSmallBlock, Character.valueOf('#'), new ItemStack(TSContent.materialsTS, 1, 1)});
        FurnaceRecipes.func_77602_a().addSmelting(TSContent.limestoneBlock.field_71990_ca, 1, new ItemStack(TSContent.limestoneBlock, 0, 1), 2.0f);
        FurnaceRecipes.func_77602_a().addSmelting(TSContent.limestoneBlock.field_71990_ca, 0, new ItemStack(TSContent.materialsTS, 1, 1), 2.0f);
        Smeltery.addMelting((Block)TSContent.limestoneBlock, (int)0, (int)0, (FluidStack)new FluidStack(fluid, 8));
        Smeltery.addMelting((Block)TSContent.limestoneBlock, (int)1, (int)0, (FluidStack)new FluidStack(fluid, 8));
        AdvancedSmelting.addMelting(TSContent.limestoneBlock, 0, 825, new FluidStack(fluid, 8));
        AdvancedSmelting.addMelting(TSContent.limestoneBlock, 1, 825, new FluidStack(fluid, 8));
        Smeltery.addMelting((ItemStack)new ItemStack(TSContent.materialsTS, 1, 1), (int)TSContent.limestoneBlock.field_71990_ca, (int)1, (int)0, (FluidStack)new FluidStack(fluid, 144));
        AdvancedSmelting.addMelting(new ItemStack(TSContent.materialsTS, 1, 1), TSContent.limestoneBlock.field_71990_ca, 1, 825, new FluidStack(fluid, 144));
        AdvancedSmelting.registerMixComboForSolidOutput(new ItemStack(TSContent.materialsTS, 1, 1), FluidType.Stone, "dyeLime", null, "blockSand");
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 0), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 1), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 2), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 2)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 3), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 4), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 5), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 6)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 6), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 7)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.limestoneSlab, 6, 7), (Object[])new Object[]{patSlab, Character.valueOf('#'), new ItemStack(TSContent.limestoneBlock, 1, 8)});
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 2, (Object)TSContent.limestoneBlock, 3, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 3, (Object)TSContent.limestoneBlock, 4, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 4, (Object)TSContent.limestoneBlock, 5, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 5, (Object)TSContent.limestoneBlock, 6, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 6, (Object)TSContent.limestoneBlock, 7, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 7, (Object)TSContent.limestoneBlock, 8, TContent.chisel);
        chiseling.addDetailing((Object)TSContent.limestoneBlock, 8, (Object)TSContent.limestoneBlock, 3, TContent.chisel);
    }

    public static void craftStone() {
        FluidType ft = FluidType.Stone;
        Fluid fluid = TContent.moltenStoneFluid;
        AdvancedSmelting.addMelting(Block.field_71981_t, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 8));
        AdvancedSmelting.addMelting(Block.field_71978_w, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 8));
        AdvancedSmelting.addMelting(TContent.craftedSoil, 1, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 36));
        Smeltery.addMelting((FluidType)ft, (ItemStack)new ItemStack(TContent.materials, 1, 2), (int)0, (int)144);
        AdvancedSmelting.addMelting(ft, new ItemStack(TContent.materials, 1, 2), TSRecipes.getFluidTempMod(ft), 144);
        for (int meta = 2; meta < 11; ++meta) {
            if (meta == 3) continue;
            Smeltery.addMelting((FluidType)ft, (ItemStack)new ItemStack(TContent.smeltery, 1, meta), (int)0, (int)144);
            AdvancedSmelting.addMelting(ft, new ItemStack(TContent.smeltery, 1, meta), TSRecipes.getFluidTempMod(ft), 144);
        }
    }

    public static void craftStorageBlocks() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.charcoalBlock, 1, 0), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(Item.field_77705_m, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.dustStorageBlock, 1, 0), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(Item.field_77677_M, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSContent.dustStorageBlock, 1, 1), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(Item.field_77747_aY, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_77705_m, 9, 1), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(TSContent.charcoalBlock, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_77677_M, 9), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(TSContent.dustStorageBlock, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_77747_aY, 9), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(TSContent.dustStorageBlock, 1, 1)});
    }

    public static void craftSteel() {
        FluidType ft = FluidType.Steel;
        ItemStack ingotSteel = TConstructRegistry.getItemStack((String)"ingotSteel");
        if (ConfigCore.enableSteelArmor) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TSContent.helmetSteel, new Object[]{patHead, Character.valueOf('#'), ingotSteel}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TSContent.chestplateSteel, new Object[]{patChest, Character.valueOf('#'), ingotSteel}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TSContent.leggingsSteel, new Object[]{patLegs, Character.valueOf('#'), ingotSteel}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TSContent.bootsSteel, new Object[]{patBoots, Character.valueOf('#'), ingotSteel}));
        }
        String[] oxidizers = new String[]{"dustGunpowder", "dustSulphur", "dustSulfur", "dustSaltpeter", "dustCoal"};
        String[] reducers = new String[]{"dustRedstone", "dustManganese", "dustAluminum", "dustAluminium"};
        String[] purifiers = new String[]{"blockSand", "Sandblock"};
        for (String o : oxidizers) {
            for (String r : reducers) {
                for (String p : purifiers) {
                    AdvancedSmelting.registerMixComboForFluidOutput(ft, FluidType.Iron, o, r, p);
                }
            }
        }
    }

    public static void craftPigIron() {
        FluidType ft = FluidType.PigIron;
        AdvancedSmelting.registerMixComboForFluidOutput(ft, FluidType.Iron, "dustSugar", "dyeWhite", "hambone");
    }

    public static void craftObsidian() {
        FluidType ft = FluidType.Obsidian;
        Fluid fluid = TContent.moltenObsidianFluid;
        AdvancedSmelting.addMelting(Block.field_72089_ap, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 288));
    }

    public static void craftGlass() {
        FluidType ft = FluidType.Glass;
        Fluid fluid = TContent.moltenGlassFluid;
        AdvancedSmelting.addMelting(Block.field_71939_E, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 1000));
        AdvancedSmelting.addMelting(Block.field_71946_M, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 1000));
        AdvancedSmelting.addMelting(Block.field_72003_bq, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 250));
        AdvancedSmelting.addMelting(TContent.clearGlass, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 1000));
        AdvancedSmelting.addMelting(TContent.glassPane, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 250));
    }

    public static void craftWater() {
        FluidType ft = FluidType.Water;
        Fluid fluid = FluidRegistry.WATER;
        AdvancedSmelting.addMelting(Block.field_72036_aT, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 1000));
        AdvancedSmelting.addMelting(Block.field_72039_aU, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 500));
        AdvancedSmelting.addMelting(Block.field_72037_aS, 0, TSRecipes.getFluidTempMod(ft), new FluidStack(fluid, 250));
    }

    public static void changeAnvil() {
        RecipeRemover.removeShapedRecipe((ItemStack)new ItemStack(Block.field_82510_ck));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_82510_ck), new Object[]{"bbb", " i ", "iii", Character.valueOf('i'), "ingotSteel", Character.valueOf('b'), "blockSteel"}));
        Smeltery.addMelting((FluidType)FluidType.Steel, (ItemStack)new ItemStack(Block.field_82510_ck, 1, 0), (int)0, (int)4464);
        Smeltery.addMelting((FluidType)FluidType.Steel, (ItemStack)new ItemStack(Block.field_82510_ck, 1, 1), (int)0, (int)4464);
        Smeltery.addMelting((FluidType)FluidType.Steel, (ItemStack)new ItemStack(Block.field_82510_ck, 1, 2), (int)0, (int)4464);
    }

    public static void changeFlintAndSteel() {
        RecipeRemover.removeShapedRecipe((ItemStack)new ItemStack(Item.field_77709_i));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.field_77709_i), new Object[]{"s ", " f", Character.valueOf('s'), "ingotSteel", Character.valueOf('f'), new ItemStack(Item.field_77804_ap)}));
        Item.field_77709_i.func_77656_e(128);
        Smeltery.addMelting((FluidType)FluidType.Steel, (ItemStack)new ItemStack(Item.field_77709_i, 1, 0), (int)0, (int)144);
    }

    public static void changePiston() {
        ItemStack rod = new ItemStack(TContent.toughRod, 1, 2);
        RecipeRemover.removeAnyRecipe((ItemStack)new ItemStack((Block)Block.field_71963_Z));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Block.field_71963_Z), new Object[]{"WWW", "CTC", "CRC", Character.valueOf('C'), "cobblestone", Character.valueOf('T'), rod, Character.valueOf('R'), "dustRedstone", Character.valueOf('W'), "plankWood"}));
    }

    public static int getFluidTempMod(FluidType type) {
        switch (type) {
            case Water: {
                return 10;
            }
            case Iron: {
                return 913;
            }
            case Gold: {
                return 663;
            }
            case Tin: {
                return -163;
            }
            case Copper: {
                return 534;
            }
            case Aluminum: {
                return 310;
            }
            case NaturalAluminum: {
                return 310;
            }
            case Cobalt: {
                return 845;
            }
            case Ardite: {
                return 910;
            }
            case AluminumBrass: {
                return 305;
            }
            case Alumite: {
                return -129;
            }
            case Manyullyn: {
                return 534;
            }
            case Bronze: {
                return 380;
            }
            case Steel: {
                return 840;
            }
            case Nickel: {
                return 1053;
            }
            case Lead: {
                return -73;
            }
            case Silver: {
                return 563;
            }
            case Platinum: {
                return 1370;
            }
            case Invar: {
                return 840;
            }
            case Electrum: {
                return 663;
            }
            case Obsidian: {
                return 330;
            }
            case Ender: {
                return 0;
            }
            case Glass: {
                return 975;
            }
            case Stone: {
                return 600;
            }
            case Emerald: {
                return 1025;
            }
            case Slime: {
                return 0;
            }
            case PigIron: {
                return 983;
            }
            case Glue: {
                return 0;
            }
        }
        return 0;
    }
}

