/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModAPIManager {
    public static final ModAPIManager INSTANCE = new ModAPIManager();
    private ModAPITransformer transformer;
    private ASMDataTable dataTable;
    private Map<String, APIContainer> apiContainers;

    public void registerDataTableAndParseAPI(ASMDataTable dataTable) {
        this.dataTable = dataTable;
        Set<ASMDataTable.ASMData> apiList = dataTable.getAll("cpw.mods.fml.common.API");
        this.apiContainers = Maps.newHashMap();
        for (ASMDataTable.ASMData data : apiList) {
            Map<String, Object> annotationInfo = data.getAnnotationInfo();
            String apiPackage = data.getClassName().substring(0, data.getClassName().indexOf(".package-info"));
            String providedAPI = (String)annotationInfo.get("provides");
            String apiOwner = (String)annotationInfo.get("owner");
            String apiVersion = (String)annotationInfo.get("apiVersion");
            APIContainer container = this.apiContainers.get(providedAPI);
            if (container == null) {
                container = new APIContainer(providedAPI, apiVersion, data.getCandidate().getModContainer(), VersionParser.parseVersionReference(apiOwner));
                this.apiContainers.put(providedAPI, container);
            } else {
                container.validate(providedAPI, apiOwner, apiVersion);
            }
            container.addOwnedPackage(apiPackage);
            for (ModContainer mc : data.getCandidate().getContainedMods()) {
                String embeddedIn = mc.getModId();
                if (container.currentReferents.contains(embeddedIn)) continue;
                FMLLog.fine("Found API %s (owned by %s providing %s) embedded in %s", apiPackage, apiOwner, providedAPI, embeddedIn);
                if (embeddedIn.equals(apiOwner)) continue;
                container.addAPIReference(embeddedIn);
            }
        }
        for (APIContainer container : this.apiContainers.values()) {
            for (String pkg : container.packages) {
                Set<ModCandidate> candidates = dataTable.getCandidatesFor(pkg);
                for (ModCandidate candidate : candidates) {
                    List<String> candidateIds = Lists.transform(candidate.getContainedMods(), new ModIdFunction());
                    if (candidateIds.contains(container.ownerMod.getLabel()) || container.currentReferents.containsAll(candidateIds)) continue;
                    FMLLog.info("Found mod(s) %s containing declared API package %s (owned by %s) without associated API reference", candidateIds, pkg, container.ownerMod);
                    container.addAPIReferences(candidateIds);
                }
            }
            if (this.apiContainers.containsKey(container.ownerMod.getLabel())) {
                APIContainer parent;
                ArtifactVersion owner = container.ownerMod;
                do {
                    parent = this.apiContainers.get(owner.getLabel());
                    FMLLog.finest("Removing upstream parent %s from %s", parent.ownerMod.getLabel(), container);
                    container.currentReferents.remove(parent.ownerMod.getLabel());
                    container.referredMods.remove(parent.ownerMod);
                } while (this.apiContainers.containsKey((owner = parent.ownerMod).getLabel()));
            }
            FMLLog.fine("Creating API container dummy for API %s: owner: %s, dependents: %s", container.providedAPI, container.ownerMod, container.referredMods);
        }
    }

    public void manageAPI(ModClassLoader modClassLoader, ModDiscoverer discoverer) {
        this.registerDataTableAndParseAPI(discoverer.getASMTable());
        this.transformer = modClassLoader.addModAPITransformer(this.dataTable);
    }

    public void injectAPIModContainers(List<ModContainer> mods, Map<String, ModContainer> nameLookup) {
        mods.addAll(this.apiContainers.values());
        nameLookup.putAll(this.apiContainers);
    }

    public void cleanupAPIContainers(List<ModContainer> mods) {
        mods.removeAll(this.apiContainers.values());
    }

    public boolean hasAPI(String modId) {
        return this.apiContainers.containsKey(modId);
    }

    private static class APIContainer
    extends DummyModContainer {
        private List<ArtifactVersion> referredMods;
        private ArtifactVersion ownerMod;
        private ArtifactVersion ourVersion;
        private String providedAPI;
        private File source;
        private String version;
        private Set<String> currentReferents;
        private Set<String> packages;

        public APIContainer(String providedAPI, String apiVersion, File source, ArtifactVersion ownerMod) {
            this.providedAPI = providedAPI;
            this.version = apiVersion;
            this.ownerMod = ownerMod;
            this.ourVersion = new DefaultArtifactVersion(providedAPI, apiVersion);
            this.referredMods = Lists.newArrayList();
            this.source = source;
            this.currentReferents = Sets.newHashSet();
            this.packages = Sets.newHashSet();
        }

        @Override
        public File getSource() {
            return this.source;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getName() {
            return "API: " + this.providedAPI;
        }

        @Override
        public String getModId() {
            return "API:" + this.providedAPI;
        }

        @Override
        public List<ArtifactVersion> getDependants() {
            return this.referredMods;
        }

        @Override
        public List<ArtifactVersion> getDependencies() {
            return ImmutableList.of(this.ownerMod);
        }

        @Override
        public ArtifactVersion getProcessedVersion() {
            return this.ourVersion;
        }

        public void validate(String providedAPI, String apiOwner, String apiVersion) {
        }

        @Override
        public String toString() {
            return "APIContainer{" + this.providedAPI + ":" + this.version + "}";
        }

        public void addAPIReference(String embedded) {
            if (this.currentReferents.add(embedded)) {
                this.referredMods.add(VersionParser.parseVersionReference(embedded));
            }
        }

        public void addOwnedPackage(String apiPackage) {
            this.packages.add(apiPackage);
        }

        public void addAPIReferences(List<String> candidateIds) {
            for (String modId : candidateIds) {
                this.addAPIReference(modId);
            }
        }
    }
}

