/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModListRequestPacket
extends FMLPacket {
    private List<String> sentModList;
    private byte compatibilityLevel;

    public ModListRequestPacket() {
        super(FMLPacket.Type.MOD_LIST_REQUEST);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        Set<ModContainer> activeMods = FMLNetworkHandler.instance().getNetworkModList();
        dat.writeInt(activeMods.size());
        for (ModContainer mc : activeMods) {
            dat.writeUTF(mc.getModId());
        }
        dat.writeByte(FMLNetworkHandler.getCompatibilityLevel());
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        this.sentModList = Lists.newArrayList();
        ByteArrayDataInput in2 = ByteStreams.newDataInput(data);
        int listSize = in2.readInt();
        for (int i2 = 0; i2 < listSize; ++i2) {
            this.sentModList.add(in2.readUTF());
        }
        try {
            this.compatibilityLevel = in2.readByte();
        }
        catch (IllegalStateException e2) {
            FMLLog.fine("No compatibility byte found - the server is too old", new Object[0]);
        }
        return this;
    }

    @Override
    public void execute(cm mgr, FMLNetworkHandler handler, ez netHandler, String userName) {
        ArrayList<String> missingMods = Lists.newArrayList();
        HashMap<String, String> modVersions = Maps.newHashMap();
        HashMap<String, ModContainer> indexedModList = Maps.newHashMap(Loader.instance().getIndexedModList());
        for (String string : this.sentModList) {
            ModContainer mc = (ModContainer)indexedModList.get(string);
            if (mc == null) {
                missingMods.add(string);
                continue;
            }
            indexedModList.remove(string);
            modVersions.put(string, mc.getVersion());
        }
        if (indexedModList.size() > 0) {
            for (Map.Entry entry : indexedModList.entrySet()) {
                NetworkModHandler missingHandler;
                if (!((ModContainer)entry.getValue()).isNetworkMod() || !(missingHandler = FMLNetworkHandler.instance().findNetworkModHandler(entry.getValue())).requiresServerSide()) continue;
                FMLLog.warning("The mod %s was not found on the server you connected to, but requested that the server side be present", entry.getKey());
            }
        }
        FMLLog.fine("The server has compatibility level %d", this.compatibilityLevel);
        FMLCommonHandler.instance().getSidedDelegate().setClientCompatibilityLevel(this.compatibilityLevel);
        mgr.a(PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_RESPONSE, modVersions, missingMods)));
    }
}

