/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.BlockTracker;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;

public class GameRegistry {
    private static Multimap<ModContainer, BlockProxy> blockRegistry = ArrayListMultimap.create();
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ICraftingHandler> craftingHandlers = Lists.newArrayList();
    private static List<IPickupNotifier> pickupHandlers = Lists.newArrayList();
    private static List<IPlayerTracker> playerTrackers = Lists.newArrayList();

    public static void registerWorldGenerator(IWorldGenerator generator) {
        worldGenerators.add(generator);
    }

    public static void generateWorld(int chunkX, int chunkZ, abw world, ado chunkGenerator, ado chunkProvider) {
        long worldSeed = world.H();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : worldGenerators) {
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public static Object buildBlock(ModContainer container, Class<?> type, Mod.Block annotation) throws Exception {
        Object o2 = type.getConstructor(Integer.TYPE).newInstance(GameRegistry.findSpareBlockId());
        GameRegistry.registerBlock((aqz)o2);
        return o2;
    }

    private static int findSpareBlockId() {
        return BlockTracker.nextBlockId();
    }

    public static void registerItem(yc item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerItem(yc item, String name, String modId) {
        GameData.setName(item, name, modId);
    }

    @Deprecated
    public static void registerBlock(aqz block) {
        GameRegistry.registerBlock(block, zh.class);
    }

    public static void registerBlock(aqz block, String name) {
        GameRegistry.registerBlock(block, zh.class, name);
    }

    @Deprecated
    public static void registerBlock(aqz block, Class<? extends zh> itemclass) {
        GameRegistry.registerBlock(block, itemclass, null);
    }

    public static void registerBlock(aqz block, Class<? extends zh> itemclass, String name) {
        GameRegistry.registerBlock(block, itemclass, name, null);
    }

    public static void registerBlock(aqz block, Class<? extends zh> itemclass, String name, String modId) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            yc i2;
            assert (block != null) : "registerBlock: block cannot be null";
            assert (itemclass != null) : "registerBlock: itemclass cannot be null";
            int blockItemId = block.cF - 256;
            try {
                Constructor<? extends zh> itemCtor = itemclass.getConstructor(Integer.TYPE);
                i2 = itemCtor.newInstance(blockItemId);
            }
            catch (NoSuchMethodException e2) {
                Constructor<? extends zh> itemCtor = itemclass.getConstructor(Integer.TYPE, aqz.class);
                i2 = itemCtor.newInstance(blockItemId, block);
            }
            GameRegistry.registerItem(i2, name, modId);
        }
        catch (Exception e3) {
            FMLLog.log(Level.SEVERE, e3, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e3);
        }
        blockRegistry.put(Loader.instance().activeModContainer(), (BlockProxy)((Object)block));
    }

    public static void addRecipe(ye output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static aah addShapedRecipe(ye output, Object ... params) {
        return aaf.a().a(output, params);
    }

    public static void addShapelessRecipe(ye output, Object ... params) {
        aaf.a().b(output, params);
    }

    public static void addRecipe(aah recipe) {
        aaf.a().b().add(recipe);
    }

    public static void addSmelting(int input, ye output, float xp2) {
        aab.a().a(input, output, xp2);
    }

    public static void registerTileEntity(Class<? extends asp> tileEntityClass, String id2) {
        asp.a(tileEntityClass, id2);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends asp> tileEntityClass, String id2, String ... alternatives) {
        asp.a(tileEntityClass, id2);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(asp.class, null, "field_70326_a", "nameToClassMap", "a");
        for (String s2 : alternatives) {
            if (teMappings.containsKey(s2)) continue;
            teMappings.put(s2, tileEntityClass);
        }
    }

    public static void addBiome(acq biome) {
        acg.b.addNewBiome(biome);
    }

    public static void removeBiome(acq biome) {
        acg.b.removeBiome(biome);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(ye itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        craftingHandlers.add(handler);
    }

    public static void onItemCrafted(uf player, ye item, mo craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onCrafting(player, item, craftMatrix);
        }
    }

    public static void onItemSmelted(uf player, ye item) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onSmelting(player, item);
        }
    }

    public static void registerPickupHandler(IPickupNotifier handler) {
        pickupHandlers.add(handler);
    }

    public static void onPickupNotification(uf player, ss item) {
        for (IPickupNotifier notify : pickupHandlers) {
            notify.notifyPickup(item, player);
        }
    }

    public static void registerPlayerTracker(IPlayerTracker tracker) {
        playerTrackers.add(tracker);
    }

    public static void onPlayerLogin(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerLogin(player);
            }
            catch (Exception e2) {
                FMLLog.log(Level.SEVERE, e2, "A critical error occured handling the onPlayerLogin event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static void onPlayerLogout(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerLogout(player);
            }
            catch (Exception e2) {
                FMLLog.log(Level.SEVERE, e2, "A critical error occured handling the onPlayerLogout event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static void onPlayerChangedDimension(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerChangedDimension(player);
            }
            catch (Exception e2) {
                FMLLog.log(Level.SEVERE, e2, "A critical error occured handling the onPlayerChangedDimension event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static void onPlayerRespawn(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerRespawn(player);
            }
            catch (Exception e2) {
                FMLLog.log(Level.SEVERE, e2, "A critical error occured handling the onPlayerRespawn event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static aqz findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static yc findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, ye itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static ye findItemStack(String modId, String name, int stackSize) {
        ye foundStack = GameData.findItemStack(modId, name);
        if (foundStack != null) {
            ye is2 = foundStack.m();
            is2.b = Math.min(stackSize, is2.e());
            return is2;
        }
        return null;
    }

    public static UniqueIdentifier findUniqueIdentifierFor(aqz block) {
        return GameData.getUniqueName(block);
    }

    public static UniqueIdentifier findUniqueIdentifierFor(yc item) {
        return GameData.getUniqueName(item);
    }

    public static class UniqueIdentifier {
        public final String modId;
        public final String name;

        UniqueIdentifier(String modId, String name) {
            this.modId = modId;
            this.name = name;
        }
    }
}

