/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.EntityPhysicsBlock;
import enviromine.EnviroPotion;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EntityProperties;
import enviromine.trackers.EnviroDataTracker;
import enviromine.trackers.Hallucination;
import enviromine.trackers.ItemProperties;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityFallingSand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.EnumStatus;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityRecordPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EM_EventManager {
    String lastAttID = "";

    @ForgeSubscribe
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        boolean chunkPhys = true;
        if (!event.world.field_72995_K && EM_PhysManager.chunkDelay.containsKey("" + (MathHelper.func_76128_c((double)event.entity.field_70165_t) >> 4) + "," + (MathHelper.func_76128_c((double)event.entity.field_70161_v) >> 4))) {
            boolean bl = chunkPhys = EM_PhysManager.chunkDelay.get("" + (MathHelper.func_76128_c((double)event.entity.field_70165_t) >> 4) + "," + (MathHelper.func_76128_c((double)event.entity.field_70161_v) >> 4)) < event.world.func_82737_E();
        }
        if (event.entity instanceof EntityLivingBase) {
            if (event.entity.field_70170_p != null && event.entity.field_70170_p.field_72995_K && EnviroMine.proxy.isClient() && Minecraft.func_71410_x().func_71387_A()) {
                return;
            }
            if (event.entity.field_70128_L || ((EntityLivingBase)event.entity).func_110143_aJ() <= 0.0f) {
                return;
            }
            if (EnviroDataTracker.isLegalType((EntityLivingBase)event.entity)) {
                EnviroDataTracker oldTrack;
                if (!(event.entity instanceof EntityPlayer) && !EM_Settings.trackNonPlayer) {
                    return;
                }
                if (event.entity instanceof EntityPlayer && (oldTrack = EM_StatusManager.lookupTrackerFromUsername(((EntityPlayer)event.entity).field_71092_bJ)) != null) {
                    oldTrack.trackedEntity = (EntityLivingBase)event.entity;
                    oldTrack.isDisabled = false;
                    oldTrack.loadNBTTags();
                    return;
                }
                EnviroDataTracker emTrack = new EnviroDataTracker((EntityLivingBase)event.entity);
                EM_StatusManager.addToManager(emTrack);
                emTrack.loadNBTTags();
                if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
                    EM_StatusManager.syncMultiplayerTracker(emTrack);
                }
            }
        } else if (event.entity instanceof EntityFallingSand && EM_Settings.enablePhysics && !(event.entity instanceof EntityPhysicsBlock) && !event.world.field_72995_K && event.world.func_82737_E() > EM_PhysManager.worldStartTime + (long)EM_Settings.worldDelay && chunkPhys) {
            EntityFallingSand oldSand = (EntityFallingSand)event.entity;
            if (oldSand.field_70287_a == 0) {
                return;
            }
            NBTTagCompound oldTags = new NBTTagCompound();
            oldSand.func_70109_d(oldTags);
            EntityPhysicsBlock newSand = new EntityPhysicsBlock(oldSand.field_70170_p, oldSand.field_70169_q, oldSand.field_70167_r, oldSand.field_70166_s, oldSand.field_70287_a, oldSand.field_70285_b, true);
            newSand.func_70020_e(oldTags);
            event.world.func_72838_d((Entity)newSand);
            event.setCanceled(true);
            event.entity.func_70106_y();
        }
    }

    @ForgeSubscribe
    public void onLivingDeath(LivingDeathEvent event) {
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(event.entityLiving);
        if (tracker != null) {
            if (event.entityLiving instanceof EntityPlayer && event.source == null) {
                EntityPlayer player = EM_StatusManager.findPlayer(((EntityPlayer)event.entityLiving).field_71092_bJ);
                if (player != null) {
                    tracker.trackedEntity = player;
                    tracker.isDisabled = false;
                    tracker.loadNBTTags();
                } else {
                    tracker.resetData();
                    EM_StatusManager.saveAndRemoveTracker(tracker);
                }
                return;
            }
            tracker.resetData();
            EM_StatusManager.saveAndRemoveTracker(tracker);
        }
    }

    @ForgeSubscribe
    public void onEntityAttacked(LivingAttackEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (("" + event.entityLiving.field_70157_k + "," + event.entityLiving.field_70170_p.func_82737_E()).equalsIgnoreCase(this.lastAttID)) {
            return;
        }
        this.lastAttID = "" + event.entityLiving.field_70157_k + "," + event.entityLiving.field_70170_p.func_82737_E();
        Entity attacker = event.source.func_76346_g();
        if (attacker != null) {
            EnviroDataTracker tracker = EM_StatusManager.lookupTracker(event.entityLiving);
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                if (player.field_71075_bZ.field_75102_a || player.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            if (tracker != null) {
                EntityProperties livingProps = null;
                if (EntityList.func_75619_a((Entity)attacker) > 0) {
                    if (EM_Settings.livingProperties.containsKey(EntityList.func_75619_a((Entity)attacker))) {
                        livingProps = EM_Settings.livingProperties.get(EntityList.func_75619_a((Entity)attacker));
                    }
                } else if (EntityRegistry.instance().lookupModSpawn(attacker.getClass(), false) != null && EM_Settings.livingProperties.containsKey(EntityRegistry.instance().lookupModSpawn(attacker.getClass(), false).getModEntityId() + 128)) {
                    livingProps = EM_Settings.livingProperties.get(EntityRegistry.instance().lookupModSpawn(attacker.getClass(), false).getModEntityId() + 128);
                }
                if (livingProps != null) {
                    tracker.sanity += livingProps.hitSanity;
                    tracker.airQuality += livingProps.hitAir;
                    tracker.hydration += livingProps.hitHydration;
                    tracker.bodyTemp += livingProps.hitTemp;
                } else if (attacker instanceof EntityEnderman || attacker.func_70023_ak().toLowerCase().contains("ender")) {
                    tracker.sanity -= 5.0f;
                } else if (attacker instanceof EntityLivingBase && ((EntityLivingBase)attacker).func_70662_br()) {
                    tracker.sanity -= 1.0f;
                }
            }
        }
    }

    @ForgeSubscribe
    public void onEntitySoundPlay(PlaySoundAtEntityEvent event) {
        if (event.entity != null && event.entity.getEntityData().func_74767_n("EM_Hallucination")) {
            if (EnviroMine.proxy.isClient()) {
                Minecraft.func_71410_x().field_71416_A.func_77364_b(event.name, (float)event.entity.field_70165_t, (float)event.entity.field_70163_u, (float)event.entity.field_70161_v, 1.0f, (event.entity.field_70170_p.field_73012_v.nextFloat() - event.entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            }
            event.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item = event.entityPlayer.func_71045_bC();
        if (event.getResult() != Event.Result.DENY && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) && item != null) {
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                if (item.func_77973_b() instanceof ItemBlock && !event.entityPlayer.field_70170_p.field_72995_K) {
                    int[] adjCoords = EM_EventManager.getAdjacentBlockCoordsFromSide(event.x, event.y, event.z, event.face);
                    EM_PhysManager.schedulePhysUpdate(event.entityPlayer.field_70170_p, adjCoords[0], adjCoords[1], adjCoords[2], true, "Normal");
                } else if (item.field_77993_c == Item.field_77781_bS.field_77779_bT) {
                    this.RecordEasterEgg(event.entityPlayer, event.x, event.y, event.z);
                }
            }
            if (item.field_77993_c == Item.field_77729_bt.field_77779_bT && !event.entityPlayer.field_70170_p.field_72995_K) {
                EM_EventManager.fillBottle(event.entityPlayer.field_70170_p, event.entityPlayer, event.x, event.y, event.z, item, event);
            }
        } else if (event.getResult() != Event.Result.DENY && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && item == null) {
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                EM_EventManager.drinkWater(event.entityPlayer, event);
            }
        } else if (event.getResult() != Event.Result.DENY && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            EM_PhysManager.schedulePhysUpdate(event.entityPlayer.field_70170_p, event.x, event.y, event.z, true, "Normal");
        } else if (event.getResult() != Event.Result.DENY && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && item == null && EnviroMine.proxy.isClient()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeBytes("ID:1," + event.entityPlayer.field_71092_bJ);
                Packet250CustomPayload packet = new Packet250CustomPayload();
                packet.field_73630_a = "EM_CH";
                packet.field_73629_c = bos.toByteArray();
                packet.field_73628_b = bos.size();
                PacketDispatcher.sendPacketToServer((Packet)packet);
                dos.close();
                bos.close();
            }
            catch (IOException e) {
                EnviroMine.logger.log(Level.SEVERE, "EnviroMine failed to build right-click packet!", e);
            }
        }
    }

    public void RecordEasterEgg(EntityPlayer player, int x, int y, int z) {
        EnviroDataTracker tracker;
        TileEntityRecordPlayer recordplayer;
        int k;
        int j;
        int i;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        MovingObjectPosition movingobjectposition = EM_EventManager.getMovingObjectPositionFromPlayer(player.field_70170_p, player, true);
        if (movingobjectposition == null) {
            return;
        }
        if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE && player.field_70170_p.func_72798_a(i = movingobjectposition.field_72311_b, j = movingobjectposition.field_72312_c, k = movingobjectposition.field_72309_d) == Block.field_72032_aY.field_71990_ca && (recordplayer = (TileEntityRecordPlayer)player.field_70170_p.func_72796_p(i, j, k)) != null && recordplayer.func_96097_a() == null && (tracker = EM_StatusManager.lookupTracker((EntityLivingBase)player)) != null) {
            if (tracker.sanity >= 75.0f) {
                tracker.sanity -= 50.0f;
            }
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)"An eerie shiver travels down your spine"));
        }
    }

    public static void fillBottle(World world, EntityPlayer player, int x, int y, int z, ItemStack item, PlayerInteractEvent event) {
        MovingObjectPosition movingobjectposition = EM_EventManager.getMovingObjectPositionFromPlayer(world, player, true);
        if (movingobjectposition == null) {
            return;
        }
        if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            boolean isValidCauldron;
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            boolean bl = isValidCauldron = player.field_70170_p.func_72798_a(i, j, k) == Block.field_72108_bG.field_71990_ca && player.field_70170_p.func_72805_g(i, j, k) > 0;
            if (!world.func_72962_a(player, i, j, k)) {
                return;
            }
            if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, item)) {
                return;
            }
            boolean isWater = world.func_72798_a(i, j, k) == Block.field_71943_B.field_71990_ca || world.func_72798_a(i, j, k) == Block.field_71942_A.field_71990_ca;
            if (isWater || isValidCauldron) {
                ItemPotion newItem = Item.field_77726_bs;
                switch (EM_EventManager.getWaterType(world, i, j, k)) {
                    case 0: {
                        newItem = Item.field_77726_bs;
                        break;
                    }
                    case 1: {
                        newItem = EnviroMine.badWaterBottle;
                        break;
                    }
                    case 2: {
                        newItem = EnviroMine.saltWaterBottle;
                        break;
                    }
                    case 3: {
                        newItem = EnviroMine.coldWaterBottle;
                    }
                }
                if (isValidCauldron && (world.func_72798_a(i, j - 1, k) == Block.field_72067_ar.field_71990_ca || world.func_72798_a(i, j - 1, k) == Block.field_71944_C.field_71990_ca || world.func_72798_a(i, j - 1, k) == Block.field_71938_D.field_71990_ca)) {
                    newItem = Item.field_77726_bs;
                }
                if (isValidCauldron) {
                    player.field_70170_p.func_72921_c(i, j, k, player.field_70170_p.func_72805_g(i, j, k) - 1, 2);
                }
                --item.field_77994_a;
                if (item.field_77994_a <= 0) {
                    item.field_77993_c = newItem.field_77779_bT;
                    item.field_77994_a = 1;
                    item.func_77964_b(0);
                } else {
                    EntityItem itemDrop = player.func_71021_b(new ItemStack(newItem.field_77779_bT, 1, 0));
                    itemDrop.field_70293_c = 0;
                }
                event.setCanceled(true);
            }
        }
    }

    public static void drinkWater(EntityPlayer entityPlayer, PlayerInteractEvent event) {
        if (entityPlayer.func_70055_a(Material.field_76244_g)) {
            return;
        }
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker((EntityLivingBase)entityPlayer);
        MovingObjectPosition mop = EM_EventManager.getMovingObjectPositionFromPlayer(entityPlayer.field_70170_p, entityPlayer, true);
        if (mop != null && mop.field_72313_a == EnumMovingObjectType.TILE) {
            boolean isValidCauldron;
            int i = mop.field_72311_b;
            int j = mop.field_72312_c;
            int k = mop.field_72309_d;
            int[] hitBlock = EM_EventManager.getAdjacentBlockCoordsFromSide(i, j, k, mop.field_72310_e);
            int x = hitBlock[0];
            int y = hitBlock[1];
            int z = hitBlock[2];
            if (entityPlayer.field_70170_p.func_72803_f(i, j, k) != Material.field_76244_g && entityPlayer.field_70170_p.func_72803_f(x, y, z) == Material.field_76244_g) {
                i = x;
                j = y;
                k = z;
            }
            boolean isWater = entityPlayer.field_70170_p.func_72798_a(i, j, k) == Block.field_71942_A.field_71990_ca || entityPlayer.field_70170_p.func_72798_a(i, j, k) == Block.field_71943_B.field_71990_ca;
            boolean bl = isValidCauldron = entityPlayer.field_70170_p.func_72798_a(i, j, k) == Block.field_72108_bG.field_71990_ca && entityPlayer.field_70170_p.func_72805_g(i, j, k) > 0;
            if ((isWater || isValidCauldron) && tracker != null && tracker.hydration < 100.0f) {
                int type = 0;
                type = isValidCauldron && (entityPlayer.field_70170_p.func_72798_a(i, j - 1, k) == Block.field_72067_ar.field_71990_ca || entityPlayer.field_70170_p.func_72798_a(i, j - 1, k) == Block.field_71944_C.field_71990_ca || entityPlayer.field_70170_p.func_72798_a(i, j - 1, k) == Block.field_71938_D.field_71990_ca) ? 0 : EM_EventManager.getWaterType(entityPlayer.field_70170_p, i, j, k);
                if (type == 0) {
                    if (tracker.bodyTemp >= 37.05f) {
                        tracker.bodyTemp = (float)((double)tracker.bodyTemp - 0.05);
                    }
                    tracker.hydrate(10.0f);
                } else if (type == 1) {
                    if (entityPlayer.func_70681_au().nextInt(2) == 0) {
                        entityPlayer.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 200));
                    }
                    if (entityPlayer.func_70681_au().nextInt(4) == 0) {
                        entityPlayer.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200));
                    }
                    if ((double)tracker.bodyTemp >= 37.05) {
                        tracker.bodyTemp = (float)((double)tracker.bodyTemp - 0.05);
                    }
                    tracker.hydrate(10.0f);
                } else if (type == 2) {
                    if (entityPlayer.func_70681_au().nextInt(1) == 0) {
                        if (entityPlayer.func_70660_b((Potion)EnviroPotion.dehydration) != null && entityPlayer.func_70681_au().nextInt(5) == 0) {
                            int amp = entityPlayer.func_70660_b((Potion)EnviroPotion.dehydration).func_76458_c();
                            entityPlayer.func_70690_d(new PotionEffect(EnviroPotion.dehydration.field_76415_H, 600, amp + 1));
                        } else {
                            entityPlayer.func_70690_d(new PotionEffect(EnviroPotion.dehydration.field_76415_H, 600));
                        }
                    }
                    if ((double)tracker.bodyTemp >= 37.05) {
                        tracker.bodyTemp = (float)((double)tracker.bodyTemp - 0.05);
                    }
                    tracker.hydrate(5.0f);
                } else if (type == 3) {
                    if ((double)tracker.bodyTemp >= 30.1) {
                        tracker.bodyTemp = (float)((double)tracker.bodyTemp - 0.1);
                    }
                    tracker.hydrate(10.0f);
                }
                if (isValidCauldron && EM_Settings.limitCauldron) {
                    entityPlayer.field_70170_p.func_72921_c(i, j, k, entityPlayer.field_70170_p.func_72805_g(i, j, k) - 1, 2);
                }
                entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.drink", 1.0f, 1.0f);
                if (event != null) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static int getWaterType(World world, int x, int y, int z) {
        Color bColor;
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> bTypeList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        if (biome == null) {
            return 0;
        }
        int waterColour = biome.getWaterColorMultiplier();
        boolean looksBad = false;
        if (waterColour != 0xFFFFFF && ((bColor = new Color(waterColour)).getRed() < 200 || bColor.getGreen() < 200 || bColor.getBlue() < 200)) {
            looksBad = true;
        }
        if (bTypeList.contains(BiomeDictionary.Type.SWAMP) || bTypeList.contains(BiomeDictionary.Type.JUNGLE) || y < 48 || looksBad) {
            return 1;
        }
        if (biome.field_76791_y == BiomeGenBase.field_76776_l.field_76791_y || biome.field_76791_y == BiomeGenBase.field_76771_b.field_76791_y || biome.field_76791_y == BiomeGenBase.field_76787_r.field_76791_y) {
            return 2;
        }
        if (bTypeList.contains(BiomeDictionary.Type.FROZEN) || biome.field_76750_F < 0.0f || y > 96) {
            return 3;
        }
        return 0;
    }

    public static int[] getAdjacentBlockCoordsFromSide(int x, int y, int z, int side) {
        int[] coords = new int[]{x, y, z};
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (dir) {
            case NORTH: {
                coords[2] = coords[2] - 1;
                break;
            }
            case SOUTH: {
                coords[2] = coords[2] + 1;
                break;
            }
            case WEST: {
                coords[0] = coords[0] - 1;
                break;
            }
            case EAST: {
                coords[0] = coords[0] + 1;
                break;
            }
            case UP: {
                coords[1] = coords[1] + 1;
                break;
            }
            case DOWN: {
                coords[1] = coords[1] - 1;
                break;
            }
        }
        return coords;
    }

    @ForgeSubscribe
    public void onBreakBlock(BlockEvent.HarvestDropsEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.harvester != null) {
            if (event.getResult() != Event.Result.DENY && !event.harvester.field_71075_bZ.field_75098_d) {
                EM_PhysManager.schedulePhysUpdate(event.world, event.x, event.y, event.z, true, "Normal");
            }
        } else if (event.getResult() != Event.Result.DENY) {
            EM_PhysManager.schedulePhysUpdate(event.world, event.x, event.y, event.z, true, "Normal");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ForgeSubscribe
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        AttributeModifier mod;
        AttributeInstance attribute;
        AttributeInstance attribute2;
        if (event.entityLiving.field_70128_L) {
            return;
        }
        if (event.entityLiving.field_70170_p.field_72995_K) {
            if (event.entityLiving.func_70681_au().nextInt(5) == 0) {
                EM_StatusManager.createFX(event.entityLiving);
            }
            if (!(event.entityLiving instanceof EntityPlayer) || !event.entityLiving.field_70170_p.field_72995_K) return;
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a((Potion)EnviroPotion.insanity) && event.entityLiving.func_70681_au().nextInt(75) == 0) {
                new Hallucination(event.entityLiving);
            }
            Hallucination.update();
            return;
        }
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(event.entityLiving);
        if (tracker == null) {
            if (EnviroMine.proxy.isClient() && !EnviroMine.proxy.isOpenToLAN() || !EM_Settings.enableAirQ && !EM_Settings.enableBodyTemp && !EM_Settings.enableHydrate && !EM_Settings.enableSanity) return;
            if (!(event.entityLiving instanceof EntityPlayer) && (!EM_Settings.trackNonPlayer || !EnviroDataTracker.isLegalType(event.entityLiving))) return;
            EnviroMine.logger.log(Level.WARNING, "Server lost track of player! Attempting to re-sync...");
            EnviroDataTracker emTrack = new EnviroDataTracker((EntityLivingBase)event.entity);
            EM_StatusManager.addToManager(emTrack);
            emTrack.loadNBTTags();
            EM_StatusManager.syncMultiplayerTracker(emTrack);
            tracker = emTrack;
        }
        EM_StatusManager.updateTracker(tracker);
        UUID EM_DEHY1_ID = EM_Settings.DEHY1_UUID;
        if (tracker.hydration < 10.0f) {
            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 0));
            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 0));
            attribute2 = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod2 = new AttributeModifier(EM_DEHY1_ID, "EM_Dehydrated", -0.25, 2);
            if (mod2 != null && attribute2.func_111127_a(mod2.func_111167_a()) == null) {
                attribute2.func_111121_a(mod2);
            }
        } else {
            attribute2 = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attribute2.func_111127_a(EM_DEHY1_ID) != null) {
                attribute2.func_111124_b(attribute2.func_111127_a(EM_DEHY1_ID));
            }
        }
        UUID EM_FROST1_ID = EM_Settings.FROST1_UUID;
        UUID EM_FROST2_ID = EM_Settings.FROST2_UUID;
        UUID EM_FROST3_ID = EM_Settings.FROST3_UUID;
        UUID EM_HEAT1_ID = EM_Settings.HEAT1_UUID;
        if (event.entityLiving.func_70644_a((Potion)EnviroPotion.heatstroke)) {
            attribute = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
            mod = new AttributeModifier(EM_HEAT1_ID, "EM_Heat", -0.25, 2);
            if (mod != null && attribute.func_111127_a(mod.func_111167_a()) == null) {
                attribute.func_111121_a(mod);
            }
        } else {
            attribute = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attribute.func_111127_a(EM_HEAT1_ID) != null) {
                attribute.func_111124_b(attribute.func_111127_a(EM_HEAT1_ID));
            }
        }
        if (event.entityLiving.func_70644_a((Potion)EnviroPotion.hypothermia) || event.entityLiving.func_70644_a((Potion)EnviroPotion.frostbite)) {
            attribute = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
            mod = new AttributeModifier(EM_FROST1_ID, "EM_Frost_Cold", -0.25, 2);
            String msg = "";
            if (event.entityLiving.func_70644_a((Potion)EnviroPotion.frostbite)) {
                if (event.entityLiving.func_70660_b((Potion)EnviroPotion.frostbite).func_76458_c() > 0) {
                    mod = new AttributeModifier(EM_FROST3_ID, "EM_Frost_NOLEGS", -0.99, 2);
                    if (event.entityLiving instanceof EntityPlayer) {
                        msg = "Your legs stiffen as they succumb to frostbite";
                    }
                } else {
                    mod = new AttributeModifier(EM_FROST2_ID, "EM_Frost_NOHANDS", -0.5, 2);
                    if (event.entityLiving instanceof EntityPlayer) {
                        msg = "Your fingers start to feel numb and unresponsive";
                    }
                }
            }
            if (mod != null && attribute.func_111127_a(mod.func_111167_a()) == null) {
                attribute.func_111121_a(mod);
                if (event.entityLiving instanceof EntityPlayer && mod.func_111167_a() != EM_FROST1_ID) {
                    ((EntityPlayer)event.entityLiving).func_70006_a(ChatMessageComponent.func_111066_d((String)msg));
                }
            }
        } else {
            attribute = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attribute.func_111127_a(EM_FROST1_ID) != null) {
                attribute.func_111124_b(attribute.func_111127_a(EM_FROST1_ID));
            }
            if (attribute.func_111127_a(EM_FROST2_ID) != null && tracker.frostbiteLevel < 1) {
                attribute.func_111124_b(attribute.func_111127_a(EM_FROST2_ID));
            }
            if (attribute.func_111127_a(EM_FROST3_ID) != null && tracker.frostbiteLevel < 2) {
                attribute.func_111124_b(attribute.func_111127_a(EM_FROST3_ID));
            }
        }
        if (event.entityLiving.func_70644_a((Potion)EnviroPotion.frostbite) && event.entityLiving.func_70660_b((Potion)EnviroPotion.frostbite).func_76458_c() > 0 && event.entityLiving.func_70115_ae()) {
            event.entityLiving.func_70031_b(false);
            event.entityLiving.func_70637_d(false);
            if ((event.entityLiving.field_70137_T < event.entityLiving.field_70163_u || event.entityLiving.field_70167_r < event.entityLiving.field_70163_u || event.entityLiving.field_70181_x > 0.0) && event.entityLiving.func_70090_H()) {
                Vec3 desVec;
                double sinkSp = 0.2;
                Vec3 srcVec = Vec3.func_72443_a((double)event.entityLiving.field_70165_t, (double)event.entityLiving.field_70137_T, (double)event.entityLiving.field_70161_v);
                MovingObjectPosition mop = event.entityLiving.field_70170_p.func_72933_a(srcVec, desVec = srcVec.func_72441_c(0.0, -sinkSp, 0.0));
                if (mop == null) {
                    event.entityLiving.field_70137_T -= sinkSp;
                }
                event.entityLiving.func_70634_a(event.entityLiving.field_70165_t, event.entityLiving.field_70137_T, event.entityLiving.field_70161_v);
                event.entityLiving.field_70181_x = -sinkSp;
            }
        }
        if (!(event.entityLiving instanceof EntityPlayer)) return;
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (player.func_70608_bn() && !player.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)player.field_70165_t);
            int j = MathHelper.func_76128_c((double)player.field_70163_u) + 1;
            int k = MathHelper.func_76128_c((double)player.field_70161_v);
            if (player.field_70170_p.func_72896_J() && player.field_70170_p.func_72937_j(i, j, k)) {
                player.func_70999_a(true, true, false);
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)("You can't sleep outside while it's " + (player.field_70170_p.func_72858_w(i, j, k) ? "snow" : "rain") + "ing")));
            }
        }
        ItemStack item = null;
        int itemUse = 0;
        if (((EntityPlayer)event.entityLiving).func_70608_bn() && tracker != null) {
            tracker.sleepState = "Asleep";
            tracker.lastSleepTime = (int)event.entityLiving.field_70170_p.func_72912_H().func_76073_f() % 24000;
        } else if (tracker != null) {
            int relitiveTime = (int)event.entityLiving.field_70170_p.func_72912_H().func_76073_f() % 24000;
            if (tracker.sleepState.equals("Asleep") && tracker.lastSleepTime - relitiveTime > 100) {
                int timeSlept = MathHelper.func_76141_d((float)(100 * (12000 - (tracker.lastSleepTime - 12000)) / 12000));
                if (tracker.sanity + (float)timeSlept > 100.0f) {
                    tracker.sanity = 100.0f;
                    if (tracker.bodyTemp < 37.0f) {
                        tracker.bodyTemp = 37.0f;
                    }
                } else if (timeSlept >= 0) {
                    tracker.sanity += (float)timeSlept;
                    if (tracker.bodyTemp < 37.0f) {
                        tracker.bodyTemp = 37.0f;
                    }
                } else {
                    EnviroMine.logger.log(Level.SEVERE, "Something went wrong while calculating sleep sanity gain! Result: " + timeSlept);
                    tracker.sanity = 100.0f;
                    if (tracker.trackedEntity instanceof EntityPlayer) {
                        ((EntityPlayer)tracker.trackedEntity).func_70006_a(ChatMessageComponent.func_111066_d((String)(EnumChatFormatting.RED + "[ENVIROMINE] Sleep state failed to detect sleep time properly!")));
                        ((EntityPlayer)tracker.trackedEntity).func_70006_a(ChatMessageComponent.func_111066_d((String)(EnumChatFormatting.RED + "[ENVIROMINE] Defaulting to 100%")));
                    }
                }
            }
            tracker.sleepState = "Awake";
        }
        if (((EntityPlayer)event.entityLiving).func_71039_bw()) {
            item = ((EntityPlayer)event.entityLiving).func_70694_bm();
            itemUse = tracker != null ? tracker.getAndIncrementItemUse() : 0;
        } else {
            item = null;
            if (tracker != null) {
                tracker.resetItemUse();
            } else {
                itemUse = 0;
            }
        }
        if (item == null || tracker == null || itemUse < Item.field_77698_e[item.field_77993_c].func_77626_a(item) - 1) return;
        itemUse = 0;
        if (EM_Settings.itemProperties.containsKey("" + item.field_77993_c) || EM_Settings.itemProperties.containsKey("" + item.field_77993_c + "," + item.func_77960_j())) {
            ItemProperties itemProps = EM_Settings.itemProperties.containsKey("" + item.field_77993_c + "," + item.func_77960_j()) ? EM_Settings.itemProperties.get("" + item.field_77993_c + "," + item.func_77960_j()) : EM_Settings.itemProperties.get("" + item.field_77993_c);
            if (itemProps.effTemp > 0.0f) {
                if (tracker.bodyTemp + itemProps.effTemp > itemProps.effTempCap) {
                    if (tracker.bodyTemp <= itemProps.effTempCap) {
                        tracker.bodyTemp = itemProps.effTempCap;
                    }
                } else {
                    tracker.bodyTemp += itemProps.effTemp;
                }
            } else if (tracker.bodyTemp + itemProps.effTemp < itemProps.effTempCap) {
                if (tracker.bodyTemp >= itemProps.effTempCap) {
                    tracker.bodyTemp = itemProps.effTempCap;
                }
            } else {
                tracker.bodyTemp += itemProps.effTemp;
            }
            tracker.sanity = tracker.sanity + itemProps.effSanity >= 100.0f ? 100.0f : (tracker.sanity + itemProps.effSanity <= 0.0f ? 0.0f : (tracker.sanity += itemProps.effSanity));
            if (itemProps.effHydration > 0.0f) {
                tracker.hydrate(itemProps.effHydration);
            } else if (itemProps.effHydration < 0.0f) {
                tracker.dehydrate(Math.abs(itemProps.effHydration));
            }
            tracker.airQuality = tracker.airQuality + itemProps.effAir >= 100.0f ? 100.0f : (tracker.airQuality + itemProps.effAir <= 0.0f ? 0.0f : (tracker.airQuality += itemProps.effAir));
            return;
        } else if (item.field_77993_c == Item.field_77778_at.field_77779_bT) {
            if (item.func_77951_h()) {
                tracker.hydration = 100.0f;
                tracker.sanity = 100.0f;
                tracker.airQuality = 100.0f;
                tracker.bodyTemp = 37.0f;
                if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
                    EM_StatusManager.syncMultiplayerTracker(tracker);
                }
            } else {
                tracker.sanity = 100.0f;
                tracker.hydrate(10.0f);
            }
            tracker.trackedEntity.func_82170_o(EnviroPotion.frostbite.field_76415_H);
            tracker.frostbiteLevel = 0;
            return;
        } else if (item.field_77993_c == Item.field_77671_F.field_77779_bT || item.field_77993_c == Item.field_82791_bT.field_77779_bT) {
            if (tracker.bodyTemp <= 40.0f) {
                tracker.bodyTemp += 0.05f;
            }
            tracker.hydrate(5.0f);
            return;
        } else if (item.field_77993_c == Item.field_77771_aG.field_77779_bT) {
            tracker.hydrate(10.0f);
            return;
        } else if (item.field_77993_c == Item.field_77782_ar.field_77779_bT || item.field_77993_c == Item.field_77734_bj.field_77779_bT || item.field_77993_c == Item.field_77736_bl.field_77779_bT || item.field_77993_c == Item.field_82795_bM.field_77779_bT) {
            if (tracker.bodyTemp <= 40.0f) {
                tracker.bodyTemp += 0.05f;
            }
            if (EnviroMine.proxy.isClient() && !EnviroMine.proxy.isOpenToLAN()) return;
            EM_StatusManager.syncMultiplayerTracker(tracker);
            return;
        } else if (item.field_77993_c == Item.field_77706_j.field_77779_bT) {
            tracker.hydrate(5.0f);
            return;
        } else {
            if (item.field_77993_c != Item.field_77737_bm.field_77779_bT && item.field_77993_c != Item.field_77728_bu.field_77779_bT && item.field_77993_c != Item.field_82800_bN.field_77779_bT) return;
            tracker.dehydrate(5.0f);
            tracker.sanity = tracker.sanity <= 1.0f ? 0.0f : (tracker.sanity -= 1.0f);
        }
    }

    @ForgeSubscribe
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        if (event.entityPlayer.func_70608_bn() || !event.entityPlayer.func_70089_S()) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_73011_w.func_76567_e()) {
            return;
        }
        if (event.entityPlayer.field_70170_p.func_72935_r()) {
            return;
        }
        if (Math.abs(event.entityPlayer.field_70165_t - (double)event.x) > 3.0 || Math.abs(event.entityPlayer.field_70163_u - (double)event.y) > 2.0 || Math.abs(event.entityPlayer.field_70161_v - (double)event.z) > 3.0) {
            return;
        }
        double d0 = 8.0;
        double d1 = 5.0;
        List list = event.entityPlayer.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72332_a().func_72299_a((double)event.x - d0, (double)event.y - d1, (double)event.z - d0, (double)event.x + d0, (double)event.y + d1, (double)event.z + d0));
        if (!list.isEmpty()) {
            return;
        }
        if (event.entityPlayer.field_70170_p.func_72937_j(event.x, event.y, event.z) && event.entityPlayer.field_70170_p.func_72896_J()) {
            event.result = EnumStatus.OTHER_PROBLEM;
            event.entityPlayer.func_70006_a(ChatMessageComponent.func_111066_d((String)("You can't sleep outside while it's " + (event.entityPlayer.field_70170_p.func_72858_w(event.x, event.y, event.z) ? "snow" : "rain") + "ing")));
        }
    }

    @ForgeSubscribe
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving.func_70644_a((Potion)EnviroPotion.frostbite) && event.entityLiving.func_70660_b((Potion)EnviroPotion.frostbite).func_76458_c() > 0) {
            event.entityLiving.field_70181_x = 0.0;
        }
    }

    @ForgeSubscribe
    public void onLand(LivingFallEvent event) {
        if (event.entityLiving.func_70681_au().nextInt(5) == 0) {
            EM_PhysManager.schedulePhysUpdate(event.entityLiving.field_70170_p, MathHelper.func_76128_c((double)event.entityLiving.field_70165_t), MathHelper.func_76128_c((double)(event.entityLiving.field_70163_u - 1.0)), MathHelper.func_76128_c((double)event.entityLiving.field_70161_v), true, "Jump");
        }
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (EM_PhysManager.worldStartTime < 0L) {
            EM_PhysManager.worldStartTime = event.world.func_82737_E();
        }
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        EM_StatusManager.saveAndDeleteWorldTrackers(event.world);
        if (!event.world.field_72995_K && !MinecraftServer.func_71276_C().func_71278_l()) {
            EM_PhysManager.physSchedule.clear();
            EM_PhysManager.excluded.clear();
            EM_PhysManager.usedSlidePositions.clear();
            EM_PhysManager.worldStartTime = -1L;
            EM_PhysManager.chunkDelay.clear();
        }
    }

    @ForgeSubscribe
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (!EM_PhysManager.chunkDelay.containsKey("" + event.getChunk().field_76635_g + "," + event.getChunk().field_76647_h)) {
            EM_PhysManager.chunkDelay.put("" + event.getChunk().field_76635_g + "," + event.getChunk().field_76647_h, event.world.func_82737_E() + (long)EM_Settings.chunkDelay);
        }
    }

    @ForgeSubscribe
    public void onWorldSave(WorldEvent.Save event) {
        EM_StatusManager.saveAllWorldTrackers(event.world);
    }

    protected static MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + (double)(par1World.field_72995_K ? par2EntityPlayer.func_70047_e() - par2EntityPlayer.getDefaultEyeHeight() : par2EntityPlayer.func_70047_e());
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 vec3 = par1World.func_82732_R().func_72345_a(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_72831_a(vec3, vec31, par3, !par3);
    }
}

