/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers;

import com.google.common.base.Stopwatch;
import enviromine.EntityPhysicsBlock;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.gui.EM_GuiEnviroMeters;
import enviromine.trackers.BlockProperties;
import enviromine.trackers.StabilityType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockGlowStone;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;

public class EM_PhysManager {
    public static ArrayList<String> usedSlidePositions = new ArrayList();
    public static HashMap<String, String> excluded = new HashMap();
    public static ArrayList<Object[]> physSchedule = new ArrayList();
    public static HashMap<String, Long> chunkDelay = new HashMap();
    public static int currentTime = 0;
    public static int debugInterval = 15;
    public static int debugTime = 0;
    public static int debugUpdatesCaptured = 0;
    private static Stopwatch timer = new Stopwatch();
    public static long worldStartTime = -1L;

    public static void schedulePhysUpdate(World world, int x, int y, int z, boolean updateSelf, String type) {
        if (world.field_72995_K || world.func_82737_E() < worldStartTime + (long)EM_Settings.worldDelay) {
            return;
        }
        if (chunkDelay.containsKey("" + (x >> 4) + "," + (z >> 4)) && chunkDelay.get("" + (x >> 4) + "," + (z >> 4)) > world.func_82737_E()) {
            return;
        }
        Object[] entry = new Object[]{world, x, y, z, updateSelf, type};
        physSchedule.add(entry);
    }

    public static void scheduleSlideUpdate(World world, int x, int y, int z) {
        if (world.field_72995_K || world.func_82737_E() < worldStartTime + (long)EM_Settings.worldDelay) {
            return;
        }
        if (chunkDelay.containsKey("" + (x >> 4) + "," + (z >> 4)) && chunkDelay.get("" + (x >> 4) + "," + (z >> 4)) > world.func_82737_E()) {
            return;
        }
        if (world.func_72799_c(x, y, z)) {
            return;
        }
        Object[] entry = new Object[]{world, x, y, z, true, "Slide"};
        physSchedule.add(entry);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateSurroundingWithExclusions(World world, int x, int y, int z, boolean updateSelf, String type) {
        if (world.field_72995_K) {
            return;
        }
        int i = -1;
        block0: while (i <= 1) {
            int j = -1;
            while (true) {
                if (j <= 1) {
                } else {
                    ++i;
                    continue block0;
                }
                for (int k = -1; k <= 1; ++k) {
                    block11: {
                        if (timer.elapsed(TimeUnit.SECONDS) > 2L) {
                            return;
                        }
                        String position = x + i + "," + (y + j) + "," + (z + k);
                        if (i == 0 && j == 0 && k == 0) {
                            if (updateSelf) {
                                EM_PhysManager.callPhysUpdate(world, x + i, y + j, k + z, type);
                                break block11;
                            } else {
                                excluded.put(position, type);
                                continue;
                            }
                        }
                        EM_PhysManager.callPhysUpdate(world, x + i, y + j, k + z, type);
                    }
                    if (physSchedule.size() > 0) continue;
                    return;
                }
                ++j;
            }
            break;
        }
        return;
    }

    public static void callPhysUpdate(World world, int x, int y, int z, String type) {
        if (world.field_72995_K) {
            return;
        }
        EM_PhysManager.callPhysUpdate(world, x, y, z, Block.field_71973_m[world.func_72798_a(x, y, z)], world.func_72805_g(x, y, z), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void callPhysUpdate(World world, int x, int y, int z, Block block, int meta, String type) {
        String position = x + "," + y + "," + z;
        if (excluded.containsKey(position)) {
            if (excluded.get(position).equals("Collapse") || !type.equals("Collapse")) return;
            excluded.put(position, type);
        } else {
            excluded.put(position, type);
        }
        boolean locLoaded = false;
        locLoaded = world.func_72863_F().func_73149_a(x >> 4, z >> 4) ? world.func_72964_e((int)(x >> 4), (int)(z >> 4)).field_76636_d : false;
        if (world.field_72995_K || block == null || !locLoaded) {
            return;
        }
        if (EnviroMine.proxy.isClient()) {
            ++debugUpdatesCaptured;
        }
        int[] blockData = EM_PhysManager.getSurroundingBlockData(world, x, y, z);
        boolean waterLogged = false;
        boolean isMuddy = false;
        boolean touchingWaterDirect = blockData[2] > 0;
        boolean touchingWater = blockData[3] > 0;
        BlockProperties blockProps = null;
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk != null) {
            waterLogged = chunk.func_76591_a((int)(x & 0xF), (int)(z & 0xF), (WorldChunkManager)world.func_72959_q()).field_76751_G > 0.0f && world.func_72896_J() && world.func_72937_j(x, y + 1, z) || touchingWater;
        }
        boolean validSlideType = false;
        boolean emptyBelow = BlockSand.func_72191_e_((World)world, (int)x, (int)(y - 1), (int)z);
        if (EM_Settings.blockProperties.containsKey("" + block.field_71990_ca + "," + world.func_72805_g(x, y, z)) || EM_Settings.blockProperties.containsKey("" + block.field_71990_ca)) {
            blockProps = EM_Settings.blockProperties.containsKey("" + block.field_71990_ca + "," + world.func_72805_g(x, y, z)) ? EM_Settings.blockProperties.get("" + block.field_71990_ca + "," + world.func_72805_g(x, y, z)) : EM_Settings.blockProperties.get("" + block.field_71990_ca);
            validSlideType = blockProps.slides || (waterLogged || touchingWater) && blockProps.wetSlide;
            isMuddy = (waterLogged || touchingWater) && blockProps.wetSlide;
        } else if (block instanceof BlockSand || (block.field_71990_ca == Block.field_71979_v.field_71990_ca || block.field_71990_ca == Block.field_72039_aU.field_71990_ca) && (waterLogged || touchingWater)) {
            if (block instanceof BlockAnvil) {
                validSlideType = false;
            } else {
                validSlideType = true;
                boolean bl = isMuddy = block.field_71990_ca == Block.field_71979_v.field_71990_ca || block.field_71990_ca == Block.field_72039_aU.field_71990_ca;
            }
        }
        if (validSlideType && EM_Settings.enableLandslide) {
            if (!(block instanceof BlockSand) && blockData[4] >= 1) {
                return;
            }
            int slideID = block.field_71990_ca;
            int slideMeta = meta;
            int[] pos = new int[]{x, y, z};
            int[] npos = EM_PhysManager.slideDirection(world, pos, true);
            int[] ppos = EM_PhysManager.slideDirection(world, pos, false);
            TileEntity tile = world.func_72796_p(x, y, z);
            NBTTagCompound nbtTC = new NBTTagCompound();
            if (tile != null) {
                tile.func_70310_b(nbtTC);
            }
            if (emptyBelow) {
                if (!(block instanceof BlockSand) && !usedSlidePositions.contains("" + pos[0] + "," + pos[2])) {
                    EntityPhysicsBlock physBlock = new EntityPhysicsBlock(world, (double)pos[0] + 0.5, (double)pos[1] + 0.5, (double)pos[2] + 0.5, slideID, slideMeta, false);
                    if (tile != null) {
                        physBlock.field_98051_e = nbtTC;
                    }
                    world.func_94575_c(x, y, z, 0);
                    physBlock.isLandSlide = true;
                    world.func_72838_d((Entity)physBlock);
                    EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Collapse");
                    return;
                }
            } else {
                if (!(pos[0] == npos[0] && pos[1] == npos[1] && pos[2] == npos[2] || usedSlidePositions.contains("" + npos[0] + "," + npos[2]))) {
                    EntityPhysicsBlock physBlock = new EntityPhysicsBlock(world, (double)npos[0] + 0.5, (double)npos[1] + 0.5, (double)npos[2] + 0.5, slideID, slideMeta, false);
                    if (tile != null) {
                        physBlock.field_98051_e = nbtTC;
                    }
                    world.func_94575_c(x, y, z, 0);
                    physBlock.isLandSlide = true;
                    world.func_72838_d((Entity)physBlock);
                    EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Collapse");
                    return;
                }
                if (pos[0] != ppos[0] || pos[1] != ppos[1] || pos[2] != ppos[2]) {
                    EM_PhysManager.scheduleSlideUpdate(world, x, y, z);
                }
            }
        }
        if (!EM_PhysManager.isLegalType(world, x, y, z) || !EM_PhysManager.blockNotSolid(world, x, y - 1, z, false) || blockData[4] > 0) return;
        int dropBlock = block.field_71990_ca;
        int dropMeta = -1;
        int dropNum = -1;
        int dropType = 0;
        boolean isCustom = false;
        boolean defaultDrop = true;
        if (blockProps != null) {
            isCustom = true;
            defaultDrop = false;
            if (blockProps.dropID < 0) {
                dropType = 1;
                defaultDrop = true;
                dropNum = blockProps.dropNum;
            } else if (blockProps.dropID == 0) {
                dropType = 0;
                dropBlock = 0;
                dropMeta = 0;
                dropNum = 0;
            } else if (Block.field_71973_m[blockProps.dropID] != null && blockProps.dropNum <= 0) {
                dropType = 1;
                dropBlock = blockProps.dropID;
                dropMeta = blockProps.dropMeta <= -1 ? -1 : blockProps.dropMeta;
                dropNum = 0;
            } else if (Item.field_77698_e[blockProps.dropID] != null && blockProps.dropNum > 0) {
                dropType = 2;
                dropBlock = blockProps.dropID;
                dropMeta = blockProps.dropMeta <= -1 ? -1 : blockProps.dropMeta;
                dropNum = blockProps.dropNum;
            } else {
                dropType = 0;
                dropBlock = 0;
                dropMeta = -1;
                dropNum = -1;
            }
        }
        if (defaultDrop) {
            if (dropBlock <= 0 || block.field_72018_cp == Material.field_76264_q || block.field_72018_cp == Material.field_76260_u) {
                dropType = 0;
            } else if (dropBlock >= Block.field_71973_m.length) {
                dropType = dropBlock >= Item.field_77698_e.length ? 0 : (Item.field_77698_e[dropBlock] == null ? 0 : 2);
            } else if (Block.field_71973_m[dropBlock] == null && Item.field_77698_e[dropBlock] == null) {
                dropType = 0;
            } else if (Item.field_77698_e[dropBlock] != null && !(Item.field_77698_e[dropBlock] instanceof ItemBlock)) {
                dropType = 2;
            } else if (Block.field_71973_m[dropBlock] != null) {
                dropType = Block.field_71973_m[block.field_71990_ca] instanceof BlockLeavesBase ? 2 : 1;
            }
        }
        int minThreshold = 10;
        int maxThreshold = 15;
        int supportDist = 1;
        int yMax = 1;
        int stabNum = EM_PhysManager.getDefaultStabilityType(block);
        if (isCustom) {
            minThreshold = blockProps.minFall;
            maxThreshold = blockProps.maxFall;
            supportDist = blockProps.supportDist;
            yMax = blockProps.canHang ? 2 : 1;
        } else if (stabNum == 3) {
            StabilityType strongType = EM_Settings.stabilityTypes.get("strong");
            minThreshold = strongType.minFall;
            maxThreshold = strongType.maxFall;
            supportDist = strongType.supportDist;
            yMax = strongType.canHang ? 2 : 1;
        } else if (stabNum == 2) {
            StabilityType avgType = EM_Settings.stabilityTypes.get("average");
            minThreshold = avgType.minFall;
            maxThreshold = avgType.maxFall;
            supportDist = avgType.supportDist;
            yMax = avgType.canHang ? 2 : 1;
        } else if (stabNum == 1) {
            StabilityType looseType = block.field_71990_ca > 175 && EM_Settings.stabilityTypes.containsKey(EM_Settings.defaultStability) ? EM_Settings.stabilityTypes.get(EM_Settings.defaultStability) : EM_Settings.stabilityTypes.get("loose");
            minThreshold = looseType.minFall;
            maxThreshold = looseType.maxFall;
            supportDist = looseType.supportDist;
            yMax = looseType.canHang ? 2 : 1;
        }
        if (world.field_73011_w.field_76575_d && block.field_72018_cp == Material.field_76246_e && !isCustom) {
            yMax = 2;
        }
        int missingBlocks = 0;
        missingBlocks = yMax >= 2 ? blockData[0] : blockData[1];
        int dropChance = maxThreshold - missingBlocks;
        if (dropChance <= 0) {
            dropChance = 1;
        }
        boolean supported = EM_PhysManager.hasSupports(world, x, y, z, touchingWaterDirect || isMuddy ? MathHelper.func_76128_c((double)((double)supportDist / 2.0)) : supportDist);
        if (missingBlocks <= 0 || !EM_PhysManager.blockNotSolid(world, x, y - 1, z, false) || supported) return;
        if (!world.field_72995_K && (missingBlocks > minThreshold && (world.field_73012_v.nextInt(dropChance) == 0 || type.equals("Collapse")) || missingBlocks >= maxThreshold || (touchingWaterDirect || isMuddy) && world.field_73012_v.nextBoolean())) {
            if (dropType == 2) {
                world.func_72926_e(2001, x, y, z, block.field_71990_ca + (world.func_72805_g(x, y, z) << 12));
                if (isCustom && dropMeta > -1) {
                    if (dropNum >= 1) {
                        EM_PhysManager.dropItemstack(world, x, y, z, new ItemStack(dropBlock, dropNum, dropMeta));
                    }
                } else if (isCustom && dropNum >= 1) {
                    EM_PhysManager.dropItemstack(world, x, y, z, new ItemStack(dropBlock, dropNum, meta));
                } else if (!isCustom || isCustom && dropMeta <= -1 && dropNum > 0) {
                    block.func_71897_c(world, x, y, z, meta, 0);
                }
                world.func_94575_c(x, y, z, 0);
                EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Normal");
                return;
            }
            if (dropType == 0) {
                world.func_72926_e(2001, x, y, z, block.field_71990_ca + (world.func_72805_g(x, y, z) << 12));
                if (block.field_71990_ca == Block.field_72036_aT.field_71990_ca) {
                    Material mat = world.func_72803_f(x, y - 1, z);
                    if ((mat.func_76230_c() || mat.func_76224_d()) && !world.field_73011_w.field_76575_d) {
                        world.func_94575_c(x, y, z, Block.field_71942_A.field_71990_ca);
                    } else {
                        world.func_94575_c(x, y, z, 0);
                    }
                } else {
                    world.func_94575_c(x, y, z, 0);
                }
                if (block.field_72018_cp == Material.field_76260_u && !EM_Settings.spreadIce) return;
                EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Break");
                return;
            }
            if (dropType != 1) {
                return;
            }
            if (block.field_71990_ca == Block.field_71981_t.field_71990_ca && EM_Settings.stoneCracks && !isCustom) {
                world.func_94575_c(x, y, z, Block.field_71978_w.field_71990_ca);
                dropBlock = Block.field_71978_w.field_71990_ca;
            } else if (block.field_71990_ca == Block.field_71980_u.field_71990_ca && !isCustom) {
                world.func_94575_c(x, y, z, Block.field_71979_v.field_71990_ca);
                dropBlock = Block.field_71979_v.field_71990_ca;
            } else if (world.func_72798_a(x, y, z) != dropBlock) {
                world.func_72832_d(x, y, z, dropBlock, world.func_72805_g(x, y, z), 2);
            }
            TileEntity tile = world.func_72796_p(x, y, z);
            NBTTagCompound nbtTC = new NBTTagCompound();
            if (tile != null) {
                tile.func_70310_b(nbtTC);
            }
            EntityPhysicsBlock entityphysblock = isCustom && dropMeta > -1 ? new EntityPhysicsBlock(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, dropBlock, dropMeta, true) : new EntityPhysicsBlock(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, dropBlock, world.func_72805_g(x, y, z), true);
            if (tile != null) {
                entityphysblock.field_98051_e = nbtTC;
                world.func_72932_q(x, y, z);
            }
            world.func_72838_d((Entity)entityphysblock);
            return;
        } else {
            if (missingBlocks <= minThreshold || world.field_72995_K || !EM_Settings.stoneCracks) return;
            if (block.field_71990_ca == Block.field_71981_t.field_71990_ca && !isCustom) {
                world.func_94575_c(x, y, z, Block.field_71978_w.field_71990_ca);
                return;
            } else {
                if (block.field_71990_ca != Block.field_71980_u.field_71990_ca || isCustom) return;
                world.func_94575_c(x, y, z, Block.field_71979_v.field_71990_ca);
            }
        }
    }

    public static int[] getSurroundingBlockData(World world, int x, int y, int z) {
        int[] data = new int[]{0, 0, 0, 0, 0};
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                for (int k = z - 1; k <= z + 1; ++k) {
                    StabilityType looseType;
                    Material material = world.func_72803_f(i, j, k);
                    int blockID = world.func_72798_a(i, j, k);
                    int metaID = world.func_72805_g(i, j, k);
                    Block block = Block.field_71973_m[blockID];
                    if (blockID == 0) {
                        if (j < y + 1) {
                            data[1] = data[1] + 1;
                        }
                        data[0] = data[0] + 1;
                        continue;
                    }
                    int stabNum = EM_PhysManager.getDefaultStabilityType(block);
                    if (material != null && material.func_76224_d()) {
                        if (j > y && (i != x || k != z)) {
                            data[3] = data[3] + 1;
                        } else if (j == y && i == x && k == z) {
                            data[3] = data[3] + 1;
                        } else if (j == y && i != x && k != z) {
                            data[3] = data[3] + 1;
                        } else {
                            data[2] = data[2] + 1;
                            data[3] = data[3] + 1;
                        }
                    }
                    BlockProperties blockProps = null;
                    if (EM_Settings.blockProperties.containsKey("" + blockID) || EM_Settings.blockProperties.containsKey("" + blockID + "," + metaID)) {
                        if (EM_Settings.blockProperties.containsKey("" + blockID + "," + metaID)) {
                            blockProps = EM_Settings.blockProperties.get("" + blockID + "," + metaID);
                        } else if (EM_Settings.blockProperties.containsKey("" + blockID)) {
                            blockProps = EM_Settings.blockProperties.get("" + blockID);
                        }
                    }
                    if (blockProps != null) {
                        if (blockProps.holdsOthers) {
                            data[4] = 1;
                        }
                    } else if (stabNum == 3) {
                        StabilityType strongType = EM_Settings.stabilityTypes.get("strong");
                        if (strongType != null && strongType.holdOther) {
                            data[4] = 1;
                        }
                    } else if (stabNum == 2) {
                        StabilityType avgType = EM_Settings.stabilityTypes.get("average");
                        if (avgType != null && avgType.holdOther) {
                            data[4] = 1;
                        }
                    } else if (stabNum == 1 && (looseType = block.field_71990_ca > 175 && EM_Settings.stabilityTypes.containsKey(EM_Settings.defaultStability) ? EM_Settings.stabilityTypes.get(EM_Settings.defaultStability) : EM_Settings.stabilityTypes.get("loose")) != null && looseType.holdOther) {
                        data[4] = 1;
                    }
                    if (blockProps == null && blockID == Block.field_72014_bd.field_71990_ca) {
                        data[4] = 1;
                    }
                    if (world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1))).size() > 0) {
                        if (j < y + 1) {
                            data[1] = data[1] + 1;
                        }
                        data[0] = data[0] + 1;
                        continue;
                    }
                    if (!EM_PhysManager.blockNotSolid(world, i, j, k, false) && (world.func_72803_f(x, y, z) == Material.field_76257_i || material != Material.field_76257_i) || i == x && j < y + 1 && k == z) continue;
                    if (j < y + 1) {
                        data[1] = data[1] + 1;
                    }
                    data[0] = data[0] + 1;
                }
            }
        }
        data[1] = data[1] + 9;
        return data;
    }

    public static boolean hasSupports(World world, int x, int y, int z, int dist) {
        int i;
        int k;
        int j;
        boolean cancel;
        int k2;
        int i2;
        if (dist <= 0) {
            return false;
        }
        boolean isLeaves = world.func_72803_f(x, y, z) == Material.field_76257_i;
        for (i2 = x - 1; i2 <= x + 1; ++i2) {
            for (k2 = z - 1; k2 <= z + 1; ++k2) {
                int j2 = y - 1;
                if (EM_PhysManager.blockNotSolid(world, i2, j2, k2, false) || world.func_72803_f(i2, j2, k2) == Material.field_76257_i && !isLeaves) continue;
                return true;
            }
        }
        for (i2 = x + 1; i2 <= x + dist; ++i2) {
            k2 = z;
            cancel = false;
            for (j = y - 1; j <= y; ++j) {
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i2, j, k2, false) && (world.func_72803_f(i2, j, k2) != Material.field_76257_i || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i2, j, k2, false) || world.func_72803_f(i2, j, k2) == Material.field_76257_i && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        for (i2 = x - 1; i2 >= x - dist; --i2) {
            k2 = z;
            cancel = false;
            for (j = y - 1; j <= y; ++j) {
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i2, j, k2, false) && (world.func_72803_f(i2, j, k2) != Material.field_76257_i || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i2, j, k2, false) || world.func_72803_f(i2, j, k2) == Material.field_76257_i && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        for (k = z + 1; k <= z + dist; ++k) {
            i = x;
            cancel = false;
            for (j = y - 1; j <= y; ++j) {
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i, j, k, false) && (world.func_72803_f(i, j, k) != Material.field_76257_i || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i, j, k, false) || world.func_72803_f(i, j, k) == Material.field_76257_i && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        for (k = z - 1; k >= z - dist; --k) {
            i = x;
            cancel = false;
            for (j = y - 1; j <= y; ++j) {
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i, j, k, false) && (world.func_72803_f(i, j, k) != Material.field_76257_i || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i, j, k, false) || world.func_72803_f(i, j, k) == Material.field_76257_i && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        return false;
    }

    protected static void dropItemstack(World par1World, int par2, int par3, int par4, ItemStack par5ItemStack) {
        if (!par1World.field_72995_K && par1World.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(par1World.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(par1World.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(par1World.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(par1World, (double)par2 + d0, (double)par3 + d1, (double)par4 + d2, par5ItemStack);
            entityitem.field_70293_c = 10;
            par1World.func_72838_d((Entity)entityitem);
        }
    }

    public static boolean isLegalType(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0 || Block.field_71973_m[id] == null) {
            return false;
        }
        if (EM_Settings.blockProperties.containsKey("" + id + "," + meta) || EM_Settings.blockProperties.containsKey("" + id)) {
            if (EM_Settings.blockProperties.containsKey("" + id + "," + meta)) {
                BlockProperties blockProps = EM_Settings.blockProperties.get("" + id + "," + meta);
                return blockProps.hasPhys && !blockProps.holdsOthers;
            }
            BlockProperties blockProps = EM_Settings.blockProperties.get("" + id);
            return blockProps.hasPhys && !blockProps.holdsOthers;
        }
        if (!(Block.field_71973_m[id] instanceof BlockMobSpawner || Block.field_71973_m[id] instanceof BlockLadder || Block.field_71973_m[id] instanceof BlockWeb || Block.field_71973_m[id] instanceof BlockGlowStone || Block.field_71973_m[id] instanceof BlockSign || Block.field_71973_m[id] instanceof BlockBed || Block.field_71973_m[id] instanceof BlockDoor || Block.field_71973_m[id] instanceof BlockAnvil || Block.field_71973_m[id] instanceof BlockGravel || Block.field_71973_m[id] instanceof BlockSand || Block.field_71973_m[id] instanceof BlockPortal || Block.field_71973_m[id] instanceof BlockEndPortal || Block.field_71973_m[id] == Block.field_72082_bJ || Block.field_71973_m[id] instanceof BlockEndPortalFrame || Block.field_71973_m[id].field_72018_cp == Material.field_76255_k || EM_PhysManager.blockNotSolid(world, x, y, z, false) || Block.field_71973_m[id].field_71989_cb == -1.0f)) {
            int stabNum = EM_PhysManager.getDefaultStabilityType(Block.field_71973_m[id]);
            if (stabNum == 3) {
                StabilityType strongType = EM_Settings.stabilityTypes.get("strong");
                return strongType != null && strongType.enablePhysics;
            }
            if (stabNum == 2) {
                StabilityType avgType = EM_Settings.stabilityTypes.get("average");
                return avgType != null && avgType.enablePhysics;
            }
            if (stabNum == 1) {
                StabilityType looseType = id > 175 && EM_Settings.stabilityTypes.containsKey(EM_Settings.defaultStability) ? EM_Settings.stabilityTypes.get(EM_Settings.defaultStability) : EM_Settings.stabilityTypes.get("loose");
                return looseType != null && looseType.enablePhysics;
            }
            return false;
        }
        return false;
    }

    public static boolean blockNotSolid(World world, int x, int y, int z, boolean isSliding) {
        if (world.func_72799_c(x, y, z)) {
            return true;
        }
        int l = world.func_72798_a(x, y, z);
        Material material = Block.field_71973_m[l].field_72018_cp;
        if (l == Block.field_72067_ar.field_71990_ca) {
            return true;
        }
        if (material == Material.field_76244_g || material == Material.field_76256_h) {
            return !isSliding;
        }
        return Block.field_71973_m[l].func_71872_e(world, x, y, z) == null;
    }

    public static void updateSchedule() {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        if (physSchedule.size() >= 4096 && EM_Settings.updateCap <= -1) {
            EnviroMine.logger.log(Level.SEVERE, "Physics updates exeeded 4096! Dumping update schedule");
            physSchedule.clear();
            return;
        }
        if (EnviroMine.proxy.isClient() && debugTime == 0) {
            if (!timer.isRunning()) {
                timer.reset();
                timer.start();
            }
            debugUpdatesCaptured = 0;
        }
        boolean canClear = true;
        if (currentTime >= EM_Settings.physInterval) {
            int updateNum = 0;
            updateNum = physSchedule.size() <= EM_Settings.updateCap || EM_Settings.updateCap < 0 ? physSchedule.size() : EM_Settings.updateCap;
            int updateRem = physSchedule.size();
            for (int i = updateNum - 1; i >= 0; --i) {
                if (!MinecraftServer.func_71276_C().func_71278_l()) {
                    physSchedule.clear();
                    physSchedule = new ArrayList();
                    canClear = true;
                    break;
                }
                if (EnviroMine.proxy.isClient() && Minecraft.func_71410_x().func_71387_A()) {
                    if (Minecraft.func_71410_x().func_71401_C().func_71343_a().func_71752_f() && !EnviroMine.proxy.isOpenToLAN()) {
                        if (!timer.isRunning()) break;
                        timer.stop();
                        debugTime = 0;
                        break;
                    }
                    if (!timer.isRunning()) {
                        timer.start();
                    }
                }
                if (timer.elapsed(TimeUnit.SECONDS) > 2L) {
                    EnviroMine.logger.log(Level.WARNING, "Physics updates are taking too long! Dumping schedule!");
                    physSchedule.clear();
                    canClear = false;
                    break;
                }
                if (physSchedule.size() - 1 < i) {
                    EnviroMine.logger.log(Level.WARNING, "Unable to get physcis schedule entry, index out of bounds! (Size: " + physSchedule.size() + ", Index: " + i + ")");
                    canClear = false;
                    break;
                }
                Object[] entry = physSchedule.get(i);
                boolean locLoaded = false;
                locLoaded = ((World)entry[0]).func_72863_F().func_73149_a((Integer)entry[1] >> 4, (Integer)entry[3] >> 4) ? ((World)entry[0]).func_72964_e((int)(((Integer)entry[1]).intValue() >> 4), (int)(((Integer)entry[3]).intValue() >> 4)).field_76636_d : false;
                if (locLoaded) {
                    canClear = false;
                    if (((String)entry[5]).equalsIgnoreCase("Slide")) {
                        String position = (Integer)entry[1] + "," + (Integer)entry[2] + "," + (Integer)entry[3];
                        if (!excluded.containsKey(position)) {
                            excluded.put(position, (String)entry[5]);
                            EM_PhysManager.callPhysUpdate((World)entry[0], (Integer)entry[1], (Integer)entry[2], (Integer)entry[3], (String)entry[5]);
                        }
                    } else {
                        EM_PhysManager.updateSurroundingWithExclusions((World)entry[0], (Integer)entry[1], (Integer)entry[2], (Integer)entry[3], (Boolean)entry[4], (String)entry[5]);
                    }
                }
                if (physSchedule.size() < updateRem) {
                    EnviroMine.logger.log(Level.WARNING, "Physics schedule dumped early! Resetting scheduler...");
                    physSchedule.clear();
                    canClear = false;
                    break;
                }
                if (physSchedule.size() - 1 >= i) {
                    physSchedule.remove(i);
                } else {
                    EnviroMine.logger.log(Level.WARNING, "Failed to remove entry from physics schedule. Things may break badly!");
                }
                updateRem = physSchedule.size();
            }
            currentTime = 0;
        } else {
            ++currentTime;
        }
        if (canClear) {
            excluded.clear();
            usedSlidePositions.clear();
        }
        if (EnviroMine.proxy.isClient() && debugTime >= debugInterval && timer.isRunning()) {
            timer.stop();
            EM_GuiEnviroMeters.DB_physTimer = timer.toString();
            EM_GuiEnviroMeters.DB_physUpdates = debugUpdatesCaptured;
            EM_GuiEnviroMeters.DB_physBuffer = physSchedule.size();
            timer.reset();
            debugTime = 0;
        } else if (EnviroMine.proxy.isClient()) {
            ++debugTime;
        }
    }

    public static int[] slideDirection(World world, int[] pos, boolean checkEntities) {
        if (pos.length != 3) {
            return pos;
        }
        int[] npos = new int[3];
        int x = pos[0];
        int y = pos[1];
        int z = pos[2];
        npos[0] = x;
        npos[1] = y;
        npos[2] = z;
        ArrayList<String> canSlideDir = new ArrayList<String>();
        if (EM_PhysManager.blockNotSolid(world, x + 1, y, z, true) && EM_PhysManager.blockNotSolid(world, x + 1, y - 1, z, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)(x + 1), (double)(y - 2), (double)z, (double)(x + 2), (double)y, (double)(z + 1))).size() <= 0)) {
            canSlideDir.add("X+");
        }
        if (EM_PhysManager.blockNotSolid(world, x - 1, y, z, true) && EM_PhysManager.blockNotSolid(world, x - 1, y - 1, z, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 2), (double)z, (double)x, (double)y, (double)(z + 1))).size() <= 0)) {
            canSlideDir.add("X-");
        }
        if (EM_PhysManager.blockNotSolid(world, x, y, z + 1, true) && EM_PhysManager.blockNotSolid(world, x, y - 1, z + 1, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)x, (double)(y - 2), (double)(z + 1), (double)(x + 1), (double)y, (double)(z + 2))).size() <= 0)) {
            canSlideDir.add("Z+");
        }
        if (EM_PhysManager.blockNotSolid(world, x, y, z - 1, true) && EM_PhysManager.blockNotSolid(world, x, y - 1, z - 1, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)x, (double)(y - 2), (double)(z - 1), (double)(x + 1), (double)y, (double)z)).size() <= 0)) {
            canSlideDir.add("Z-");
        }
        if (canSlideDir.size() >= 1) {
            String slideDir = "";
            slideDir = (String)canSlideDir.get(world.field_73012_v.nextInt(canSlideDir.size()));
            if (slideDir == "X+") {
                npos[0] = x + 1;
            } else if (slideDir == "X-") {
                npos[0] = x - 1;
            } else if (slideDir == "Z+") {
                npos[2] = z + 1;
            } else if (slideDir == "Z-") {
                npos[2] = z - 1;
            }
        }
        return npos;
    }

    public static int getDefaultStabilityType(Block block) {
        int type = 0;
        type = block.field_72018_cp == Material.field_76243_f || block.field_72018_cp == Material.field_76245_d || block instanceof BlockObsidian || block.field_71990_ca == Block.field_72007_bm.field_71990_ca || block.field_71990_ca == Block.field_72081_al.field_71990_ca || block.field_71990_ca == Block.field_94339_ct.field_71990_ca ? 3 : (block.field_72018_cp == Material.field_76246_e || block.field_72018_cp == Material.field_76264_q || block.field_72018_cp == Material.field_76260_u || block instanceof BlockLeavesBase ? 2 : 1);
        return type;
    }
}

