/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.iguanatweakstconstruct.IguanaItems;
import iguanaman.iguanatweakstconstruct.IguanaLevelingLogic;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.configs.IguanaConfig;
import iguanaman.iguanatweakstconstruct.configs.LevelsConfig;
import iguanaman.iguanatweakstconstruct.configs.ModifierConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import tconstruct.blocks.LiquidMetalFinite;
import tconstruct.common.TContent;
import tconstruct.items.tools.Battleaxe;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.items.tools.Shortbow;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.Weapon;

public class IguanaEventHandler {
    Random random = new Random();

    @ForgeSubscribe
    public void onItemExpireEvent(ItemExpireEvent event) {
        ItemStack stack;
        if (IguanaConfig.toolsNeverDespawn && event.entity != null && event.entity instanceof EntityItem && (stack = ((EntityItem)event.entity).func_92059_d()).func_77973_b() != null && stack.func_77973_b() instanceof ToolCore) {
            event.setResult(Event.Result.DENY);
        }
    }

    @ForgeSubscribe
    public void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if ((event.source.field_76373_n.equals("player") || event.source.field_76373_n.equals("arrow")) && event.source.func_76346_g() instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && (stack.func_77973_b() instanceof Weapon || stack.func_77973_b() instanceof Battleaxe || stack.func_77973_b() instanceof Shortbow && event.source.field_76373_n.equals("arrow"))) {
            long xp = Math.round(event.ammount);
            if (event.entityLiving instanceof EntityAnimal) {
                xp = Math.round(event.ammount / 4.0f);
            }
            if (xp > 0L) {
                IguanaLevelingLogic.addXP(stack, player, xp);
            }
        }
    }

    @ForgeSubscribe
    public void onUseHoe(UseHoeEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.current;
        if (stack != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
            IguanaLevelingLogic.addXP(stack, player, 1L);
        }
    }

    void addDrops(LivingDropsEvent event, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
        entityitem.field_70293_c = 10;
        event.drops.add(entityitem);
    }

    @ForgeSubscribe(priority=EventPriority.LOWEST)
    public void LivingDrops(LivingDropsEvent event) {
        Iterator i = event.drops.iterator();
        while (i.hasNext()) {
            EntityItem eitem = (EntityItem)i.next();
            if (eitem == null || eitem.func_92059_d() == null) continue;
            ItemStack item = eitem.func_92059_d();
            if (item.field_77993_c != Item.field_82799_bQ.field_77779_bT || item.func_77960_j() == 3) continue;
            i.remove();
        }
        if (event.recentlyHit && event.source.field_76373_n.equals("player")) {
            int skullID = -1;
            if (event.entityLiving instanceof EntitySkeleton) {
                skullID = ((EntitySkeleton)event.entityLiving).func_82202_m();
            } else if (event.entityLiving instanceof EntityPigZombie) {
                skullID = 6;
            } else if (event.entityLiving instanceof EntityZombie) {
                skullID = 2;
            } else if (event.entityLiving instanceof EntityCreeper) {
                skullID = 4;
            } else if (event.entityLiving instanceof EntityEnderman) {
                skullID = 5;
            } else if (event.entityLiving instanceof EntityBlaze) {
                skullID = 7;
            }
            if (skullID != -1) {
                EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
                ItemStack stack = player.func_71045_bC();
                int beheading = 0;
                if (stack != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                }
                if (this.random.nextInt(100) < beheading * IguanaConfig.beheadingHeadDropChance + IguanaConfig.baseHeadDropChance) {
                    this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, skullID));
                }
            }
        }
    }

    @ForgeSubscribe
    public void bucketFill(FillBucketEvent evt) {
        if (evt.current.func_77973_b() == IguanaItems.clayBucketFired && evt.target.field_72313_a == EnumMovingObjectType.TILE) {
            int hitX = evt.target.field_72311_b;
            int hitY = evt.target.field_72312_c;
            int hitZ = evt.target.field_72309_d;
            if (evt.entityPlayer != null && !evt.entityPlayer.func_82247_a(hitX, hitY, hitZ, evt.target.field_72310_e, evt.current)) {
                return;
            }
            int bID = evt.world.func_72798_a(hitX, hitY, hitZ);
            for (int id = 0; id < TContent.fluidBlocks.length; ++id) {
                if (bID != TContent.fluidBlocks[id].field_71990_ca) continue;
                if (evt.entityPlayer.field_71075_bZ.field_75098_d) {
                    evt.world.func_94571_i(hitX, hitY, hitZ);
                    continue;
                }
                if (TContent.fluidBlocks[id] instanceof LiquidMetalFinite) {
                    int localID;
                    int posZ;
                    int posX;
                    int quanta = 0;
                    for (posX = -1; posX <= 1; ++posX) {
                        for (posZ = -1; posZ <= 1; ++posZ) {
                            localID = evt.world.func_72798_a(hitX + posX, hitY, hitZ + posZ);
                            if (localID != bID) continue;
                            quanta += evt.world.func_72805_g(hitX + posX, hitY, hitZ + posZ) + 1;
                        }
                    }
                    if (quanta >= 8) {
                        while (quanta > 0) {
                            for (posX = -1; posX <= 1; ++posX) {
                                for (posZ = -1; posZ <= 1; ++posZ) {
                                    localID = evt.world.func_72798_a(hitX + posX, hitY, hitZ + posZ);
                                    if (localID != bID) continue;
                                    --quanta;
                                    int meta = evt.world.func_72805_g(hitX + posX, hitY, hitZ + posZ);
                                    if (meta > 0) {
                                        evt.world.func_72921_c(hitX + posX, hitY, hitZ + posZ, meta - 1, 3);
                                        continue;
                                    }
                                    evt.world.func_94571_i(hitX + posX, hitY, hitZ + posZ);
                                }
                            }
                        }
                    }
                } else {
                    evt.world.func_94571_i(hitX, hitY, hitZ);
                }
                evt.setResult(Event.Result.ALLOW);
                evt.result = new ItemStack(IguanaItems.clayBuckets, 1, id);
            }
        }
    }

    @ForgeSubscribe
    public void EntityInteract(EntityInteractEvent event) {
        ItemStack equipped;
        if (event != null && event.target != null && event.target instanceof EntityCow && (equipped = event.entityPlayer.func_71045_bC()) != null && equipped.field_77993_c == IguanaItems.clayBucketFired.field_77779_bT) {
            if (--equipped.field_77994_a <= 0) {
                event.entityPlayer.func_70062_b(0, new ItemStack(IguanaItems.clayBucketMilk));
            } else if (!event.entityPlayer.field_71071_by.func_70441_a(new ItemStack(IguanaItems.clayBucketMilk))) {
                event.entityPlayer.func_71021_b(new ItemStack(IguanaItems.clayBucketMilk));
            }
        }
    }

    @ForgeSubscribe
    public void craftTool(ToolCraftEvent.NormalTool event) {
        int extra;
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        int head = toolTag.func_74762_e("Head");
        int handle = toolTag.func_74762_e("Handle");
        int accessory = toolTag.func_74762_e("Accessory");
        int n = extra = toolTag.func_74764_b("Extra") ? toolTag.func_74762_e("Extra") : -1;
        if (!IguanaConfig.allowStoneTools && (head == 1 || handle == 1 || event.tool != TContent.arrow && accessory == 1 || extra == 1)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (IguanaConfig.allowStoneTools) {
            int partIndex;
            if (head == 1 && IguanaConfig.restrictedFlintParts.contains((partIndex = IguanaTweaksTConstruct.toolParts.indexOf(event.tool.getHeadItem())) + 1)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            if (handle == 1 && IguanaConfig.restrictedFlintParts.contains((partIndex = IguanaTweaksTConstruct.toolParts.indexOf(event.tool.getHandleItem())) + 1)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            if (event.tool != TContent.arrow && accessory == 1 && IguanaConfig.restrictedFlintParts.contains((partIndex = IguanaTweaksTConstruct.toolParts.indexOf(event.tool.getAccessoryItem())) + 1)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            if (extra == 1 && IguanaConfig.restrictedFlintParts.contains((partIndex = IguanaTweaksTConstruct.toolParts.indexOf(event.tool.getExtraItem())) + 1)) {
                event.setResult(Event.Result.DENY);
                return;
            }
        }
        if (event.tool != TContent.arrow) {
            String tip;
            ArrayList<String> tips = new ArrayList<String>();
            ArrayList<String> modifierTips = new ArrayList<String>();
            if (event.tool instanceof Pickaxe || event.tool instanceof Hammer) {
                String mLevel = IguanaTweaksTConstruct.getHarvestLevelName(toolTag.func_74762_e("HarvestLevel"));
                tips.add("Mining Level: " + mLevel);
                modifierTips.add("");
            }
            if (LevelsConfig.toolLeveling) {
                tips.add(IguanaLevelingLogic.getLevelTooltip(1));
                modifierTips.add("");
                toolTag.func_74768_a("ToolLevel", 1);
                toolTag.func_74772_a("ToolEXP", 0L);
                if (LevelsConfig.showTooltipXP) {
                    tips.add(IguanaLevelingLogic.getXpString(new ItemStack((Item)event.tool), false, toolTag));
                    modifierTips.add("");
                }
                if (ModifierConfig.levelingPickaxeBoost && (event.tool instanceof Pickaxe || event.tool instanceof Hammer)) {
                    int hLevel;
                    toolTag.func_74772_a("HeadEXP", 0L);
                    int n2 = hLevel = toolTag.func_74764_b("HarvestLevel") ? (hLevel = toolTag.func_74762_e("HarvestLevel")) : -1;
                    if (hLevel > 1 && hLevel < 16) {
                        if (LevelsConfig.showTooltipXP) {
                            tips.add(IguanaLevelingLogic.getXpString(new ItemStack((Item)event.tool), false, toolTag, true));
                            modifierTips.add("");
                        }
                        tips.add("\u00a76Requires boost");
                        modifierTips.add("");
                    }
                }
            }
            int tipNum = 0;
            while (toolTag.func_74764_b(tip = "Tooltip" + ++tipNum)) {
                tips.add(toolTag.func_74779_i(tip));
                modifierTips.add(toolTag.func_74779_i("ModifierTip" + tipNum));
                toolTag.func_82580_o(tip);
                toolTag.func_82580_o("ModifierTip" + tipNum);
            }
            for (int i = 1; i <= tips.size(); ++i) {
                if (tips.get(i - 1) == null) continue;
                toolTag.func_74778_a("Tooltip" + i, (String)tips.get(i - 1));
                if (modifierTips.get(i - 1) != null) {
                    toolTag.func_74778_a("ModifierTip" + i, (String)modifierTips.get(i - 1));
                    continue;
                }
                toolTag.func_74778_a("ModifierTip" + i, "");
            }
            if (LevelsConfig.toolLeveling && LevelsConfig.toolLevelingExtraModifiers) {
                toolTag.func_74768_a("Modifiers", Math.max(toolTag.func_74762_e("Modifiers") - 3 + LevelsConfig.startingModifiers, LevelsConfig.startingModifiers));
            }
            if (event.tool == TContent.hammer || event.tool == TContent.excavator || event.tool == TContent.lumberaxe) {
                ArrayList<String> replaceTags = new ArrayList<String>(Arrays.asList("MiningSpeed", "MiningSpeed2", "MiningSpeedHandle", "MiningSpeedExtra"));
                for (String replaceTag : replaceTags) {
                    if (!toolTag.func_74764_b(replaceTag)) continue;
                    toolTag.func_74768_a(replaceTag, Math.round((float)toolTag.func_74762_e(replaceTag) / 2.0f));
                }
            }
        }
    }

    @ForgeSubscribe
    public void craftPart(PartBuilderEvent.NormalPart event) {
        PatternBuilder.MaterialSet mat;
        PatternBuilder.ItemKey key = PatternBuilder.instance.getItemKey(event.material);
        if (key != null && (mat = (PatternBuilder.MaterialSet)PatternBuilder.instance.materialSets.get(key.key)) != null && (mat.materialID == 0 && IguanaConfig.restrictedWoodParts.contains(event.pattern.func_77960_j()) || mat.materialID == 1 && IguanaConfig.restrictedStoneParts.contains(event.pattern.func_77960_j()) || mat.materialID == 3 && IguanaConfig.restrictedFlintParts.contains(event.pattern.func_77960_j()) || mat.materialID == 4 && IguanaConfig.restrictedCactusParts.contains(event.pattern.func_77960_j()) || mat.materialID == 5 && IguanaConfig.restrictedBoneParts.contains(event.pattern.func_77960_j()) || mat.materialID == 8 && IguanaConfig.restrictedSlimeParts.contains(event.pattern.func_77960_j()) || mat.materialID == 9 && IguanaConfig.restrictedPaperParts.contains(event.pattern.func_77960_j()) || mat.materialID == 17 && IguanaConfig.restrictedSlimeParts.contains(event.pattern.func_77960_j()))) {
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @ForgeSubscribe
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.block != null && IguanaConfig.removeFlintDrop && event.block != null && event.block instanceof BlockGravel) {
            boolean addGravel = false;
            Iterator it = event.drops.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (stack == null || stack.field_77993_c != Item.field_77804_ap.field_77779_bT) continue;
                it.remove();
                addGravel = true;
            }
            if (addGravel) {
                event.drops.add(new ItemStack(Block.field_71940_F));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (LevelsConfig.toolLeveling && LevelsConfig.showDebugXP) {
            ItemStack equipped;
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (!player.field_70128_L && mc.field_71474_y.field_74330_P && (equipped = player.func_71045_bC()) != null && equipped.func_77973_b() != null && equipped.func_77973_b() instanceof ToolCore) {
                int hLevel;
                NBTTagCompound tags = equipped.func_77978_p().func_74775_l("InfiTool");
                int level = tags.func_74762_e("ToolLevel");
                hLevel = tags.func_74764_b("HarvestLevel") ? (hLevel = tags.func_74762_e("HarvestLevel")) : -1;
                event.left.add("");
                if (LevelsConfig.showTooltipXP) {
                    if (level < LevelsConfig.maxlevel) {
                        event.left.add(IguanaLevelingLogic.getXpString(equipped, true));
                    }
                    if (ModifierConfig.levelingPickaxeBoost && hLevel > 1 && hLevel < 16 && !tags.func_74764_b("HarvestLevelModified") && (equipped.func_77973_b() instanceof Pickaxe || equipped.func_77973_b() instanceof Hammer)) {
                        event.left.add(IguanaLevelingLogic.getXpString(equipped, true, true));
                    }
                }
            }
        }
    }
}

