/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public enum SideOffset {
    UNKNOWN(0, 0, 0),
    UP(0, 1, 0),
    UP_NORTH(0, 1, -1),
    UP_SOUTH(0, 1, 1),
    UP_WEST(-1, 1, 0),
    UP_EAST(1, 1, 0),
    UP_NORTH_WEST(-1, 1, -1),
    UP_NORTH_EAST(1, 1, -1),
    UP_SOUTH_WEST(-1, 1, 1),
    UP_SOUTH_EAST(1, 1, 1),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0),
    NORTH_WEST(-1, 0, -1),
    NORTH_EAST(1, 0, -1),
    SOUTH_WEST(-1, 0, 1),
    SOUTH_EAST(1, 0, 1),
    DOWN(0, -1, 0),
    DOWN_NORTH(0, -1, -1),
    DOWN_SOUTH(0, -1, 1),
    DOWN_WEST(-1, -1, 0),
    DOWN_EAST(1, -1, 0),
    DOWN_NORTH_WEST(-1, -1, -1),
    DOWN_NORTH_EAST(1, -1, -1),
    DOWN_SOUTH_WEST(-1, -1, 1),
    DOWN_SOUTH_EAST(1, -1, 1);

    public static SideOffset[] ADJACENT_CUBE;
    public static SideOffset[] ADJACENT_CUBE_INVERTED;
    public static SideOffset[] ADJACENT_SPHERE;
    public static SideOffset[] ADJACENT_SPHERE_INVERTED;
    public static SideOffset[] ADJACENT;
    public static SideOffset[] ADJACENT_INVERTED;
    public static SideOffset[] SIDES;
    public static final Map<Integer, SideOffset> lookup;
    public final int offsetX;
    public final int offsetY;
    public final int offsetZ;
    public final int flag;

    private SideOffset(int n2, int n3, int n4) {
        this.offsetX = n2;
        this.offsetY = n3;
        this.offsetZ = n4;
        int n5 = (n3 & 3) << 0 | (n4 & 3) << 2 | (n2 & 3) << 4;
        n5 ^= n5 & 0x15 & (n5 & 0x2A) >> 1;
        this.flag = n5;
    }

    public SideOffset getOpposite() {
        int n = ~this.flag & 0x3F;
        int n2 = n & 0x15 & (n & 0x2A) >> 1;
        return lookup.get(n &= ~(n2 | n2 << 1));
    }

    static {
        ADJACENT_CUBE = new SideOffset[]{UP, NORTH, SOUTH, WEST, EAST, NORTH_WEST, NORTH_EAST, SOUTH_WEST, SOUTH_EAST, DOWN, UP_NORTH, UP_SOUTH, UP_WEST, UP_EAST, UP_NORTH_WEST, UP_NORTH_EAST, UP_SOUTH_WEST, UP_SOUTH_EAST, DOWN_NORTH, DOWN_SOUTH, DOWN_WEST, DOWN_EAST, DOWN_NORTH_WEST, DOWN_NORTH_EAST, DOWN_SOUTH_WEST, DOWN_SOUTH_EAST};
        ADJACENT_CUBE_INVERTED = new SideOffset[]{DOWN, NORTH, SOUTH, WEST, EAST, NORTH_WEST, NORTH_EAST, SOUTH_WEST, SOUTH_EAST, UP, DOWN_NORTH, DOWN_SOUTH, DOWN_WEST, DOWN_EAST, DOWN_NORTH_WEST, DOWN_NORTH_EAST, DOWN_SOUTH_WEST, DOWN_SOUTH_EAST, UP_NORTH, UP_SOUTH, UP_WEST, UP_EAST, UP_NORTH_WEST, UP_NORTH_EAST, UP_SOUTH_WEST, UP_SOUTH_EAST};
        ADJACENT_SPHERE = new SideOffset[]{UP, NORTH, SOUTH, WEST, EAST, DOWN, UP_NORTH, UP_SOUTH, UP_WEST, UP_EAST, NORTH_WEST, NORTH_EAST, SOUTH_WEST, SOUTH_EAST, DOWN_NORTH, DOWN_SOUTH, DOWN_WEST, DOWN_EAST};
        ADJACENT_SPHERE_INVERTED = new SideOffset[]{DOWN, NORTH, SOUTH, WEST, EAST, UP, DOWN_NORTH, DOWN_SOUTH, DOWN_WEST, DOWN_EAST, NORTH_WEST, NORTH_EAST, SOUTH_WEST, SOUTH_EAST, UP_NORTH, UP_SOUTH, UP_WEST, UP_EAST};
        ADJACENT = new SideOffset[]{UP, NORTH, SOUTH, WEST, EAST, DOWN};
        ADJACENT_INVERTED = new SideOffset[]{DOWN, NORTH, SOUTH, WEST, EAST, UP};
        SIDES = new SideOffset[]{NORTH, SOUTH, WEST, EAST};
        HashMap<Integer, SideOffset> hashMap = new HashMap<Integer, SideOffset>();
        int n = 64;
        while (n-- > 0) {
            hashMap.put(n, UNKNOWN);
        }
        for (SideOffset sideOffset : SideOffset.values()) {
            hashMap.put(sideOffset.flag, sideOffset);
        }
        lookup = ImmutableMap.copyOf(hashMap);
    }
}

