/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.net;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneEnergyNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class GridTickHandler
implements IScheduledTickHandler {
    private EnumSet<TickType> ticks = EnumSet.of(TickType.SERVER);
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGridsToRegenerate = new LinkedHashSet();
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGridsToAdd = new LinkedHashSet();
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGrids = new LinkedHashSet();
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGridsToRemove = new LinkedHashSet();
    private static LinkedHashSet<TileEntityRedNetEnergy> conduit = new LinkedHashSet();
    private static LinkedHashSet<TileEntityRedNetEnergy> conduitToAdd = new LinkedHashSet();
    private static LinkedHashSet<TileEntityRedNetEnergy> conduitToUpd = new LinkedHashSet();
    static GridTickHandler instance = new GridTickHandler();

    public static void addGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        tickingGridsToAdd.add(redstoneEnergyNetwork);
        tickingGridsToRemove.remove(redstoneEnergyNetwork);
    }

    public static void removeGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        tickingGridsToRemove.add(redstoneEnergyNetwork);
        tickingGridsToAdd.remove(redstoneEnergyNetwork);
    }

    public static void regenerateGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        tickingGridsToRegenerate.add(redstoneEnergyNetwork);
    }

    public static boolean isGridTicking(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        return tickingGrids.contains(redstoneEnergyNetwork);
    }

    public static void addConduitForTick(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        conduitToAdd.add(tileEntityRedNetEnergy);
    }

    public static void addConduitForUpdate(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        conduitToUpd.add(tileEntityRedNetEnergy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickStart(EnumSet<TickType> enumSet, Object ... objectArray) {
        if (!tickingGridsToRegenerate.isEmpty()) {
            LinkedHashSet<RedstoneEnergyNetwork> object2 = tickingGridsToRegenerate;
            synchronized (object2) {
                for (RedstoneEnergyNetwork redstoneEnergyNetwork : tickingGridsToRegenerate) {
                    redstoneEnergyNetwork.markSweep();
                }
            }
        }
        if (!conduitToUpd.isEmpty()) {
            LinkedHashSet<TileEntityRedNetEnergy> linkedHashSet = conduitToUpd;
            synchronized (linkedHashSet) {
                conduit.addAll(conduitToUpd);
                conduitToUpd.clear();
            }
        }
        if (!conduit.isEmpty()) {
            Object var3_6 = null;
            try {
                for (TileEntityRedNetEnergy tileEntityRedNetEnergy : conduit) {
                    if (tileEntityRedNetEnergy.func_70320_p()) continue;
                    tileEntityRedNetEnergy.updateInternalTypes();
                }
                conduit.clear();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Crashing on conduit " + var3_6, throwable);
            }
        }
        if (!tickingGrids.isEmpty()) {
            for (RedstoneEnergyNetwork redstoneEnergyNetwork : tickingGrids) {
                redstoneEnergyNetwork.doGridPreUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEnd(EnumSet<TickType> enumSet, Object ... objectArray) {
        if (!tickingGridsToRemove.isEmpty()) {
            LinkedHashSet<RedstoneEnergyNetwork> object3 = tickingGridsToRemove;
            synchronized (object3) {
                tickingGrids.removeAll(tickingGridsToRemove);
                tickingGridsToRemove.clear();
            }
        }
        if (!tickingGridsToAdd.isEmpty()) {
            LinkedHashSet<RedstoneEnergyNetwork> linkedHashSet = tickingGridsToAdd;
            synchronized (linkedHashSet) {
                tickingGrids.addAll(tickingGridsToAdd);
                tickingGridsToAdd.clear();
            }
        }
        if (!tickingGrids.isEmpty()) {
            for (RedstoneEnergyNetwork redstoneEnergyNetwork : tickingGrids) {
                redstoneEnergyNetwork.doGridUpdate();
            }
        }
        if (!conduitToAdd.isEmpty()) {
            LinkedHashSet<TileEntityRedNetEnergy> linkedHashSet = conduitToAdd;
            synchronized (linkedHashSet) {
                conduit.addAll(conduitToAdd);
                conduitToAdd.clear();
            }
        }
        if (!conduit.isEmpty()) {
            Object var3_10 = null;
            try {
                for (TileEntityRedNetEnergy tileEntityRedNetEnergy : conduit) {
                    if (tileEntityRedNetEnergy.func_70320_p()) continue;
                    tileEntityRedNetEnergy.firstTick();
                }
                conduit.clear();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Crashing on conduit " + var3_10, throwable);
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return this.ticks;
    }

    public String getLabel() {
        return "MFR EnergyNet";
    }

    public int nextTickSpacing() {
        return 1;
    }
}

