/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquidGenerator;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerLiquidGenerator;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityGenerator;

public abstract class TileEntityLiquidGenerator
extends TileEntityGenerator
implements ITankContainerBucketable {
    private int _liquidConsumedPerTick;
    private int _powerProducedPerConsumption;

    public TileEntityLiquidGenerator(Machine machine, int n, int n2) {
        this(machine, n, machine.getActivationEnergy() * n2, n2);
    }

    public TileEntityLiquidGenerator(Machine machine, int n, int n2, int n3) {
        super(machine, n3);
        this._powerProducedPerConsumption = n2;
        this._liquidConsumedPerTick = n;
    }

    @Override
    protected boolean consumeFuel() {
        FluidStack fluidStack = this.drain(ForgeDirection.UNKNOWN, this._liquidConsumedPerTick, false);
        if (fluidStack == null || fluidStack.amount != this._liquidConsumedPerTick) {
            return false;
        }
        this.drain(ForgeDirection.UNKNOWN, this._liquidConsumedPerTick, true);
        return true;
    }

    @Override
    protected boolean canConsumeFuel(int n) {
        return n >= this._powerProducedPerConsumption;
    }

    @Override
    protected int produceEnergy() {
        return this._powerProducedPerConsumption;
    }

    protected abstract boolean isFluidFuel(FluidStack var1);

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    protected String getFluidName(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        String string = fluidStack.getFluid().getName();
        if (string == null) {
            return null;
        }
        return string.trim().toLowerCase();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquidGenerator((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerLiquidGenerator getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLiquidGenerator(this, inventoryPlayer);
    }

    @Override
    public String getGuiBackground() {
        return "biofuelgenerator.png";
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && this.isFluidFuel(fluidStack)) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (fluidTank.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

