/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.rockdigger.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import nl.lang2619.rockdigger.RockDigger;
import nl.lang2619.rockdigger.config.BlockConfig;
import org.apache.commons.io.FileUtils;

public class ConfigLoader {
    private static final String TEMPLATE_NAME = "_template.json";
    private static final String RESOURCES_TEMPLATE_PATH = "/assets/" + "RockDigger".toLowerCase() + "/" + "_template.json";
    private static final Pattern CONFIG_PATTERN = Pattern.compile("^[^_].*\\.json");
    private static ConfigLoader _instance = null;

    private ConfigLoader() {
    }

    public static ConfigLoader getInstance() {
        if (_instance == null) {
            _instance = new ConfigLoader();
        }
        return _instance;
    }

    public File init(String configDirectory) throws IOException {
        File template;
        File rootFolder = new File(configDirectory);
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        if (!(template = new File(configDirectory, TEMPLATE_NAME)).exists()) {
            try {
                File resourcesTemplate = new File(this.getClass().getResource(RESOURCES_TEMPLATE_PATH).toURI());
                FileUtils.copyFile((File)resourcesTemplate, (File)template);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return rootFolder;
    }

    public List<BlockConfig> findBlocks(File rootFolder) {
        return this.findBlocks(rootFolder, rootFolder);
    }

    public List<BlockConfig> findBlocks(File rootFolder, File currentFolder) {
        LinkedList configs = Lists.newLinkedList();
        for (File file : currentFolder.listFiles()) {
            if (file.isFile() && CONFIG_PATTERN.matcher(file.getName()).matches()) {
                try {
                    BlockConfig config = this.loadBlock(file);
                    config.setConfigLocation(currentFolder.getAbsolutePath());
                    configs.add(config);
                    RockDigger.log("loaded config " + file.getName() + ".", Level.FINE);
                }
                catch (JsonSyntaxException e) {
                    RockDigger.log("The config " + file.getName() + " has an invalid syntax.", Level.SEVERE);
                    System.err.println((Object)e);
                }
                catch (JsonIOException e) {
                    RockDigger.log("Something went wrong while reading " + file.getName() + ".", Level.SEVERE);
                    System.err.println((Object)e);
                }
                continue;
            }
            if (file.isDirectory()) {
                configs.addAll(this.findBlocks(file));
                continue;
            }
            RockDigger.log("Skipped config " + file.getName() + ".", Level.FINE);
        }
        return configs;
    }

    public BlockConfig loadBlock(File file) throws JsonSyntaxException, JsonIOException {
        Gson gson = new Gson();
        try {
            return (BlockConfig)gson.fromJson((Reader)new BufferedReader(new FileReader(file)), BlockConfig.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

