/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentSlider;
import openmods.gui.component.IComponentListener;
import openmods.sync.SyncableInt;
import org.lwjgl.opengl.GL11;

public class GuiComponentColorPicker
extends BaseComponent
implements IComponentListener {
    private GuiComponentSlider slider;
    private SyncableInt color;
    private int pointX = 0;
    private int pointY = 0;
    private SyncableInt tone = new SyncableInt();

    public GuiComponentColorPicker(int x, int y, SyncableInt color) {
        super(x, y);
        this.color = color;
        this.setFromColor(color.getValue());
        this.slider = new GuiComponentSlider(0, 55, 100, 0, 255, this.tone, false);
        this.slider.addListener(this);
        this.addComponent(this.slider);
    }

    public SyncableInt getColor() {
        return this.color;
    }

    public void setFromColor(int col) {
        float[] hsb = new float[3];
        Color.RGBtoHSB((col & 0xFF0000) >> 16, (col & 0xFF00) >> 8, col & 0xFF, hsb);
        this.pointX = (int)(hsb[0] * 100.0f);
        this.pointY = (int)((1.0f - hsb[2]) * 50.0f);
        this.tone.setValue(255 - (int)(hsb[1] * 255.0f));
    }

    @Override
    public int getWidth() {
        return 100;
    }

    @Override
    public int getHeight() {
        return 70;
    }

    public int getColorsHeight() {
        return this.getHeight() - 20;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (mouseY > this.getColorsHeight()) {
            return;
        }
        this.pointX = mouseX;
        this.pointY = mouseY;
        this.calculateColor();
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int button, long time) {
        super.mouseClickMove(mouseX, mouseY, button, time);
        if (mouseY > this.getColorsHeight()) {
            return;
        }
        this.pointX = mouseX;
        this.pointY = mouseY;
        this.calculateColor();
    }

    public void calculateColor() {
        float h = (float)this.pointX * 0.01f;
        float b = 1.0f - (float)this.pointY * 0.02f;
        float s = 1.0f - (float)this.tone.getValue() / 255.0f;
        int col = Color.HSBtoRGB(h, s, b) & 0xFFFFFF;
        this.color.setValue(col);
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int renderX = offsetX + this.x;
        int renderY = offsetY + this.y;
        this.bindComponentsSheet();
        this.func_73729_b(renderX, renderY, 156, 206, this.getWidth(), this.getColorsHeight());
        GuiComponentColorPicker.func_73734_a((int)renderX, (int)renderY, (int)(renderX + this.getWidth()), (int)(renderY + this.getColorsHeight()), (int)(this.tone.getValue() << 24 | 0xFFFFFF));
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        tessellator.func_78382_b();
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 1.0f);
        tessellator.func_78377_a((double)renderX, (double)renderY + (double)this.getColorsHeight(), 0.0);
        tessellator.func_78377_a((double)renderX + (double)this.getWidth(), (double)renderY + (double)this.getColorsHeight(), 0.0);
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.0f);
        tessellator.func_78377_a((double)renderX + (double)this.getWidth(), (double)renderY, 0.0);
        tessellator.func_78377_a((double)renderX, (double)renderY, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GuiComponentColorPicker.func_73734_a((int)(renderX + this.pointX - 1), (int)(renderY + this.pointY - 1), (int)(renderX + this.pointX + 1), (int)(renderY + this.pointY + 1), (int)-859045888);
    }

    @Override
    public void componentMouseDown(BaseComponent component, int offsetX, int offsetY, int button) {
    }

    @Override
    public void componentMouseDrag(BaseComponent component, int offsetX, int offsetY, int button, long time) {
        this.calculateColor();
    }

    @Override
    public void componentMouseMove(BaseComponent component, int offsetX, int offsetY) {
    }

    @Override
    public void componentMouseUp(BaseComponent component, int offsetX, int offsetY, int button) {
        this.calculateColor();
    }

    @Override
    public void componentKeyTyped(BaseComponent component, char par1, int par2) {
    }
}

