/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableNBT
extends SyncableObjectBase {
    private NBTTagCompound tag;

    public SyncableNBT() {
        this.tag = new NBTTagCompound();
    }

    public SyncableNBT(NBTTagCompound nbt) {
        this.tag = nbt;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public void setTag(NBTTagCompound tag) {
        this.tag = tag;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        short length = stream.readShort();
        if (length < 0) {
            this.tag = null;
        } else {
            byte[] abyte = new byte[length];
            stream.readFully(abyte);
            this.tag = CompressedStreamTools.func_74792_a((byte[])abyte);
        }
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        if (this.tag == null) {
            stream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)this.tag);
            stream.writeShort((short)abyte.length);
            stream.write(abyte);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74766_a(name, nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        nbt.func_74775_l(name);
    }
}

